ilter->order->dir == 'desc') {
					$ordering->orderUp = 'orderdown';
					$ordering->orderDown = 'orderup';
					$ordering->reverse = true;
				}
			}
			$this->assignRef('ordering', $ordering);
		}
	}

	public function pay($tpl = null) {
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$ctrl = '';
		$cancelUrl = urlencode(base64_encode(hikamarket::completeLink('vendor')));
		$this->paramBase .= '.pay';

		$vendor_id = hikamarket::getCID();
		$vendor_ids = hikaInput::get()->get('cid', array(), 'array');
		if(!empty($vendor_ids) && count($vendor_ids) > 1) {
			$vendor_id = $vendor_ids;
			hikamarket::toInteger($vendor_id);
		}

		if(empty($vendor_id)) {
			$app->redirect(hikamarket::completeLink('vendor'));
			return false;
		}
		$this->assignRef('vendor_id', $vendor_id);

		$config = hikamarket::config();
		$this->assignRef('config', $config);

		$feeMode = ($this->config->get('market_mode', 'fee') == 'fee');
		$this->assignRef('feeMode', $feeMode);

		$valid_statuses = explode(',', $config->get('valid_order_statuses', 'confirmed,shipped'));
		foreach($valid_statuses as &$status) {
			$status = $db->Quote($status);
		}

		$this->loadRef(array(
			'vendorClass' => 'class.vendor',
			'toggleHelper' => 'helper.toggle',
			'currencyHelper' => 'shop.class.currency',
			'paymentMethods' => 'type.paymentmethods',
			'popup' => 'shop.helper.popup',
		));

		$pageInfo = new stdClass();
		$pageInfo->filter = new stdClass();
		$this->assignRef('pageInfo', $pageInfo);

		if(!is_array($vendor_id)) {
			$vendor = $this->vendorClass->get($vendor_id);
			$this->assignRef('vendor', $vendor);

			$title = JText::sprintf('VENDOR_PAY', $vendor->vendor_name);
			$cancelUrl = urlencode(base64_encode(hikamarket::completeLink('vendor&task=pay&cid[]='.$vendor_id)));
			$ctrl = '&task=pay&cid[]='.$vendor_id;

			$this->assignRef('cancelUrl', $cancelUrl);

			$query = 'SELECT t.*, o.*, u.* '.
				' FROM '.hikamarket::table('order_transaction').' AS t '.
				' LEFT JOIN '.hikamarket::table('shop.order').' AS o ON o.order_type = '.$db->Quote('subsale').' AND o.order_parent_id = t.order_id AND o.order_vendor_id = '.$vendor_id . ' '.
				' LEFT JOIN '.hikamarket::table('shop.user').' AS u ON o.order_user_id = u.user_id '.
				' WHERE t.order_transaction_paid = 0 AND t.order_transaction_valid > 0 AND t.order_transaction_price != 0.0 AND t.vendor_id = '.$vendor_id.''.
				' ORDER BY t.order_transaction_created DESC, o.order_invoice_created DESC, o.order_created DESC, o.order_id DESC';
			$db->setQuery($query);
			$orders = $db->loadObjectList();
			$this->assignRef('orders', $orders);
		} else {
			$query = 'SELECT v.* FROM ' . hikamarket::table('vendor') . ' AS v WHERE vendor_id IN ('.implode(',', $vendor_id).')';
			$db->setQuery($query);
			$vendors = $db->loadObjectList('vendor_id');
			$this->assignRef('vendors', $vendors);

			$vendor_names = array();
			foreach($vendors as &$v) {
				$vendor_names[] = $v->vendor_name;
				$v->nb_orders = 0;
				$v->total_vendor_price = 0.0;
				$v->total_full_price = 0.0;
			}
			unset($v);
			$vendor_names = implode(', ', array_slice($vendor_names, 0, 5));

			$title = JText::sprintf('VENDOR_PAY', $vendor_names);

			$pageInfo->filter->filter_start = $app->getUserStateFromRequest($this->paramBase.'.filter_start', 'filter_start', '', 'string');
			$pageInfo->filter->filter_end = $app->getUserStateFromRequest($this->paramBase.'.filter_end', 'filter_end', '', 'string');

			$filters = array(
				'vendor_id' => 't.vendor_id IN ('.implode(',', $vendor_id).')',
				'transaction_price' => 't.order_transaction_price != 0',
				'transaction_paid' => 't.order_transaction_paid = 0',
				'transaction_valid' => 't.order_transaction_valid > 0'
			);
			$date_filters = '';
			if(!empty($pageInfo->filter->filter_start)) {
				$parts = explode(' ', $pageInfo->filter->filter_start);
				$parts = explode('-', $parts[0]);
				$start = hikamarket::getTime(mktime(0, 0, 0, $parts[1], $parts[2], $parts[0]));

				$filters['date_start'] = 't.order_transaction_created >= ' . (int)$start;
			}
			if(!empty($pageInfo->filter->filter_end)) {
				$parts = explode(' ', $pageInfo->filter->filter_end);
				$parts = explode('-', $parts[0]);
				$end = hikamarket::getTime(mktime(23, 59, 59, $parts[1], $parts[2], $parts[0]));

				$filters['date_end'] = 't.order_transaction_created <= ' . (int)$end;
			}

			$query = 'SELECT t.vendor_id, t.order_transaction_currency_id, COUNT(t.order_transaction_id) AS `nb_orders`, SUM(t.order_transaction_price) AS `total_vendor_price`, SUM(o.order_full_price) AS `total_full_price` '.
					' FROM '.hikamarket::table('order_transaction').' AS t '.
					' LEFT JOIN '.hikamarket::table('shop.order').' AS o ON t.order_id = o.order_parent_id AND t.vendor_id = o.order_vendor_id '.
					' WHERE ('.implode(') AND (', $filters) .')'.
					' GROUP BY t.vendor_id, t.order_transaction_currency_id';
			$db->setQuery($query);
			$transactions = $db->loadObjectList();
			foreach($transactions as $transaction) {
				if(empty($vendors[ (int)$transaction->vendor_id ]))
					continue;
				$vendors[ (int)$transaction->vendor_id ]->nb_orders += (int)$transaction->nb_orders;

				$vendor_currency_id = (int)$vendors[ (int)$transaction->vendor_id ]->vendor_currency_id;
				if($vendor_currency_id == (int)$transaction->order_transaction_currenc