 = $fieldsClass->getData('backend_listing', 'product', false, $categories);
		$this->assignRef('fields', $fields);
		$this->assignRef('fieldsClass', $fieldsClass);

		foreach($fields as $fieldName => $oneExtraField) {
			$searchMap[] = 'product.' . $fieldName;
		}

		if($pageInfo->filter->vendors == 0) {
			$filters['main'] .= ' OR parent_product.product_id != 0 ) AND (product.product_vendor_id IN (0, 1)';
		} elseif( $pageInfo->filter->vendors > 1) {
			$filters['main'] .= ' OR parent_product.product_id != 0 ) AND (product.product_vendor_id = '.(int)$pageInfo->filter->vendors;
		}

		$order = '';
		$this->processFilters($filters, $order, $searchMap, array('product.'));

		$query = 'FROM '.hikamarket::table($cfg['table']).' AS product '.$join.$filters.$order;
		$db->setQuery('SELECT DISTINCT product.*' . (empty($select)?'':',') . implode(',', $select) . ' ' . $query, (int)$pageInfo->limit->start, (int)$pageInfo->limit->value);

		$rows = $db->loadObjectList('product_id');

		$products = array();
		$vendor_ids = array();
		foreach($rows as &$product) {
			$product->prices = array();
			$product->file_name = $product->product_name;
			if(!isset($products[$product->product_id])) {
				$products[$product->product_id] =& $product;
			} else if(!is_array($products[$product->product_id])) {
				$old =& $products[$product->product_id];
				unset($products[$product->product_id]);
				$products[$product->product_id] = array(&$old, &$product);
			} else {
				$products[$product->product_id][] =& $product;
			}

			if((int)$product->product_vendor_id > 0)
				$vendor_ids[ (int)$product->product_vendor_id ] = (int)$product->product_vendor_id;
		}
		unset($product);
		$this->assignRef('products', $rows);

		$this->loadPricesImages($products);

		$db->setQuery('SELECT COUNT(DISTINCT(product.product_id)) '.$query);
		$pageInfo->elements = new stdClass();
		$pageInfo->elements->total = $db->loadResult();
		$pageInfo->elements->page = count($rows);

		$vendors = array();
		if(!empty($vendor_ids)) {
			$query = 'SELECT vendor_id, vendor_name FROM ' . hikamarket::table('vendor') . ' WHERE vendor_id IN ('.implode(',', $vendor_ids).')';
			$db->setQuery($query);
			$vendors = $db->loadObjectList('vendor_id');
		}
		$this->assignRef('vendors', $vendors);

		$this->toolbar = array(
			'approve' => array('name' => 'custom', 'icon' => 'publish', 'alt' => JText::_('HIKAM_APPROVE'), 'task' => 'approve', 'display' => $manage),
			'decline' => array(
				'name' => 'custom', 'icon' => 'unpublish', 'alt' => JText::_('HIKAM_DECLINE'), 'task' => 'decline',
				'display' => $manage && hikamarket::level(1)
			),
			'delete' => array(
				'name' => 'deleteList',
				'display' => $manage
			),
			'|',
			array('name' => 'pophelp', 'target' => 'vendor'),
			'dashboard'
		);
		$this->getPagination();

		$this->getOrdering('a.ordering', true);
		if(!empty($this->ordering->ordering)) {
			$this->toolbar['ordering']['display'] = true;
		}

		return true;
	}

	private function loadPricesImages(&$products) {
		if(empty($products))
			return;

		$db = JFactory::getDBO();
		$db->setQuery('SELECT * FROM '.hikamarket::table('shop.price').' WHERE price_product_id IN ('.implode(',', array_keys($products)).')');
		$prices = $db->loadObjectList();
		if(!empty($prices)) {
			foreach($prices as $price) {
				if(!isset($products[$price->price_product_id]) )
					continue;

				if(!is_array($products[$price->price_product_id])) {
					$products[$price->price_product_id]->prices[] = $price;
				} else {
					foreach($products[$price->price_product_id] as $p) {
						$p->prices[] = $price;
					}
				}
			}
		}
		unset($prices);

		$db->setQuery('SELECT * FROM '.hikamarket::table('shop.file').' WHERE file_ref_id IN ('.implode(',', array_keys($products)).') AND file_type=\'product\' ORDER BY file_ref_id ASC, file_ordering ASC, file_id ASC');
		$images = $db->loadObjectList();
		if(!empty($images)) {
			foreach($images as $image) {
				if(!isset($products[(int)$image->file_ref_id]))
					continue;

				if(!is_array($products[(int)$image->file_ref_id])) {
					if(isset($products[(int)$image->file_ref_id]->file_ref_id))
						continue;

					foreach(get_object_vars($image) as $key => $name) {
						$products[(int)$image->file_ref_id]->$key = $name;
					}
				} else {
					$p = reset($products[(int)$image->file_ref_id]);
					if(isset($p->file_ref_id))
						continue;

					foreach($products[(int)$image->file_ref_id] as $p) {
						foreach(get_object_vars($image) as $key => $name) {
							$p->$key = $name;
						}
					}
				}
			}
		}
	}

	public function confirm_action() {
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();

		$product_ids = hikaInput::get()->get('cid', array(), 'array');
		hikamarket::toInteger($product_ids);

		$url_params = '&task='.hikaInput::get()->getCmd('task');
		foreach($product_ids as $pid) {
			$url_params .= '&cid[]=' . $pid;
		}
		$url_params .= '&redirect='.hikaInput::get()->getCmd('redirect', '');

		$this->paramBase = HIKAMARKET_COMPONENT.'.'.$this->getName().'.waitingapproval';
		hikamarket::setTitle(JText::_('WAITING_APPROVAL_LIST'), self::icon, self::ctrl.$url_params);

		$config = hikamarket::config();
		$this->assignRef('config', $config);

		$this->loadRef(array(
			'currencyClass' => 'shop.class.currency',
			'imageHelper' => 'shop.helper.image',
			'productClass' => 'shop.class.product',
		));

		$action = hikaInput::get()->getCmd('action_to_confirm', null);
		if