license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php
class productmarketViewProductmarket extends hikamarketView {

	const ctrl = 'product';
	const name = 'HIKAMARKET_PRODUCTMARKET';
	const icon = 'thumbs-up';

	protected $triggerView = true;

	public function display($tpl = null, $params = null) {
		$this->paramBase = HIKAMARKET_COMPONENT.'.'.$this->getName();
		$fct = $this->getLayout();
		$ret = true;
		if(method_exists($this, $fct))
			$ret = $this->$fct($params);
		if($ret !== false)
			parent::display($tpl);
	}

	public function shop_block($params = null) {
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();

		$config = hikamarket::config();
		$this->assignRef('config', $config);

		$this->loadRef(array(
			'currencyClass' => 'shop.class.currency',
			'currencyType' => 'shop.type.currency',
			'popup' => 'shop.helper.popup'
		));

		$data = null;
		$product_id = 0;
		$product_type = 'main';

		if(!empty($params)) {
			$product_id = (int)$params->get('product_id');
			$product_type = $params->get('product_type');
		}

		if(hikamarket::level(1) && $product_id > 0) {
			$feeClass = hikamarket::get('class.fee');
			$data = $feeClass->getProduct($product_id);
			foreach($data as $k => $v) {
				if($v->fee_target_id != $product_id)
					unset($data[$k]);
			}
		}

		$this->assignRef('data', $data);
		$this->assignRef('product_id', $product_id);
		$this->assignRef('product_type', $product_type);
	}

	public function shop_form