 Open Source Matters. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @extension Phoca Extension
 * @copyright Copyright (C) Jan Pavelka www.phoca.cz
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
defined( '_JEXEC' ) or die();
jimport( 'joomla.application.component.view' );

class PhocaCartCpViewPhocacartZones extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	protected $t;
	protected $r;
	public $filterForm;
    public $activeFilters;

	function display($tpl = null) {

		$this->t			= PhocacartUtils::setVars('zone');
		$this->r 			= new PhocacartRenderAdminviews();
		$this->items			= $this->get('Items');
		$this->pagination		= $this->get('Pagination');
		$this->state			= $this->get('State');
		$this->filterForm   	= $this->get('FilterForm');
        $this->activeFilters 	= $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors), 500);
			return false;
		}

		// Preprocess the list of items to find ordering divisions.
		foreach ($this->items as &$item) {
			$this->ordering[0][] = $item->id;
		}

		$media = new PhocacartRenderAdminmedia();
		JHtml::stylesheet( $this->t['bootstrap'] . 'css/bootstrap.glyphicons-icons-only.min.css' );

		$this->addToolbar();
		parent::display($tpl);
	}

	function addToolbar() {

		require_once JPATH_COMPONENT.'/helpers/'.$this->t['tasks'].'.php';
		$state	= $this->get('State');
		$class	= ucfirst($this->t['tasks']).'Helper';
		$canDo	= $class::getActions($this->t, $state->get('filter.zone_id'));

		JToolbarHelper::title( JText::_( $this->t['l'].'_ZONES' ), 'globe' );

		if ($canDo->get('core.create')) {
			JToolbarHelper::addNew($this->t['task'].'.add','JTOOLBAR_NEW');
		}

		if ($canDo->get('core.edit')) {
			JToolbarHelper::editList($this->t['task'].'.edit','JTOOLBAR_EDIT');
		}
		if ($canDo->get('core.edit.state')) {

			JToolbarHelper::divider();
			JToolbarHelper::custom($this->t['tasks'].'.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			JToolbarHelper::custom($this->t['tasks'].'.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
		}

		if ($canDo->get('core.delete')) {
			JToolbarHelper::deleteList( $this->t['l'].'_WARNING_DELETE_ITEMS', 'phocacartzones.delete', $this->t['l'].'_DELETE');
		}

		JToolbarHelper::divider();
		JToolbarHelper::help( 'screen.'.$this->t['c'], true );
	}

	protected function getSortFields() {
		return array(
			'a.ordering'		=> JText::_('JGRID_HEADING_ORDERING'),
			'a.title' 			=> JText::_($this->t['l'] . '_TITLE'),
			'a.code2' 			=> JText::_($this->t['l'] . '_CODE2'),
			'a.code3' 			=> JText::_($this->t['l'] . '_CODE3'),
			'a.published' 		=> JText::_($this->t['l'] . '_PUBLISHED'),
			'a.id' 				=> JText::_('JGRID_HEADING_ID')
		);
	}
}
?>
PK     6[
5$  $    import/tmpl/default.phpnu [        <?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.0
	@build			13th July, 2022
	@created		13th July, 2022
	@package		Hilation
	@subpackage		default.php
	@author			farhad shahbazi <http://lmskaran.ir>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::_('jquery.framework');
JHtml::_('bootstrap.tooltip');
JHtml::_('script', 'system/core.js', false, true);
JHtml::_('behavior.keepalive');
?>
<script type="text/javascript">
<?php if ($this->hasPackage && HilationHelper::checkArray($this->headerList)) : ?>
	Joomla.continueImport = function()
	{
		var form = document.getElementById('adminForm');
		var error = false;
		var therequired = [<?php $i = 0; foreach($this->headerList as $name => $title) { echo ($i != 0)? ', "vdm_'.$name.'"':'"vdm_'.$name.'"'; $i++; } ?>];
		for(i = 0; i < therequired.length; i++)
		{
			if(jQuery('#'+therequired[i]).val() == "" )
			{
				error = true;
				break;
			}
		}
		// do field validation
		if (error)
		{
			alert("<?php echo JText::_('COM_HILATION_IMPORT_MSG_PLEASE_SELECT_ALL_COLUMNS', true); ?>");
		}
		else
		{
			jQuery('#loading').css('display', 'block');

			form.gettype.value = 'continue';
			form.submit();
		}
	};
<?php else: ?>
	Joomla.submitbutton = function()
	{
		var form = document.getElementById('adminForm');

		// do field validation
		if (form.import_package.value == "")
		{
			alert("<?php echo JText::_('COM_HILATION_IMPORT_MSG_PLEASE_SELECT_A_FILE', true); ?>");
		}
		else
		{
			jQuery('#loading').css('display', 'block');

			form.gettype.value = 'upload';
			form.submit();
		}
	};

	Joomla.submitbutton3 = function()
	{
		var form = document.getElementById('adminForm');

		// do field validation
		if (form.import_directory.value == ""){
			alert("<?php echo JText::_('COM_HILATION_IMPORT_MSG_PLEASE_SELECT_A_DIRECTORY', true); ?>");
		}
		else
		{
			jQuery('#loading').css('display', 'block');

			form.gettype.value = 'folder';
			form.submit();
		}
	};

	Joomla.submitbutton4 = function()
	{
		var form = document.getElementById('adminForm');

		// do field validation
		if (form.import_url.value == "" || form.import_url.value == "http://")
		{
			alert("<?php echo JText::_('COM_HILATION_IMPORT_MSG_ENTER_A_URL', true); ?>");
		}
		else
		{
			jQuery('#loading').css('display', 'block');

			form.gettype.value = 'url';
			form.submit();
		}
	};
<?php endif; ?>

// Add spindle-wheel for importations:
jQuery(document).ready(function($) {
	var outerDiv = $('body');

	$('<div id="loading"></div>')
		.css("background", "rgba(255, 255, 255, .8) url('components/com_hilation/assets/images/import.gif') 50% 15% no-repeat")
		.css("top", outerDiv.position().top - $(window).scrollTop())
		.css("left", outerDiv.position().left - $(window).scrollLeft())
		.css("width", outerDiv.width())
		.css("height", outerDiv.height())
		.css("position", "fixed")
		.css("opacity", "0.80")
		.css("-ms-filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity = 80)")
		.css("filter", "alpha(opacity = 80)")
		.css("display", "none")
		.appendTo(outerDiv);
});

</script>

<div id="installer-import" class="clearfix">
<form enctype="multipart/form-data" action="<?php echo JRoute::_('index.php?option=com_hilation&view=import');?>" method="post" name="adminForm" id="adminForm" class="form-horizontal form-validate">

	<?php if (!empty( $this->sidebar)) : ?>
		<div id="j-sidebar-container" class="span2">
			<?php echo $this->sidebar; ?>
		</div>
		<div id="j-main-container" class="span10">
	<?php else : ?>
		<div id="j-main-container">
	<?php endif;?>

	<?php if ($this->hasPackage && HilationHelper::checkArray($this->headerList) && HilationHelper::checkArray($this->headers)) : ?>
		<fieldset class="uploadform">
			<legend><?php echo JText::_('COM_HILATION_IMPORT_LINK_FILE_TO_TABLE_COLUMNS'); ?></legend>
			<div class="control-group">
				<label class="control-label" ><h4><?php echo JText::_('COM_HILATION_IMPORT_TABLE_COLUMNS'); ?></h4></label>
				<div class="controls">
					<label class="control-label" ><h4><?php echo JText::_('COM_HILATION_IMPORT_FILE_COLUMNS'); ?></h4></label>
				</div>
			</div>
			<?php foreach($this->headerList as $name => $title): ?>
				<div class="control-group">
					<label for="<?php echo $name; ?>" class="control-label" ><?php echo $title; ?></label>
					<div class="controls">
					<select  name="<?php echo $name; ?>"  id="vdm_<?php echo $name; ?>" required class="required input_box" >
						<option value=""><?php echo JText::_('COM_HILATION_IMPORT_PLEASE_SELECT_COLUMN'); ?></option>
						<option value="IGNORE"><?php echo JText::_('COM_HILATION_IMPORT_IGNORE_COLUMN'); ?></option>
						<?php foreach($this->headers as $value => $option): ?>
							<?php $selected = (strtolower($option) ==  strtolower ($title) || strtolower($option) == strtolower($name))? 'selected="selected"':''; ?>
							<option value="<?php echo HilationHelper::htmlEscape($value); ?>" class="required" <?php echo $selected ?>><?php echo HilationHelper::htmlEscape($option); ?></option>
						<?php endforeach; ?>
					</select>
					</div>
				</div>
			<?php endforeach; ?>
			<div class="form-actions">
				<input class="btn btn-primary" type="button" value="<?php echo JText::_('COM_HILATION_IMPORT_CONTINUE'); ?>" onclick="Joomla.continueImport()" />
			</div>
		</fieldset>
		<input type="hidden" name="gettype" value="continue" />
	<?php else: ?>
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'upload')); ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'upload', JText::_('COM_HILATION_IMPORT_FROM_UPLOAD', true)); ?>
			<fieldset class="uploadform">
				<legend><?php echo JText::_('COM_HILATION_IMPORT_UPDATE_DATA'); ?></legend>
				<div class="control-group">
					<label for="import_package" class="control-label"><?php echo JText::_('COM_HILATION_IMPORT_SELECT_FILE'); ?></label>
					<div class="controls">
						<input class="input_box" id="import_package" name="import_package" type="file" size="57" />
					</div>
				</div>
				<div class="form-actions">
					<input class="btn btn-primary" type="button" value="<?php echo JText::_('COM_HILATION_IMPORT_UPLOAD_BOTTON'); ?>" onclick="Joomla.submitbutton()" />&nbsp;&nbsp;&nbsp;<small><?php echo JText::_('COM_HILATION_IMPORT_FORMATS_ACCEPTED'); ?> (.csv .xls .ods)</small>
				</div>
			</fieldset>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		
		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'directory', JText::_('COM_HILATION_IMPORT_FROM_DIRECTORY', true)); ?>
			<fieldset class="uploadform">
				<legend><?php echo JText::_('COM_HILATION_IMPORT_UPDATE_DATA'); ?></legend>
				<div class="control-group">
					<label for="import_directory" class="control-label"><?php echo JText::_('COM_HILATION_IMPORT_SELECT_FILE_DIRECTORY'); ?></label>
					<div class="controls">
						<input type="text" id="import_directory" name="import_directory" class="span5 input_box" size="70" value="<?php echo $this->state->get('import.directory'); ?>" />
					</div>
				</div>
				<div class="form-actions">
					<input type="button" class="btn btn-primary" value="<?php echo JText::_('COM_HILATION_IMPORT_GET_BOTTON'); ?>" onclick="Joomla.submitbutton3()" />&nbsp;&nbsp;&nbsp;<small><?php echo JText::_('COM_HILATION_IMPORT_FORMATS_ACCEPTED'); ?> (.csv .xls .ods)</small>
				</div>
				</fieldset>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'url', JText::_('COM_HILATION_IMPORT_FROM_URL', true)); ?>
			<fieldset class="uploadform">
				<legend><?php echo JText::_('COM_HILATION_IMPORT_UPDATE_DATA'); ?></legend>
				<div class="control-group">
					<label for="import_url" class="control-label"><?php echo JText::_('COM_HILATION_IMPORT_SELECT_FILE_URL'); ?></label>
					<div class="controls">
						<input type="text" id="import_url" name="import_url" class="span5 input_box" size="70" value="http://" />
					</div>
				</div>
				<div class="form-actions">
					<input type="button" class="btn btn-primary" value="<?php echo JText::_('COM_HILATION_IMPORT_GET_BOTTON'); ?>" onclick="Joomla.submitbutton4()" />&nbsp;&nbsp;&nbsp;<small><?php echo JText::_('COM_HILATION_IMPORT_FORMATS_ACCEPTED'); ?> (.csv .xls .ods)</small>
				</div>
			</fieldset>
		<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
		<input type="hidden" name="gettype" value="upload" />
	<?php endif; ?>
	<input type="hidden" name="task" value="import.import" />
	<?php echo JHtml::_('form.token'); ?>
</form>
</div>PK     6[#o,   ,     molation/index.htmlnu [        <html><body bgcolor="#FFFFFF"></body></html>PK     6[ǆ      molation/tmpl/default.phpnu [        <?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.0
	@build			24th July, 2022
	@created		13th July, 2022
	@package		Molation
	@subpackage		default.php
	@author			farhad shahbazi <http://lmskaran.ir>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');

?>
<div id="j-main-container">
	<div class="span9">
		<?php echo JHtml::_('bootstrap.startAccordion', 'dashboard_left', array('active' => 'main')); ?>
			<?php echo JHtml::_('bootstrap.addSlide', 'dashboard_left', 'cPanel', 'main'); ?>
				<?php echo $this->loadTemplate('main');?>
			<?php echo JHtml::_('bootstrap.endSlide'); ?>
		<?php echo JHtml::_('bootstrap.endAccordion'); ?>
	</div>
	<div class="span3">
		<?php echo JHtml::_('bootstrap.startAccordion', 'dashboard_right', array('active' => 'vdm')); ?>
			<?php echo JHtml::_('bootstrap.addSlide', 'dashboard_right', 'lmskaran', 'vdm'); ?>
				<?php 