 View to manage all features tables.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 *
 * @since       2.0
 */
class JeaViewFeatures extends JViewLegacy
{
	/**
	 * Array of managed features
	 *
	 * @var stdClass[]
	 */
	protected $items;

	/**
	 * The model state
	 *
	 * @var Jobject
	 */
	protected $state;

	/**
	 * The sidebar output
	 *
	 * @var string
	 */
	protected $sidebar = '';

	/**
	 * Overrides parent method.
	 *
	 * @param   string  $tpl  The name of the template file to parse.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 *
	 * @see     JViewLegacy::display()
	 */
	public function display($tpl = null)
	{
		$this->items = $this->get('Items');
		$this->state = $this->get('State');

		JeaHelper::addSubmenu('features');

		$this->addToolbar();

		$this->sidebar = JHtmlSidebar::render();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return void
	 */
	protected function addToolbar()
	{
		$canDo = JeaHelper::getActions();

		JToolBarHelper::title(JText::_('COM_JEA_FEATURES_MANAGEMENT'), 'jea');

		if ($canDo->get('core.manage'))
		{
			JToolBarHelper::custom('features.import', 'database', '', 'Import', false);
		}

		JToolBarHelper::custom('features.export', 'download', '', 'Export', false);

		if ($canDo->get('core.admin'))
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_jea');
		}
	}
}
PK     o*[yv      feature/tmpl/edit.phpnu [        <?php
/**
 * This file is part of Joomla Estate Agency - Joomla! extension for real estate agency
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 * @copyright   Copyright (C) 2008 - 2020 PHILIP Sylvain. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var $this JeaViewFeature
 */
$app = JFactory::getApplication();
JHtml::_('formbehavior.chosen', 'select');
JHtml::stylesheet('media/com_jea/css/jea.admin.css');
?>
<form action="<?php echo JRoute::_('index.php?option=com_jea&layout=edit&id='.(int) $this->item->id) ?>"
	method="post" name="adminForm" id="adminForm" class="form-validate">

	<div class="form-horizontal">
	<?php foreach ($this->form->getFieldset('feature') as $field): ?>
		<?php echo $field->renderField() ?>
	<?php endforeach ?>
	</div>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="feature" value="<?php echo $this->state->get('feature.name')?>" />
		<input type="hidden" name="return" value="<?php echo $app->input->getCmd('return') ?>" />
		<?php echo JHtml::_('form.token') ?>
	</div>
</form>
PK     o*[ zӓ      feature/view.html.phpnu [        <?php
/**
 * This file is part of Joomla Estate Agency - Joomla! extension for real estate agency
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 * @copyright   Copyright (C) 2008 - 2020 PHILIP Sylvain. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View to edit a feature.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 *
 * @since       2.0
 */
class JeaViewFeature extends JViewLegacy
{
	/**
	 * The form object
	 *
	 * @var JForm
	 */
	protected $form;

	/**
	 * The database record
	 *
	 * @var JObject|boolean
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var JObject
	 */
	protected $state;

	/**
	 * Overrides parent method.
	 *
	 * @param   string  $tpl  The name of the template file to parse.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 *
	 * @see     JViewLegacy::display()
	 */
	public function display($tpl = null)
	{
		$this->form = $this->get('Form');
		$this->item = $this->get('Item');
		$this->state = $this->get('State');

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return void
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$canDo = JeaHelper::getActions();

		$title = $this->item->id ? JText::_('JACTION_EDIT') . ' ' . $this->escape($this->item->value) : JText::_('JACTION_CREATE');
		JToolBarHelper::title($title, 'jea');

		// For new records, check the create permission.
		if ($canDo->get('core.create'))
		{
			JToolBarHelper::apply('feature.apply');
			JToolBarHelper::save('feature.save');
			JToolBarHelper::save2new('feature.save2new');
		}

		JToolBarHelper::cancel('feature.cancel');
	}
}
PK     o*[hxO  O    properties/tmpl/default.phpnu [        <?php
/**
 * This file is part of Joomla Estate Agency - Joomla! extension for real estate agency
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 * @copyright   Copyright (C) 2008 - 2020 PHILIP Sylvain. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var $this JeaViewProperties
 */
JHtml::stylesheet('media/com_jea/css/jea.admin.css');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$listOrder     = $this->escape($this->state->get('list.ordering'));
$listDirection = $this->escape($this->state->get('list.direction'));

$saveOrder     = $listOrder == 'p.ordering';

if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_jea&task=properties.saveOrderAjax&tmpl=component';
	JHtml::_('sortablelist.sortable', 'propertiesList', 'adminForm', strtolower($listDirection), $saveOrderingUrl);
}
?>

<form action="<?php echo JRoute::_('index.php?option=com_jea&view=properties') ?>" method="post" name="adminForm" id="adminForm">

	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar ?>
	</div>

	<div id="j-main-container" class="span10">
		<?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)) ?>

		<?php if (empty($this->items)) : ?>
			<div class="alert aler