e dump window
		manually:</p>
		<ul>
			<li>Administrator: Go to Components -> J!Dump and click Popup.</li>
			<li>Site: Make a new menu item for J!Dump. Set it to 'Open in New
			Window'</li>
		</ul>
	</div>

	<div class="box orange">
		<p>Want updates? Follow <a href="http://twitter.com/mathiasverraes">@mathiasverraes</a>
		on Twitter and be the first to know.</p>
	</div>

	<div class="box blue">
		<h2>Using J!Dump</h2>
		<p>Anywhere in your code, type:</p>

		<code>dump($variable, 'Variable Name');</code>

		<p>Simple huh? 'Variable Name' is optional and can be anything you
		like. If you use a lot of dumps, you'll want to use some descriptive
		names.</p>

		<h2>Shortcuts</h2>
		<code>dumpSysinfo();</code>
		<p>Displays a whole bunch of system information.</p>

		<code>dumpTemplate($this);</code>
		<p>Use inside a template's index.php to dump the parameters.</p>

		<code>dumpMessage('Your message');</code>
		<p>Displays a custom message. Very handy to check if a function or a
		loop is executed etc...</p>
		<code>dumpTrace();</code>
		<p>Displays the backtrace.</p>
	</div>

	<div class="box green">
		<h2>Notes</h2>
		<ul>
			<li>This component is only meant to be used on development test
			sites, NOT in live or production environments. If you must use it on a
			live site, don't do stupid things like dump($password) !</li>
			<li>You can't use dump() in system plugins that are run before the
			J!Dump plugin is run, so it is best to use ordering in the plugin
			manager to put J!Dump upfront.</li>
		</ul>
	</div>

	<div class="box orange">
		<h2>Contributors</h2>
		<ul>
			<li><a href="http://twitter.com/mathiasverraes">Mathias Verraes</a> (Lead)</li>
			<li><a href="http://community.joomla.org/august-2008/author/70-jens-christian-skibakk.html">Jens-Christian Skibakk</a></li>
			<li><a href="http://www.alltogetherasawhole.org/profile/TomFuller">Tom Fuller</a></li>
		</ul>

		<p>Thanks to everybody who provided patches.</p>
	</div>

	<div class="box blue">
		<h2>Bugs</h2>
		<p>Found some bugs? <a
			href="https://github.com/mathiasverraes/jdump/issues">To the
		Bugmobile!</a> Be a <a
			href="http://stephenjungels.com/jungels.net/articles/diff-patch-ten-minutes.html">good
		boy or girl</a> and add a patch yourself :-) Ideas and feature requests are welcome as well.</p>
	</div>

	<div class="box green">
		<h2>Credits</h2>
		<p>This component includes Folder Tree Static by Alf Magne
		Kalleland. It is released under LGPL and can be found at
		http://www.dhtmlgoodies.com/</p>
	</div>

</div>PK     o*[{      about/view.html.phpnu [        <?php
/**
 * J!Dump
 * @version      $Id$
 * @package      jdump
 * @copyright    Copyright (C) 2006-2011 Mathias Verraes. All rights reserved.
 * @license      GNU/GPL
 * @link         https://github.com/mathiasverraes/jdump
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

class DumpViewAbout extends JViewLegacy 
{
	function display($tpl = null) 
	{
		$mainframe = JFactory::getApplication(); $option = JRequest::getCmd('option');

		// Toolbar
		JToolBarHelper::title( 'J!Dump v' . DUMP_VERSION );
		$bar = JToolBar::getInstance('toolbar');
		$bar->appendButton( 'Popup', 'default', 'Popup', "index.php?option=com_dump&view=tree&format=raw&closebutton=0" );
		JToolBarHelper::preferences( 'com_dump', '300' );

		parent::display($tpl);
	}
}
PK     o*[/vo      features/tmpl/default.phpnu [        <?php
/**
 * This file is part of Joomla Estate Agency - Joomla! extension for real estate agency
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 * @copyright   Copyright (C) 2008 - 2020 PHILIP Sylvain. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var $this JeaViewFeatures
 */

JHtml::stylesheet('media/com_jea/css/jea.admin.css');
JHtml::_('behavior.multiselect');
$count = 0;
?>

<form action="<?php echo JRoute::_('index.php?option=com_jea&view=properties') ?>" method="post" name="adminForm"
	id="adminForm" enctype="multipart/form-data">

	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>

	<div id="j-main-container" class="span10">
		<table class="table table-striped">
			<thead>
				<tr>
					<th width="1%" class="center">
						<?php echo JHtml::_('grid.checkall') ?>
					</th>
					<th width="60%">
						<?php echo JText::_('COM_JEA_HEADING_FEATURES_LIST_NAME') ?>
					</th>
					<th width="39%" class="center">
						<?php echo JText::_('COM_JEA_HEADING_FEATURES_IMPORT_CSV') ?>
					</th>
				</tr>
			</thead>

			<tbody>
			<?php foreach ($this->items as $i => $item) : $count++ ?>
				<tr class="row<?php echo $count % 2 ?>">
					<td>
						<?php echo JHtml::_('grid.id', $i, $item->name) ?>
					</td>

					<td>
						<a href="<?php echo JRoute::_('index.php?option=com_jea&view=featurelist&feature='.$item->name) ?>">
						<?php echo JText::_(JString::strtoupper("com_jea_list_of_{$item->name}_title")) ?>
						</a>
					</td>

					<td class="center">
						<input type="file" name="csv[<?php echo $item->name ?>]" value="" size="20" />
					</td>
				</tr>
			<?php endforeach ?>
			</tbody>
		</table>

		<div>
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_('form.token') ?>
		</div>
	</div>
</form>
PK     o*[[J      features/view.html.phpnu [        <?php
/**
 * This file is part of Joomla Estate Agency - Joomla! extension for real estate agency
 *
 * @package     Joomla.Administrator
 * @subpackage  com_jea
 * @copyright   Copyright (C) 2008 - 2020 PHILIP Sylvain. All rights reserved.
 * @license     GNU General Public License vers