<?php
/**
 * @package	HikaShop for Joomla!
 * @version	4.4.4
 * @author	hikashop.com
 * @copyright	(C) 2010-2021 HIKARI SOFTWARE. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?>

<form action="<?php echo $this->checkoutHelper->completeLink('cid='. $this->step, false, false, false, $this->itemid); ?>" method="post" id="hikashop_checkout_form" name="hikashop_checkout_form" enctype="multipart/form-data" onsubmit="if(window.checkout.onFormSubmit){ return window.checkout.onFormSubmit(this); }">
<input type="hidden" name="task" value="submitstep"/>
<input type="hidden" name="<?php echo hikashop_getFormToken(); ?>" id="hikashop_checkout_token" value="1"/>
<input type="hidden" name="cart_id" value="<?php echo $this->cart_id; ?>"/>
<input type="submit" style="display:none;"/>
<div id="hikashop_checkout" data-checkout-step="<?php echo $this->step; ?>" class="hikashop_checkout_page hikashop_checkout_page_step<?php echo $this->step; ?>">
	<div class="hikashop_checkout_loading_elem"></div>
	<div class="hikashop_checkout_loading_spinner"></div>
<!-- PROGRESS BAR -->
<?php
if((int)$this->config->get('display_checkout_bar', 2) > 0) {
	echo $this->displayBlock('bar', 0, array(
		'display_end' => ((int)$this->config->get('display_checkout_bar', 2) == 1)
	));
}
?>
<!-- EO PROGRESS BAR -->
<?php
if($this->hasSeparator)
	echo $this->displayBlock('separator', 0, array('type' => 'start'));
$handleEnter = array();
$last = 0;
?>
<!-- TOP EXTRA DATA -->
<?php
if(!empty($this->extraData['checkout']) && !empty($this->extraData['checkout']->checkout_top)) { echo implode("\r\n", $this->extraData['checkout']->checkout_top); }
?>
<!-- EO TOP EXTRA DATA -->

<!-- CHECKOUT -->
<?php
// dump($this->workflow['steps'][$this->workflow_step]['content']);
$stp=[];
foreach($this->workflow['steps'][$this->workflow_step]['content'] as $k => $content) {

	$handleEnter[] = 'window.checkout.handleEnter(\''.$content['task'].'\','.$this->step.','.$k.');';
	$stp[]= $content['task'];
	ob_start();
	echo $this->displayBlock($content['task'], $k, @$content['params']);
	$vn= 'm_'.$content['task'];
	$$vn = ob_get_contents();
	ob_end_clean();
	$last = $k;
}
?>
<div id="login-checkout">
	<?= $m_login;?>
</div>

<div id="carts-checkout">
	<?php if(in_array('cart',$stp)):?>
		<div id="main-checkout"> 
			<?= $m_cart;?>	
		</div>
	<?php endif;?>
	<?php if(!(in_array('login',$stp) && count($stp)== 1)):?>
		<div id="sidebar-checkout">
		<?= $m_payment;?>
		<?= $m_status;?>
		<?= $m_coupon;?>
		<?php
			echo $this->displayBlock('buttons', 0, array());
		?>
	</div>
	<?php
	
	$cart_class= hikashop_get('class.cart');
	$cart= $cart_class->getFullCart();
	?>
	<?php endif;?>

</div>

<!-- EO CHECKOUT -->
<!-- BOTTOM EXTRA DATA -->
<?php
if(!empty($this->extraData['checkout']) && !empty($this->extraData['checkout']->checkout_bottom)) { echo implode("\r\n", $this->extraData['checkout']->checkout_bottom); }
?>
<!-- EO BOTTOM EXTRA DATA -->
<?php
if($this->hasSeparator)
	echo $this->displayBlock('separator', $last+1, array('type' => 'end'));
?>
<!-- BUTTONS -->

<!-- EO BUTTONS -->
<!-- OTHER EXTRA DATA -->
<?php
if(!empty($this->extra_data) && !isset($this->extraData['checkout']))
	echo implode("\r\n", $this->extra_data);
?>
<!-- EO OTHER EXTRA DATA -->
<?php
$doc = JFactory::getDocument();
$doc->addScript(HIKASHOP_JS.'checkout.js');
$js = '
window.checkout.token = "'.hikashop_getFormToken().'";
window.checkout.urls.show = "'.hikashop_completeLink('checkout&task=showblock'.$this->cartIdParam.'&Itemid='.$this->itemid, 'ajax', false, true).'";
window.checkout.urls.submit = "'.hikashop_completeLink('checkout&task=submitblock'.$this->cartIdParam.'&Itemid='.$this->itemid, 'ajax', false, true).'";
window.checkout.urls.submitstep = "'.hikashop_completeLink('checkout&task=submitstep'.$this->cartIdParam.'&Itemid='.$this->itemid, 'ajax', false, true).'";
window.Oby.registerAjax("checkout.step.completed",function(params){ document.getElementById("hikashop_checkout_form").submit(); });
window.Oby.registerAjax("cart.empty",function(params){ setTimeout(function(){ window.location.reload(); },150); });
window.Oby.registerAjax("cart.updated",function(params){ if(!params || !params.resp || !params.resp.empty) return; window.Oby.fireAjax("cart.empty",null); });
window.hikashop.ready(function(){
	'.implode("\r\n\t", $handleEnter).'
});
';
$doc->addScriptDeclaration($js);
?>
</div>
</form>

<!-- this style in show.php file hikahop -->
<style>

div#carts-checkout {
	display: flex;
	gap: 2%;
	position: relative;
}

div#main-checkout {
	flex: 65%;
	box-shadow: rgb(0 0 0 / 15%) 0px 3px 15px 0px;
	border: 1px solid #e0e0e2;
	border-radius: 8px;
	padding: 0 20px;
}

div#sidebar-checkout {
	flex: 0 35%;
	border: 1px solid #e0e0e2;
	border-radius: 8px;
	padding: 30px 20px;
	height: fit-content;
	position: sticky;
	top: 0px;
	box-shadow: rgb(0 0 0 / 15%) 0px 3px 15px 0px;
}

.buttons_right {
	width: 100%;
	margin-top: 30px;
}

button#hikabtn_checkout_next {
	padding: 15px;
	width: 100%;
	font-size: 1.1rem;
}

.hikashop_checkout_coupon {
	margin-top: 30px;
}

.hikashop_checkout_status {
	display: block;
	font-size: 0.8rem;
	color: #9b9b9b;
}

img.hikashop_product_checkout_cart_image {
	width: 150px;
	height: 150px;
	border: 1px solid #e6e6e6;
	border-radius: 5px;
	margin-bottom: 15px;
}

.hikashop_checkout-list-cart>.row-list-cart {
	display: flex;
	padding: 30px 0;
	position: relative;
}

.hikashop_checkout-list-cart>.row-list-cart:not(:first-child) {
	border-top: 1px solid #e0e0e2;
}

span.hikashop_product_price_full {
	color: #5eba3f;
	font-size: 0.9rem;
	font-weight: 300;
}

div#info-product-text{
	margin-left: 20px;
}

p.hikashop_cart_product_name a {
    font-size: 1.1rem;
    color: #777777;
    font-weight: bold;
    line-height: 1.9;
    padding-left: 30px;
    display: block;
}

.hikashop_checkout_cart .hikashop_product_quantity_field {
	text-align: center;
	padding: 10px 30px !important;
	margin: 0 !important;
}

.hikashop_product_quantity_change_div_minus_default,
.hikashop_product_quantity_change_div_plus_default {
	position: absolute;
	padding: 10px;
}

.hikashop_product_quantity_change_div_minus_default {
	left: 0;
}

.hikashop_product_quantity_input_div_default {
	position: relative;
	display: flex;
	align-items: center;
}

.hikashop_cart_product_quantity_value {
	display: flex;
	justify-content: center;
}

.hikashop_cart_product_quantity_delete svg {
	width: 17px;
}

.hikashop_cart_product_quantity_delete svg path {
	fill: #ef4056;
}

.hikashop_payment_methods_table {
	display: flex;
	border: unset;
	flex-wrap: wrap;
	justify-content: center;
	align-items: center;
	gap: 1%;
}

.item-payment-hikashop {
	font-size: 0.7rem;
	margin-bottom: 10px;
	width: 172px;
	position: relative;
}

.item-payment-hikashop label {
	border: 1px solid #dddddd;
	border-radius: 5px;
	padding: 15px 10px;
	/* box-shadow: 0px 7px 7px -4px #e1e1e1; */
}

.hikashop_checkout_payment_images {
	width: 100%;
	text-align: center;
	display: block;
	margin-bottom: 20px;
}

.hikashop_cart_product_quantity_refresh,
.hikashop_cart_product_quantity_delete {
	display: flex;
	align-items: center;
}

.hikashop_cart_product_quantity_refresh {
	margin-left: 10px;
}

.hikashop_cart_product_quantity_delete {
	margin-right: 10px;
	position: absolute;
    left: 0;
    top: 20px;
}

.hikashop_checkout_status span.label.label-info {
	color: #545454;
	background: unset;
	font-size: 0.8rem;
	font-weight: 100;
}

.hikashop_checkout_coupon label {
	font-size: 0.8rem;
	color: #9b9b9b;
	margin-bottom: 15px;
}

.hikashop_checkout_coupon_field {
	margin-top: 0;
	margin-right: 0;
	border-radius: 5px !important;
}

.hikabtn_checkout_coupon_add {
	color: #a7a7a7;
	border: 1px solid #dddddd;
	background: #ebebeb;
	padding: 7px 15px;
	transition: 0.3s;
}

.hikabtn_checkout_coupon_add:hover {
	border: 1px solid #dddddd;
	background: #dedede;
	color: #a7a7a7;
}

.hikashop_checkout_payment_radio {
	position: absolute;
	right: 10px;
	top: 5px;
}

.hikashop_checkout_payment_radio::before {
	content: "";
	width: 15px;
	height: 15px;
	background: white;
	display: block;
	border-radius: 5px;
	border: 1px solid #d2d2d2;
}

.hikashop_checkout_payment_radio::after {
	content: "\f00c";
	font-family: 'FontAwesome';
	width: 15px;
	height: 15px;
	display: block;
	position: relative;
	top: -20px;
	right: -4px;
	color: #00c200;
	font-size: 20px;
	opacity: 0;
	transition: 0.3s;
}

.hikashop_checkout_payment_radio:checked::after {
	opacity: 1;
}

.hikashop_checkout_payment legend {
	font-size: 0.8rem;
	color: #9b9b9b;
	margin-bottom: 15px;
}

@media only screen and (max-width:1024px) {
	div#carts-checkout{
		flex-direction: column-reverse;
	}
	div#sidebar-checkout {
		margin: 20px 0;
	}
}

</style>