/*!
* jquery.instagramFeed
*
* @version 1.1.3
*
* @author Javier Sanahuja Liebana <bannss1@gmail.com>
* @contributor csanahuja <csanahuja@gmail.com>
*
* https://github.com/jsanahuja/jquery.instagramFeed
*
*/
(function($){
  var defaults = {
    'host': "https://www.instagram.com/",
    'username': '',
    'container': '',
    'layout'		  	: 'grid',
    'display_profile': true,
    'display_biography': true,
    'display_lightbox'   	: true,
    'display_gallery': true,
    'display_igtv': false,
    'get_raw_json': false,
    'callback': null,
    'styling': true,
    'items': 8,
    'columns'         	: 4,
    'columns_tablet'  	: 3,
    'columns_mobile'  	: 2,
    'parallax'          : 150,
    'masonry'           : true,
    'column_gap'      	: '',
    'like_count'      	: true,
    'comment_count'   	: true,
    'image_animation'		  	: 'scale-up',
    'items_per_row': 4,
    'margin': 0.5,
    'image_size': 640
  };

  $.instagramFeed = function(options){
    options = $.fn.extend({}, defaults, options);
    if(options.username == ""){
      console.error("Instagram Feed: Error, no username found.");
      return;
    }
    if(!options.get_raw_json && options.container == ""){
      console.error("Instagram Feed: Error, no container found.");
      return;
    }
    if(options.get_raw_json && options.callback == null){
      console.error("Instagram Feed: Error, no callback defined to get the raw json");
      return;
    }

    $.get(options.host + options.username, function(data){
      data = data.split("window._sharedData = ");
      data = data[1].split("<\/script>");
      data = data[0];
      data = data.substr(0, data.length - 1);
      data = JSON.parse(data);
      data = data.entry_data.ProfilePage[0].graphql.user;

      if(options.get_raw_json){
        options.callback(
          JSON.stringify({
            id: data.id,
            username: data.username,
            full_name: data.full_name,
            is_private: data.is_private,
            is_verified: data.is_verified,
            biography: data.biography,
            followed_by: data.edge_followed_by.count,
            following: data.edge_follow.count,
            images: data.edge_owner_to_timeline_media.edges,
            igtv: data.edge_felix_video_timeline.edges
          })
        );
        return;
      }

      var styles = {
        'profile_container': "",
        'profile_image': "",
        'profile_name': "",
        'profile_biography': "",
        'gallery_image': ""
      };
      if(options.styling){
        styles.profile_container = " style='text-align:center;'";
        styles.profile_image = " style='border-radius:10em;width:15%;max-width:125px;min-width:50px;'";
        styles.profile_name = " style='font-size:1.2em;'";
        styles.profile_biography = " style='font-size:1em;'";
        var width = (100 - options.margin * 2 * options.items_per_row)/options.items_per_row;
        styles.gallery_image = " style='margin:"+options.margin+"% "+options.margin+"%;width:"+width+"%;float:left;'";

      }

      var html = "";
      if(options.display_profile){
        html += "<div class='instagram_profile'" +styles.profile_container +">";
        html += "	<img class='instagram_profile_image' src='"+ data.profile_pic_url +"' alt='"+ options.username +" profile pic'"+ styles.profile_image +" />";
        html += "	<p class='instagram_username'"+ styles.profile_name +">@"+ data.full_name +" (<a href='https://www.instagram.com/"+ options.username +"'>@"+options.username+"</a>)</p>";
      }

      if(options.display_biography){
        html += "	<p class='instagram_biography'"+ styles.profile_biography +">"+ data.biography +"</p>";
      }

      if(options.display_profile){
        html += "</div>";
      }

      var image_index = 4
      if(options.image_size !== 640){
        switch (options.image_size) {
          case 150:
          image_index = 0;
          break;
          case 240:
          image_index = 1;
          break;
          case 320:
          image_index = 2;
          break;
          case 480:
          image_index = 3;
          break;
          default:
          console.warn("Wrong image size. Getting default value. Accepted values are [150, 240, 320, 480, 640]");
        }
      }

      if(options.display_gallery){
        if(data.is_private){
          html += "<p class='instagram_private'><strong>This profile is private</strong></p>";
        }else{
          var imgs = data.edge_owner_to_timeline_media.edges;
          max = (imgs.length > options.items) ? options.items : imgs.length;
          lightbox = (options.display_lightbox) ? ' jl-lightbox' : '';
          column_gap = (options.column_gap) ? ' jl-grid-'+options.column_gap : '';
          if (options.parallax) {
            var parallax = "parallax: "+options.parallax+"";
          } else {
            var parallax = "";
          }
          if (options.masonry) {
            var masonry = "masonry: true; ";
          }
          else {
            var masonry = "";
          }
          if (options.layout === 'slider') {
            html += "<div jl-slider='sets: true'>";
            html += "<div class='jl-position-relative'>";
            html += "<div class='jl-slider-container'>";
            html += "<div class='jl-slider-items jl-child-width-1-"+options.columns+"@m jl-child-width-1-"+options.columns_tablet+"@s jl-child-width-1-"+options.columns_mobile+column_gap+"' jl-grid"+lightbox+">";
          } else {
            html += "<div class='jl-child-width-1-"+options.columns+"@m jl-child-width-1-"+options.columns_tablet+"@s jl-child-width-1-"+options.columns_mobile+column_gap+"' jl-grid='"+masonry+parallax+"'"+lightbox+">";
          }
          //html += "<div class='instagram_gallery'>";

          for(var i = 0; i < max; i++){
            var url = "https://www.instagram.com/p/" + imgs[i].node.shortcode;
            var image = imgs[i].node.thumbnail_resources[image_index].src
            var type_resource = "image"

            switch(imgs[i].node.__typename){
              case "GraphSidecar":
              type_resource = "sidecar"
              break;
              case "GraphVideo":
              type_resource = "video";
              image = imgs[i].node.thumbnail_src
              break;
              default:
              type_resource = "image";
            }

            var like_comment = "";
            like_comment += "<div class='jl-position-small jl-position-bottom-right jl-grid jl-grid-small jl-padding-small'>";
            if (options.like_count) {
              like_comment += "<div><span class='fa fa-heart-o' aria-hidden='true'></span> <span class='jl-text-middle'>"+imgs[i].node.edge_media_preview_like.count+"</span></div>";
            }
            if (options.comment_count) {
              like_comment += "<div><span class='fa fa-comment-o' aria-hidden='true'></span> <span class='jl-text-middle'>"+imgs[i].node.edge_media_to_comment.count+"</span></div>";
            }
            like_comment += "</div>";

            if (options.image_animation === 'inherit') {
              var animation = "";
            } else {
              var animation = " jl-transition-"+options.image_animation+" jl-transition-opaque";
            }

            html += "<div class='tm-item-wrapper'>";

            if (options.image_animation === 'inherit') {
              html += "<div class='jl-instagram-item jl-transition-toggle jl-position-relative'>";
            } else {
              html += "<div class='jl-instagram-item jl-inline-clip jl-transition-toggle jl-position-relative'>";
            }

            if (options.display_lightbox) {
              html += "<a href='" + image + "' class='instagram-" + type_resource + "' rel='noopener' target='_blank'>";
            } else {
              html += "<a href='" + url +"' class='instagram-" + type_resource + "' rel='noopener' target='_blank'>";
            }

            if (options.layout === 'slider') {
              html += "	<img class='tm-image"+animation+"' src='" + image + "' alt='"+ options.username +" instagram image "+ i +"'>";
            } else {
              html += "	<img class='tm-image"+animation+"' src='" + image + "' alt='"+ options.username +" instagram image "+ i +"'>";
            }

            if (options.display_lightbox) {
              html += "<div class='jl-transition-fade jl-position-cover jl-overlay jl-overlay-primary'><span class='jl-position-center'><span class='fa fa-instagram fa-2x' aria-hidden='true'></span></span>"+like_comment+"</div>";
            } else {
              if (options.like_count || options.comment_count ) {
                html += "<div class='jl-transition-fade jl-position-cover jl-overlay jl-overlay-primary'><span class='jl-position-center'><span class='fa fa-instagram fa-2x' aria-hidden='true'></span></span>"+like_comment+"</div>";
              }
            }
            //html += "   <img src='" + image + "' alt='" + options.username + " instagram image "+ i + "'" + styles.gallery_image +" />";
            html += "</a>";

            html += "</div>";
            html += "</div>";
            
          }
          html += "</div>";
          if (options.layout === 'slider') {

            html += "<div class='jl-hidden@s jl-light'>";
            html += "<a class='jl-position-center-left jl-position-small' href='#' jl-slidenav-previous jl-slider-item='previous'></a>";
            html += "<a class='jl-position-center-right jl-position-small' href='#' jl-slidenav-next jl-slider-item='next'></a>";
            html += "</div>";

            html += "<div class='jl-visible@s'>";
            html += "<a class='jl-position-center-left-out jl-position-small' href='#' jl-slidenav-previous jl-slider-item='previous'></a>";
            html += "<a class='jl-position-center-right-out jl-position-small' href='#' jl-slidenav-next jl-slider-item='next'></a>";
            html += "</div>";

            html += "</div>";

            html += "</div>";
            html += "<ul class='jl-slider-nav jl-dotnav jl-flex-center jl-margin'></ul>";
            html += "</div>";
          }
        }
      }

      if(options.display_igtv){
        if(data.is_private){
          html += "<p class='instagram_private'><strong>This profile is private</strong></p>";
        }else{
          var igtv = data.edge_felix_video_timeline.edges,
          max = (igtv.length > options.items) ? options.items : igtv.length
          html += "<div class='instagram_igtv'>";
          for(var i = 0; i < max; i++){
            var url = "https://www.instagram.com/p/"+ igtv[i].node.shortcode;
            html += "<a href='"+url+"' rel='noopener' target='_blank'>";
            html += "	<img src='"+ igtv[i].node.thumbnail_src +"' alt='"+ options.username +" instagram image "+ i+"' />";
            html += "</a>";
          }
          html += "</div>";
        }
      }
      $(options.container).html(html);
    }
  );
};

})(jQuery);
