<?php
/* ======================================================
 # Login as User for Joomla! - v3.5.9 (pro version)
 # -------------------------------------------------------
 # For Joomla! CMS (v3.x)
 # Author: Web357 (Yiannis Christodoulou)
 # Copyright (©) 2014-2022 Web357. All rights reserved.
 # License: GNU/GPLv3, http://www.gnu.org/licenses/gpl-3.0.html
 # Website: https:/www.web357.com
 # Demo: https://demo.web357.com/joomla/login-as-user
 # Support: support@web357.com
 # Last modified: Wednesday 07 December 2022, 11:05:26 AM
 ========================================================= */
defined('_JEXEC') or die;

// BEGIN: Web357 (Login as User - system joomla! plugin) 
$db = JFactory::getDbo();
$db->setQuery("SELECT enabled FROM #__extensions WHERE type = 'plugin' AND element = 'loginasuser'");
$loginasclient_is_enabled = $db->loadResult();
if ($loginasclient_is_enabled)
{
	// get custom css
	$plugin = JPluginHelper::getPlugin('system', 'loginasuser');
	$params = new JRegistry($plugin->params);
	$custom_css = $params->get('custom_css');
	$displayed_text = $params->get('displayed_text', 'Login as %s »');
	$login_as_type = $params->get('login_as_type', 'username');
	$login_as_type_characters_limit = $params->get('login_as_type_characters_limit', 0);
	echo (!empty($custom_css)) ? '<style type="text/css">'.$custom_css.'</style>' : '';

	// Load the plugin language file
	$lang = JFactory::getLanguage();
	$current_lang_tag = $lang->getTag();
	$extension = 'plg_system_loginasuser';
	$base_dir = JPATH_SITE.'/plugins/system/loginasuser/';
	$language_tag = (!empty($current_lang_tag)) ? $current_lang_tag : 'en-GB';
	$reload = true;
	$lang->load($extension, $base_dir, $language_tag, $reload);

	// Check if the logged in Admin user can use the LoginAsUser functionality
	function canLoginAsUser($user_id)
	{
		// me
		$user = JFactory::getUser();
		$me = $user->id;

		// get params
		$plugin = JPluginHelper::getPlugin('system', 'loginasuser');
		$params = new JRegistry($plugin->params);
		$custom_css = $params->get('custom_css');

		// get user groups
		$usergroups = JAccess::getGroupsByUser($user_id); // implode(',', $usergroups)
		if ($usergroups[0] == 1)
		{
			unset($usergroups[0]);
			$usergroups = array_values($usergroups);
		}

		// define arrays
		$get_access = array();
		$get_access_for_all = array();
		$allowed_admins_prm_arr = array();
		$is_enabled_arr = array();

		foreach ($usergroups as $usergroup_id)
		{
			$is_enabled = $params->get('enable_'.$usergroup_id, '1');
			$allowed_admins_prm = $params->get('users_'.$usergroup_id);

			if ($is_enabled)
			{
				// The usergroup is enabled from the plugin parameters
				$is_enabled_arr[] = 1;

				if (!empty($allowed_admins_prm))
				{
					if (in_array($me, $allowed_admins_prm))
					{
						// Has access because the logged in admin user is in the allowed list
						$get_access[] = 1;
					}
					else
					{
						// No access because the logged in admin user is not in the allowed list
						$get_access[] = 0;
					}
				}
				else
				{
					// Has access because this usergroup is open for all (blank input field)
					$get_access_for_all[] = 1;
				}

				if (isset($allowed_admins_prm[0]))
				{
					$allowed_admins_prm_arr[] = $allowed_admins_prm[0];
				}				
			}
			else
			{
				// The usergroup is disabled from the plugin parameters
				$is_enabled_arr[] = 0;
			}

		}

		if (array_sum($is_enabled_arr) > 0 && array_sum($get_access) > 0) // usergroup is active and access for specific users
		{
			// Can login as user
			return true;
		}
		elseif (array_sum($is_enabled_arr) > 0 && array_sum($allowed_admins_prm_arr) == 0) // usergroup is active and access for all
		{
			// Can login as user
			return true;
		}
		else
		{
			// Cannot login as user
			return false;
		}
	}
}
// END: Web357 (Login as User - system joomla! plugin) 