<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.36
	@build			28th March, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		reservation_search.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.1.$$$$]***/

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
/***[/JCBGUI$$$$]***/


/***[JCBGUI.class_extends.comment.1.$$$$]***/
/**
 * Search - Reservation_search plugin.
 *
 * @package   Reservation_search
 * @since     1.0.0
 *//***[/JCBGUI$$$$]***/

class PlgSearchReservation_search extends CMSPlugin
{

/***[JCBGUI.joomla_plugin.main_class_code.68.$$$$]***/
  public function __construct(&$subject, $config)
  {
    parent::__construct($subject, $config);
    $this->loadLanguage();
  }

function onContentSearchAreas()
{
    return array('reservation' => JText::_("JRESERVATION")); // translate_need
}

function onContentSearch($text, $phrase='', $ordering='', $areas=null)
{
    $db     = JFactory::getDBO();
    $like= $db->quote('%'.str_replace(' ','%',trim($text)).'%');

    $query = $db->getQuery(true);
    $query
        ->select('u.name, ca.title, c.account, c.id as c_d_id, c.published')
        ->from($db->quoteName('#__reservation_consultant', 'c'))
        ->join('INNER', $db->quoteName('#__users', 'u') . ' ON ' . $db->quoteName('c.userid') . ' = ' . $db->quoteName('u.id'))
        ->join('INNER', $db->quoteName('#__categories', 'ca') . ' ON ' . $db->quoteName('c.catid') . ' = ' . $db->quoteName('ca.id'))
        ->where($db->quoteName('u.name') . ' LIKE ' . $like)
        ->orwhere($db->quoteName('ca.title') . ' LIKE ' . $like);
    $db->setQuery($query);
    $rows = $db->loadAssocList();

    $rows_result = array ();
    foreach($rows as $key => $row) {
        if($row['published'] == 1)
        {
            $obj = new JObject ();
            $obj->title= $row['name'];
            $obj->section = $row['title'];
            $obj->created = "";
            $obj->browsernav = '1'; // 1 = new window, 2 = same window
            if ($row['account']== 'consultant')
            {
                $obj->href = JRoute::_("/index.php?option=com_reservation&view=consultantitem&id={$row['c_d_id']}", true);
                $obj->text = "text";
            }
            else if ($row['account']== 'doctor')
            {
                $obj->href = JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$row['remoteid'], true);
                $obj->text = "";
            }
            else if ($row['account']== 'both')
            {
                $obj->href = JRoute::_("/index.php?option=com_reservation&view=consultantitem&id={$row['c_d_id']}", true);
                $obj->text = "";
            }
            $rows_result[] = $obj;
        }
    }
//    echo '<pre>';
//    var_dump($rows);
//    echo '</pre>';
//    exit();
    return $rows_result;


}/***[/JCBGUI$$$$]***/

}
