<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.36
	@build			28th March, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		rsticket_bale_sms.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.1.$$$$]***/

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
/***[/JCBGUI$$$$]***/


/***[JCBGUI.class_extends.comment.1.$$$$]***/
/**
 * Rsticketspro - Rsticket_bale_sms plugin.
 *
 * @package   Rsticket_bale_sms
 * @since     1.0.0
 *//***[/JCBGUI$$$$]***/

class PlgRsticketsproRsticket_bale_sms extends CMSPlugin
{

/***[JCBGUI.joomla_plugin.main_class_code.4.$$$$]***/
public function onRsticketsproAfterStoreTicket($row)
{

    $row= (object)$row;
    require_once __DIR__.'/classes/send.php';
    $bale_id= $this->params->get('bale_id',0);
    $params= [
        'bale_id'=> $bale_id,
        'id'=> $row->ticket_id,
        'code'=> $row->code,
        'subject'=> $row->subject,
        'message'=> $row->message,
        'created_date'=> $row->date,
        'status_id'=> $row->status_id,
        'priority_id'=> $row->priority_id,
        'department_id'=> $row->department_id,
        'user_id'=> $row->user_id,
        'customer_id'=> $row->customer_id
    ];


    $user= JFactory::getUser();
    $name= $user->get('name', 'guest');
    $db = JFactory::getDbo();

    $query = $db->getQuery(true);
    $query->select('name');
    $query->from($db->quoteName('#__rsticketspro_statuses'));
    $query->where($db->quoteName('id').'='.$db->quote($params['status_id']));
    $db->setQuery($query);
    $params['status_title'] = $db->loadResult();


    $query = $db->getQuery(true);
    $query->select('name');
    $query->from($db->quoteName('#__rsticketspro_priorities'));
    $query->where($db->quoteName('id').'='.$db->quote($params['priority_id']));
    $db->setQuery($query);
    $params['priority_title'] = $db->loadResult();


    $query = $db->getQuery(true);
    $query->select('name');
    $query->from($db->quoteName('#__rsticketspro_departments'));
    $query->where($db->quoteName('id').'='.$db->quote($params['department_id']));
    $db->setQuery($query);
    $params['department_title'] = $db->loadResult();


    $text= "
    شناسه تیکت : {$params['id']}
    کد تیکت : {$params['code']}
    نام فرستنده : {$name}
    دپارتمان : {$params['department_title']}
    وضعیت : {$params['status_title']}
    اولویت : {$params['priority_title']}
    تاریخ ایجاد : {$params['created_date']}
    موضوع : {$params['subject']}
    متن : {$params['message']} ";


    $send= new send($this->params->get('bot_token'));

    foreach (explode(',',$params['bale_id']) as $item) {
        $data[]= ['chat_id'=> $item, 'text'=>$text];
    }

    $send->send_bale_message($data);
    
    $mobile_number_source = $this->params->get('mobile_number_source');
    $mobile_number_source_field = $this->params->get('mobile_number_source_field');
    $smsService_input_data = array(
//        "name" => $name,
        "website_link" => 'https://www.daneh.ir'
    );
    $smsService_pattern_code = $this->params->get('sms_submit_pattern', 0);
    $smsService_username =  $this->params->get('sms_username', 0);
    $smsService_password =  $this->params->get('sms_password', 0);

    if ($smsService_username && $smsService_password && $smsService_pattern_code)
    {
        $mobile= $send->getMobile($mobile_number_source, $mobile_number_source_field, $params['customer_id']);
        if ($mobile)
        {
            $res = $send->send_sms($mobile, $smsService_input_data, $smsService_pattern_code, $smsService_username, $smsService_password);
        }
    }



}


public function onRsticketsproAfterStoreTicketReply($row, $table= null)
{
    if ($table)
    {
        $row= (object)$row;
        require_once __DIR__.'/classes/send.php';
        $bale_id= $this->params->get('bale_id',0);
        $params= [
            'bale_id'=> $bale_id,
            'id'=> $row->ticket_id,
            'message'=> $row->message,
            'created_date'=> $row->date,
            'user_id'=> $row->user_id
        ];

        $user= JFactory::getUser();
        $name= $user->get('name', 'guest');
        $text= "
        #پاسخ
        شناسه تیکت : {$params['id']}
        نام پاسخ دهنده : {$name}
        تاریخ ایجاد : {$params['created_date']}
        متن : {$params['message']} ";

        $send= new send($this->params->get('bot_token'));

        foreach (explode(',',$params['bale_id']) as $item) {
            $data[]= ['chat_id'=> $item, 'text'=>$text];
        }

        $send->send_bale_message($data);


        $mobile_number_source = $this->params->get('mobile_number_source');
        $mobile_number_source_field = $this->params->get('mobile_number_source_field');
        
        $smsService_input_data = array(
            "Name" => $name,
            "website_link" => 'https://www.daneh.ir'
        );
        $smsService_pattern_code = $this->params->get('sms_reply_pattern', 0);
        $smsService_username =  $this->params->get('sms_username', 0);
        $smsService_password =  $this->params->get('sms_password', 0);

        if ($smsService_username && $smsService_password && $smsService_pattern_code)
        {
            if (isset($row->customer_id))
            {
                $mobile= $send->getMobile($mobile_number_source, $mobile_number_source_field, $row->customer_id);
                if ($mobile)
                    $send->send_sms($mobile, $smsService_input_data, $smsService_pattern_code, $smsService_username, $smsService_password);

            }
        }

    }
    
}/***[/JCBGUI$$$$]***/

}
