
        (function(){
var dojo = odojo;

var dijit = odijit;

var dojox = odojox;


dojo.declare("OfflajnList", null, {
	constructor: function(args) {
    this.fireshow = 0;
    this.map = {};
    this.names = new Array();
    this.list = new Array;
	  dojo.mixin(this,args);
    this.showed = 0;
    this.focus = 0;
    this.zindex = 6;
    window.offlajnlistzindex = 10;
    if(this.height) this.height++;
    this.lineHeight = 20;
    this.init();
  },

  init: function() {
    this.hidden = dojo.byId(this.name);
    this.active = this.hidden;

    this.hidden.listobj = this;
    this.hidden.options = this.options;
    this.hidden.selectedIndex = this.selectedIndex;

    dojo.connect(this.hidden, 'onchange', this, 'setValue');
    this.change = 0;

    this.container = dojo.byId('offlajnlistcontainer' + this.name);
    this.offlajnlist = dojo.query('.offlajnlist', this.container)[0];
    this.currentText = dojo.query('.offlajnlistcurrent', this.container)[0];

    if (this.json && window[this.json] && window[this.json].length) {
      this.hidden.options = this.options = this.options.concat(window[this.json]);
      this.hidden.selectedIndex = this.selectedIndex = 0;
      this.currentText.innerHTML = this.options[0].text;
      for (var i = 0; i < this.options.length; i++)
        if (this.options[i].value == this.hidden.value) {
          this.hidden.selectedIndex = this.selectedIndex = i;
          this.currentText.innerHTML = this.options[i].text;
          break;
        }
    }

    if (this.width) {
      dojo.style(this.container, 'minWidth', this.width+'px');
    } else {
      dojo.style(this.container, 'minWidth', Math.ceil(dojo.style(this.container, 'width')+1)+'px');
      if(dojo.isIE == 7) {
        var span = dojo.query('#offlajnlistcontainer' + this.name + ' span');
        dojo.style(this.container, 'width', dojo.style(span[0], 'width')+30+'px');
      }
    }

    dojo.connect(this.container, 'onclick', this, 'controller');
    this.options.forEach(function(o, i){
      this.map[o.value] = i;
      this.names[i] = o.text;
    },this);
    this.keyListener;
  },

  initSelectBox: function(){
    if(this.selectbox) return;

    var i, elements = '<div class="content">';
    for (i = 0; i < this.options.length; i++)
      elements += '<div class="listelement">'+ this.options[i].text +'</div>';
    elements += '</div>';

    this.selectbox = dojo.create('div', {'id': 'offlajnlistelements' + this.name, 'class': 'offlajnlistelements', 'innerHTML': elements}, this.container, "after");
    this.list = dojo.query('.listelement', this.selectbox);

    this.list.connect('onmouseenter', this, 'addActive');

    dojo.style(this.selectbox, {
      opacity: 0,
      display: 'block'
    });

    this.lineHeight = dojo.position(this.list[0]).h;
    dojo.style(this.selectbox, {
      height: (this.height) ? this.height * this.lineHeight + 'px' : 'auto'
    });

    if(this.height) {
      this.content = dojo.query('#offlajnlistelements' + this.name + ' .content')[0];
      dojo.style(this.content, 'height', this.list.length * this.lineHeight + 'px');
      this.scrollbar = new OfflajnScroller({
        'extraClass': 'single-select',
        'selectbox': this.selectbox,
        'content': this.content
      });
    }

    this.maxW = 0;
    this.list.forEach(function(el, i){
      if (this.options[i].value == 'optgroup') dojo.addClass(el, "optgroup");
      el.i = i;
    },this);

    this.list.connect('onclick', this, 'selected');

    this.selectbox.h = dojo.marginBox(this.selectbox).h;
    dojo.style(this.selectbox, {
      height: 0
    });
    dojo.connect(document, 'onclick', this, 'blur');
    dojo.connect(this.selectbox, 'onclick', this, 'focused');

    if(this.fireshow)
      OfflajnFireEvent(this.hidden, 'click');
  },

  controller: function(){
    this.focused();
    this.initSelectBox();
    if(this.showed == 0){
      this.reposition();
      this.showList();
    }else{
      this.hideList();
    }
  },

  reposition: function(){
    var pos = dojo.coords(this.container, true);
    if(this.selectbox){

      dojo.style(this.selectbox, {
        left: pos.l + "px",
        top: pos.t + pos.h  + "px",
        width: pos.w -2 +"px" //-2px because of the side-borders
      });
      if(this.content) {
        dojo.style(this.content,{

         'width': pos.w - 12 + 'px',
         'float': 'left'
         });
      }
    }
  },

  showList: function(){
    this.keyListener = dojo.connect(document, 'keydown', this, 'keySearch');
    if(this.anim) this.anim.stop();
    this.showed = 1;
    dojo.addClass(this.container,'openedlist');
    dojo.addClass(this.selectbox,'openedlist');
    dojo.removeClass(this.active,'active');
    dojo.addClass(this.list[this.hidden.selectedIndex],'selected active');
    if(this.height) {
      var p = this.hidden.selectedIndex * this.lineHeight;
      this.scrollbar.setPosition(p);
    }
    this.active = this.list[this.hidden.selectedIndex];

    dojo.style(this.offlajnlist, 'zIndex', ++window.offlajnlistzindex);
    dojo.style(this.selectbox, {
      display: 'block',
      zIndex: window.offlajnlistzindex-1
    });
    window.offlajnlistzindex++;

    this.anim = dojo.animateProperty({
      node: this.selectbox,
      properties: {
          opacity : 1,
          height: this.selectbox.h
      }
    }).play();
  },

  keySearch: function(e) {
    //console.log(String.fromCharCode(e.keyCode));
    if(e.keyCode == 13) {
      this.hideList();
      OfflajnFireEvent(this.hidden, 'change');
      this.change = 0;
    } else if(e.keyCode == 38) {
      e.preventDefault();
      var index = this.hidden.selectedIndex-1;
        this.setSelected(index);
    } else if(e.keyCode == 40) {
      e.preventDefault();
      var index = this.hidden.selectedIndex+1;
        this.setSelected(index);
    }
    //console.log(this.names);
    var scroll = this.scrollbar;
    for(var i=0;i<this.names.length;i++) {
      if(this.names[i].toLowerCase().indexOf(String.fromCharCode(e.keyCode).toLowerCase()) == 0) {
        this.setSelected(i);
        break;
      }
    }
  },

  hideList: function(){
    dojo.disconnect(this.keyListener);
    if(this.anim) this.anim.stop();
    if(!this.selectbox) return;

    this.showed = 0;

    var h = dojo.marginBox(this.selectbox).h;
    dojo.removeClass(this.container,'openedlist');
    this.anim = dojo.animateProperty({
      node: this.selectbox,
      properties: {
          opacity : 0,
          height: 0
      },
      onEnd: dojo.hitch(this, function(el){
        dojo.style(el, {
          display: 'none',
          height: '0',
          zIndex: this.zindex-1
        });
        dojo.style(this.offlajnlist, 'zIndex', this.zindex);
        dojo.removeClass(this.selectbox,'openedlist');
      })
    }).play();
  },

  selected: function(e){
    if (dojo.hasClass(e.currentTarget, 'optgroup')) return;
    if(this.list[this.hidden.selectedIndex])
      dojo.removeClass(this.list[this.hidden.selectedIndex],'selected active');
    this.hidden.selectedIndex = e.target.i;
    this.hidden.value = this.hidden.options[this.hidden.selectedIndex].value;

    this.currentText.innerHTML = this.hidden.options[this.hidden.selectedIndex].text;
    if(this.list[this.hidden.selectedIndex])
      dojo.addClass(this.list[this.hidden.selectedIndex],'selected active');
    this.hideList();
    OfflajnFireEvent(this.hidden, 'change');
    this.change = 0;
  },

  setSelected: function(val) {
    if(!this.list[val]) return;
    if(this.list[this.hidden.selectedIndex])
      dojo.removeClass(this.list[this.hidden.selectedIndex],'selected active');

    this.hidden.selectedIndex = val;
    this.hidden.value = this.hidden.options[this.hidden.selectedIndex].value;

    this.currentText.innerHTML = this.hidden.options[this.hidden.selectedIndex].text;
    if(this.list[this.hidden.selectedIndex])
      dojo.addClass(this.list[this.hidden.selectedIndex],'selected active');

    if(this.height) {
        var p = this.hidden.selectedIndex * this.lineHeight;
        this.scrollbar.setPosition(p);
    }
  },

  addActive: function(e){
    var el = e.target;
    if(el != this.active){
      dojo.removeClass(this.active,'active');
      dojo.addClass(el,'active');
      this.active = el;
    }
  },

  focused: function(){
    this.focus = 1;
  },

  blur: function(e){
    if(!this.focus){
      this.hideList();
    }
    this.focus = 0;
  },

  setValue: function(e) {
    if(!this.change && this.map[this.hidden.value] != this.hidden.selectedIndex) {
      this.change = 1;
      e.target.i = this.map[this.hidden.value] ? this.map[this.hidden.value] : 0;
      this.selected(e);
    }
  }
});

dojo.declare("OfflajnScroller", null, {
	constructor: function(args) {
   this.scrollspeed = 10;
   this.curr = 0;
	 dojo.mixin(this,args);
	 this.initScrollbar();
  },
  
  initScrollbar: function() {
    (!dojo.isMozilla) ? dojo.connect(this.selectbox, 'onmousewheel', this, 'scrollWheel') : dojo.connect(this.selectbox, 'DOMMouseScroll', this, 'scrollWheel');
    var right = dojo.create('div', {'class': 'gk_hack offlajnscrollerright'}, this.selectbox);
    this.sc = dojo.create('div', {'class': 'gk_hack offlajnscrollerbg'}, right);
    this.scrollbg = dojo.create('div', {'class': 'gk_hack offlajnscrollerscrollbg'}, this.sc);
    this.scrollbtn = dojo.create('div', {'class': 'gk_hack offlajnscrollerscrollbtn'} ,this.sc );
    if(this.extraClass) {
      dojo.addClass(right, this.extraClass);
      dojo.addClass(this.sc, this.extraClass);
      dojo.addClass(this.scrollbg, this.extraClass);
      dojo.addClass(this.scrollbtn, this.extraClass);
    }
    if(this.extraClass == 'multi-select') {
      this.scrollup = dojo.create('div', {'class': 'gk_hack offlajnscrollerarrowup'}, this.sc, 'first');
      this.scrolldown = dojo.create('div', {'class': 'gk_hack offlajnscrollerarrowdown' }, this.sc, 'last');     
      this.scrupc = dojo.connect(this.scrollup, 'onmousedown', this, 'upScroll');
      this.scrdownc = dojo.connect(this.scrolldown, 'onmousedown', this, 'downScroll');   
    }    
    dojo.connect(this.scrollbtn, 'onmousedown', this, 'onscrolldown');
    dojo.connect(this.scrollbg, 'onclick', this, 'scrollTo');
    this.scrbg = dojo.position(this.scrollbg, true);
    this.scrollbtnprop = dojo.position(this.scrollbtn, true);
    
    this.scrollReInit();
  },
  
  scrollReInit: function(){
    dojo.style(this.scrollbtn, 'display', 'block');
    this.maxHeight = parseInt(dojo.position(this.content).h);
    this.windowHeight = parseInt(dojo.style(this.selectbox, 'height'));
    this.scrollRatio = this.maxHeight/this.windowHeight;
    
    this.maxTop = -1 * (this.maxHeight-this.windowHeight);
    if(this.maxTop > 0) this.maxTop = 0;
    var scrollArrowHeight = 0;
    this.scrollHeight = 0;
    var marginVertical = dojo.marginBox(this.scrollbg).h-dojo.position(this.scrollbg).h;
    if(this.extraClass == 'multi-select') {
      scrollArrowHeight = dojo.marginBox(this.scrollup).h;
      this.scrollHeight = (this.windowHeight+(-2*scrollArrowHeight-marginVertical-2));
      this.scrollBtnmaxTop = (this.scrollHeight-this.scrollHeight/this.scrollRatio)-2;
    } else {
      this.scrollHeight = (this.windowHeight-10);
      this.scrollBtnmaxTop = (this.scrollHeight-this.scrollHeight/this.scrollRatio);
    }
    dojo.style(this.scrollbg, 'height', this.scrollHeight+'px');
    var scrollBtn = (this.scrollHeight/this.scrollRatio-2);
    if(scrollBtn<10){
      scrollBtn = 10;
      this.scrollBtnmaxTop = (this.scrollHeight-scrollBtn-2);
    }
    this.scrollBtnH = scrollBtn;
    dojo.style(this.scrollbtn, 'height', scrollBtn+'px');
    if(this.scrollBtnmaxTop < 0) this.scrollBtnmaxTop = 0; 
    if(this.windowHeight > this.maxHeight) this.hideScrollBtn();  
  },
  
  hideScrollBtn: function() {
    dojo.style(this.scrollbtn, 'display', 'none');
  },
  
  goToBottom: function(){
    this.scrolling(-1000,1000);
  },
  
  onscrolldown: function(e) {
    this.scrdown = 1;
    this.currentpos = e.clientY;
    this.scrbtnpos = dojo.style(this.scrollbtn, 'top');
    this.mousemove = dojo.connect(document, 'onmousemove', this, 'onscrollmove');
    this.mouseup = dojo.connect(document, 'onmouseup', this, 'mouseUp');
  },
  
  onscrollmove: function(e) {
    var diff = this.currentpos-e.clientY;
    if(diff == 0) return;
    var lastt = (dojo.style(this.scrollbtn, 'top'));
    var pos = dojo.style(this.content, 'top');
    this.scrolling(diff, 	(((lastt-diff)/this.scrollBtnmaxTop)*this.maxTop-pos)/diff);
    this.currentpos = e.clientY;
  },
  
  scrollTo: function(e) {
    var pos = e.clientY;
    var sc = dojo.position(this.scrollbg);
    var currpos = pos - sc.y;    
    if(currpos < this.maxTop) currpos = maxTop; 
    if(currpos > this.scrollBtnmaxTop) currpos = this.scrollBtnmaxTop;
    dojo.style(this.scrollbtn, 'top', currpos + 'px');
    var scroll = -1*currpos * this.scrollRatio;
    dojo.style(this.content, 'top', scroll + 'px');
  },
  
  setPosition: function(p) {
    var pos = -1*p;
    if(pos < this.maxTop) pos = this.maxTop;
    this.setScrollBtn(pos);
    dojo.style(this.content, 'top', pos + 'px');
  },
  
  onscrollup: function(e) {
    e.stopPropagation();
    this.scrdown = 0;
  },
  
  upScroll: function(e) {
    this.mouseup = dojo.connect(document, 'onmouseup', this, 'mouseUp');
    e.stopPropagation();
    this.btnScroll(1);
  },
  
  downScroll: function(e) {
    this.mouseup = dojo.connect(document, 'onmouseup', this, 'mouseUp');
    e.stopPropagation();
    this.btnScroll(-1);
  },
  
  btnScroll: function(direction){
    this.dscr = 1;
    var fn = dojo.hitch(this, 'scrolling', direction, this.scrollspeed/4);
    fn();
    this.inter = window.setInterval(fn, 50);
  },
    
  scrolling: function(p, ratio) {
    if(ratio == undefined) ratio = this.scrollspeed;
    var pos = dojo.style(this.content, 'top');
    var scr = pos + (p * ratio);

    
    if(scr < this.maxTop) scr = this.maxTop;
    if(scr > 0) scr = 0;
    dojo.style(this.content, 'top', scr + 'px');
   
    this.setScrollBtn(scr);
    this.curr = scr;
    this.onScroll();
  },
  
  onScroll: function(){
  
  },
    
  setScrollBtn: function(val) {
    var top = (this.scrollBtnmaxTop*(val/this.maxTop));
    dojo.style(this.scrollbtn, 'top', top+'px');
  },
  
  mouseUp: function(e) {
    if(this.mousemove)
      dojo.disconnect(this.mousemove);
    if(this.mouseup)
      dojo.disconnect(this.mouseup);
    e.stopPropagation();
    this.inter = window.clearInterval(this.inter);
    if( this.dscr == 1) {
      this.dscr = 0;
    }
  },
  
  scrollWheel: function(e) {
    var pos = 0;
    pos = (e.detail != "") ? e.detail : e.wheelDelta;  
    if(dojo.isMozilla || dojo.isOpera) {  
      if (pos < 0) {
        this.scrolling(1);
      } else {
        this.scrolling(-1);
      }
    } else {
      if (pos < 0) {
        this.scrolling(-1);
      } else {
        this.scrolling(1);
      }
    }
    dojo.stopEvent(e);
  }
  
});

dojo.declare("OfflajnMultiSelectList", null, {
	constructor: function(args) {
    dojo.mixin(this,args);
    this.lineHeight = 20;
    this.init();
  },

  init: function() {
    this.multiselect = dojo.byId('offlajnmultiselect' + this.name);
    if(this.joomla && !this.name.match(/zoo/)) {
      this.type = this.typeSelectorInit();
    } else if(this.name.match(/zoo/)) {
      this.type = this.ZooSelectorInit();
    }
    this.itemscontainer = dojo.create('div', {'class': 'multiselectitems', 'innerHTML': this.data[this.type]}, this.multiselect);
    if(dojo.isIE == 7) dojo.style(this.multiselect, 'width', dojo.position(this.itemscontainer).w + 10 + 'px'); //IE7 width bug
    this.getList();
    this.hidden = dojo.byId(this.name);
    this.hidden.options = this.options;
    this.hidden.listobj = this;

    this.setSize();
    dojo.connect(this.itemscontainer, 'onclick', this, 'selectItem');
    this.setSelected();
    if(this.height) {
      this.scrollbar = new OfflajnScroller({
        'extraClass': 'multi-select',
        'selectbox': this.multiselect,
        'content': this.itemscontainer,
        'scrollspeed' : 30
      });
      if(this.list.length <= this.height - 2) this.scrollbar.hideScrollBtn();
    }
  },

  getList: function() {
    this.list = dojo.query('.multiselectitem', this.itemscontainer);
    if (!this.list.length) {
      this.itemscontainer.innerHTML = '<div class="gk_hack multiselectitem">All items</div>';
      this.list = dojo.query('.multiselectitem', this.itemscontainer);
    }
    this.list.forEach(function(el, i){
      if(this.type != 'simple') {
        el.i = 0;
        if(i) {
          el.i = this.ids[this.type][i-1];
        }
      } else {
          el.i = this.ids[this.type][i];
      }
    },this);
  },

  setSize: function() {
    dojo.style(this.multiselect, {
	   'height': this.height * this.lineHeight +  'px'
	});
  },

  setSelected: function() {
    var arr = this.hidden.value.split('|');
    if ((arr.length < this.list.length-1 && arr.length != 0) || this.type == 'simple') {
      dojo.forEach(arr, function(item, i){
        this.list.forEach(function(el, j){
          if (el.i == item){
            dojo.addClass(this.list[j], 'selected');
            if(this.mode == 2)
              this.hidden.selectedIndex = el.i;
          }
        }, this);
      }, this);
    } else {
        dojo.addClass(this.list[0], 'selected');
    }
  },

  selectItem: function(e) {
    if(this.mode == 1 && e.target.i == 0){
      this.allItemSelection();
    }else{
      if(this.mode == 1 && dojo.hasClass(this.list[0], 'selected')) {
        this.list.forEach(function(el, i){
          dojo.removeClass(el, 'selected');
        },this);
        if(dojo.hasClass(e.target, 'selected')) {
          dojo.removeClass(e.target, 'selected');
        } else {
          dojo.addClass(e.target, 'selected');
        }
      }else if(this.mode == 2){
        this.list.forEach(function(el, i){
          dojo.removeClass(el, 'selected');
        },this);
        dojo.addClass(e.target, 'selected');
        this.hidden.selectedIndex = e.target.i;
      }else{
        if(dojo.hasClass(e.target, 'selected')) {
          dojo.removeClass(e.target, 'selected');
        } else {
          dojo.addClass(e.target, 'selected');
        }
      }
    }
    this.getValues(0);
  },

  allItemSelection: function() {
    this.list.forEach(function(el, i){
      dojo.removeClass(el, 'selected');
    },this);

    dojo.addClass(this.list[0], 'selected');
  },

  getValues: function(mode) {
    var val = 0;
    this.list.forEach(function(el, i){
      if (dojo.hasClass(el, 'selected') || mode == 1) {
        (val) ? val += '|' + el.i : val = el.i;
      }
    },this);
    if(val != this.hidden.value){
      this.hidden.value = val;
      //OfflajnFireEvent(this.hidden, 'change');
    }
     OfflajnFireEvent(this.hidden, 'change');
  },

  /*
  *Menutypeselector
  */

  typeSelectorInit: function() {
    var ts = this.name.replace('joomlamenutype', 'joomlamenu');
    this.typeselector = dojo.byId(ts);
    dojo.connect(this.typeselector, 'onchange', this, 'changeMenuItems');
    return this.typeselector.value;
  },

  changeMenuItems: function() {
    this.type = this.typeselector.value;
    this.itemscontainer.innerHTML = this.data[this.type];
    this.setSize();
    this.getList();
    this.hidden.value = '';
    this.scrollbar.scrollReInit();
    if(this.list.length <= this.height - 2) this.scrollbar.hideScrollBtn();
  },


  /*
  *Zoo Type Selector
  */

  ZooSelectorInit: function() {
    //var ts = this.name.replace('joomlamenutype', 'joomlamenu');
    var ts = "jformparamsmoduleparametersTabmenutypezooapps";
    this.typeselector = dojo.byId(ts);
    dojo.connect(this.typeselector, 'onchange', this, 'changeZooCategories');
    return this.typeselector.value;
  },

  changeZooCategories: function() {
    this.type = this.typeselector.value;
    this.itemscontainer.innerHTML = this.data[this.type];
    this.setSize();
    this.getList();
    this.hidden.value = '';
    this.scrollbar.scrollReInit();
    if(this.list.length <= this.height - 2) this.scrollbar.hideScrollBtn();
  },


});



dojo.declare("JoomlaType", null, {
  constructor: function(args){
    dojo.mixin(this, args);
    this.list = dojo.byId(this.selectorId);
    if(!this.joomfish){
      this.select = dojo.byId("paramsjoomlamenu") ? dojo.byId("paramsjoomlamenu") : dojo.byId('jformparamsmenutypejoomlamenu');
    }else{
      this.select = dojo.byId(this.control+"joomlamenu");
    }
    dojo.destroy(this.select.options[0]);
    dojo.connect(this.select, 'onchange', this, "changeList");
    this.defaultMenu = this.select.options[this.select.selectedIndex].value;
    this.changeList();
  },
  
  changeList: function(e) {
      var type = this.select.options[this.select.selectedIndex].value;
      var node = dojo.create("div");
      node.innerHTML = this.data[type].replace(/option/g,'div');
      dojo.forEach(this.list.childNodes, function(el){
        if(el)
          el.parentNode.removeChild(el);
      });
      
      dojo.forEach(node.childNodes, function(el){
        if(el.nodeName == 'DIV'){
          var opt = document.createElement('OPTION');
          opt.text = el.innerHTML;
          opt.value = dojo.attr(el,'value');
          opt.selected = dojo.attr(el,'selected');
          this.list.options.add(opt);
        }
      }, this);
      if (type!=this.defaultMenu && e && e.currentTarget == this.select) this.list.selectedIndex = 0;   
      //if(e == undefined) this.list.selectedIndex = 0;
  }
});


dojo.declare("OfflajnOnOff", null, {
	constructor: function(args) {
	 dojo.mixin(this,args);
   this.w = 26;
	 this.init();
  },


  init: function() {
    this.switcher = dojo.byId('offlajnonoff' + this.id);
    this.input = dojo.byId(this.id);
    this.state = parseInt(this.input.value);
    this.click = dojo.connect(this.switcher, 'onclick', this, 'controller');
    if(this.mode == 'button') {
      this.img = dojo.query('.onoffbutton_img', this.switcher);
      if(dojo.hasClass(this.switcher, 'selected')) dojo.style(this.img[0], 'backgroundPosition', '0px -11px');
    } else {
      dojo.connect(this.switcher, 'onmousedown', this, 'mousedown');
    }
    dojo.connect(this.input, 'onchange', this, 'setValue');
  },

  controller: function() {
    if(!this.mode) {
      if(this.anim) this.anim.stop();
      this.state ? this.setOff() : this.setOn();
    } else if(this.mode == "button") {
      this.state ? this.setBtnOff() : this.setBtnOn();
    }
  },

  setBtnOn: function() {
    dojo.style(this.img[0], 'backgroundPosition', '0px -11px');
    dojo.addClass(this.switcher, 'selected');
    this.changeState(1);
  },

  setBtnOff: function() {
    dojo.style(this.img[0], 'backgroundPosition', '0px 0px');
    dojo.removeClass(this.switcher, 'selected');
    this.changeState(0);
  },

  setValue: function() {
    if(this.state != this.input.value) {
      this.controller();
    }
  },

  changeState: function(state){
    if(this.state != state){
      this.state = state;
      this.stateChanged();
    }
  },

  stateChanged: function(){
    this.input.value = this.state;
    OfflajnFireEvent(this.input, 'change');
  },

  mousedown: function(e){
    this.startState = this.state;
    this.move = dojo.connect(document, 'onmousemove', this, 'mousemove');
    this.up = dojo.connect(document, 'onmouseup', this, 'mouseup');
    this.startX = e.clientX;
  },

  mousemove: function(e){
    var x = e.clientX-this.startX;
    if(!this.startState) x-=this.w;
    if(x > 0){
      x = 0;
      this.changeState(1);
    }
    if(x < -1*this.w){
      x = -1*this.w;
      this.changeState(0);
    }
		var str = x+"px 0px";
    dojo.style(this.switcher,"backgroundPosition",str);
  },

  mouseup: function(e){
    dojo.disconnect(this.move);
    dojo.disconnect(this.up);
  },

  getBgpos: function() {
    var pos = dojo.style(this.switcher, 'backgroundPosition');
    if(dojo.isIE <= 8){
      pos = dojo.style(this.switcher, 'backgroundPositionX')+' '+dojo.style(this.switcher, 'backgroundPositionY');
    }
    var bgp = pos.split(' ');
    bgp[0] = parseInt(bgp[0]);
    return !bgp[0] ? 0 : bgp[0];
  },

  setOn: function() {
    this.changeState(1);

    this.anim = new dojo.Animation({
      curve: new dojo._Line(this.getBgpos(),0),
      node: this.switcher,
      onAnimate: function(){
				var str = Math.floor(arguments[0])+"px 0px";
				dojo.style(this.node,"backgroundPosition",str);
			}
    }).play();
  },


  setOff: function() {
    this.changeState(0);

    this.anim = new dojo.Animation({
      curve: new dojo._Line(this.getBgpos(), -1*this.w),
      node: this.switcher,
      onAnimate: function(){
				var str = Math.floor(arguments[0])+"px 0px";
				dojo.style(this.node,"backgroundPosition",str);
			}
    }).play();
  }

});



dojo.declare("OfflajnCombine", null, {
	constructor: function(args) {
    dojo.mixin(this,args);
    this.fields = new Array();
    this.init();
  },


  init: function() {
    this.hidden = dojo.byId(this.id);
    //console.log(this.hidden.value);
    dojo.connect(this.hidden, 'onchange', this, 'reset');
    for(var i = 0;i < this.num; i++){
      this.fields[i] = dojo.byId(this.id+i);
      this.fields[i].combineobj = this;
      if(this.fields[i].loaded) this.fields[i].loaded();
      dojo.connect(this.fields[i], 'change', this, 'change');
    }
    this.reset();

    this.outer = dojo.byId('offlajncombine_outer' + this.id);
    this.items = dojo.query('.offlajncombinefieldcontainer', this.outer);
    if(this.switcherid) {
      this.switcher = dojo.byId(this.switcherid);
      dojo.connect(this.switcher, 'onchange', this, 'hider');
      this.hider();
    }
  },

  reset: function(){
    this.value = this.hidden.value;
    //console.log(this.hidden);
    var values = this.value.split('|*|');
    for(var i = 0;i < this.num; i++){
      if(this.fields[i].value != values[i]){
        this.fields[i].value = values[i] === undefined ? '' : values[i];
        OfflajnFireEvent(this.fields[i], 'change');
      }
    }
  },

  change: function(){
    var value = '';
    for(var i = 0;i < this.num; i++){
      value+= this.fields[i].value+'|*|';
    }
    this.hidden.value = value;
    OfflajnFireEvent(this.hidden, 'change');
  },

  hider: function() {
    var w = dojo.position(this.outer).w;
    if(!this.hiderdiv) {
      //this.hiderdiv = dojo.query('.offlajncombine_hider', this.switcher.parentNode.parentNode.parentNode)[0];
      this.hiderdiv = dojo.query('.offlajncombine_hider', this.switcher.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode)[0];

      dojo.style(this.hiderdiv, 'width',  w - 38 + 'px');
    }

    var switcherVal = this.switcher.value;



    if(this.islist == 1){
      if(switcherVal > 0) {
        switcherVal=0;
      } else {
        switcherVal=1;
      }
    }

    if(switcherVal == 0) {
      this.items.forEach(function(item, i){
        if(i >= this.hideafter && item != this.switcher.parentNode.parentNode) {
          item.style.opacity = 0.5;
          item.style.pointerEvents = 'none';
        }
      }, this);
      if(this.hideafter == 0)
        dojo.style(this.hiderdiv, 'display', 'block');
    } else {
      this.items.forEach(function(item, i){
        if(item != this.switcher.parentNode.parentNode) {
          item.style.opacity = '';
          item.style.pointerEvents = '';
        }
      }, this);
      if(this.hideafter == 0)
        dojo.style(this.hiderdiv, 'display', 'none');
    }
  }
});


dojo.declare("OfflajnText", null, {
	constructor: function(args) {
    dojo.mixin(this,args);
    this.init();
  },


  init: function() {
    this.hidden = dojo.byId(this.id);
    dojo.connect(this.hidden, 'change', this, 'reset');

    this.input = dojo.byId(this.id+'input');
    this.switcher = dojo.byId(this.id+'unit');

    this.placeholder && dojo.attr(this.input, 'placeholder', this.placeholder.replace(/:$/, ''));

    if(this.validation == 'int'){
      dojo.connect(this.input, 'keyup', this, 'validateInt');
      this.validateInt();
    }else if(this.validation == 'float'){
      dojo.connect(this.input, 'keyup', this, 'validateFloat');
      this.validateFloat();
    }
    dojo.connect(this.input, 'onblur', this, 'change');
    if(this.switcher){
      dojo.connect(this.switcher, 'change', this, 'change');
    }else{
      if(this.attachunit != '')
        this.switcher = {'value': this.attachunit, 'noelement':true};

    }
    this.container = dojo.byId('offlajntextcontainer' + this.id);
    if(this.mode == 'increment') {
      this.arrows = dojo.query('.arrow', this.container);
      dojo.connect(this.arrows[0], 'onmousedown', dojo.hitch(this, 'mouseDown', 1));
      dojo.connect(this.arrows[1], 'onmousedown', dojo.hitch(this, 'mouseDown', -1));
    }
    dojo.connect(this.input, 'onfocus', this, dojo.hitch(this, 'setFocus', 1));
    dojo.connect(this.input, 'onblur', this, dojo.hitch(this, 'setFocus', 0));
  },

  reset: function(e){
    if(this.hidden.value != this.input.value+(this.switcher? '||'+this.switcher.value : '')){
      var v = this.hidden.value.split('||');
      this.input.value = v[0];
      if(this.switcher && this.switcher.noelement != true){
        this.switcher.value = v[1];
        OfflajnFireEvent(this.switcher, 'change');
      }
      if(e) dojo.stopEvent(e);
      OfflajnFireEvent(this.input, 'change');
    }
  },

  change: function(){
    this.hidden.value = this.input.value+(this.switcher? '||'+this.switcher.value : '');
    OfflajnFireEvent(this.hidden, 'change');
    if(this.onoff) this.hider();
  },

  setFocus: function(mode) {
    if(mode){
      dojo.addClass(this.input.parentNode, 'focus');
    } else {
      dojo.removeClass(this.input.parentNode, 'focus');
    }
  },

  hider: function() {
    if(!this.hiderdiv) {
      this.hiderdiv = dojo.create('div', {'class': 'offlajntext_hider'}, this.container);
      dojo.style(this.hiderdiv, 'width', dojo.position(this.container).w + 'px');
    }
    if(parseInt(this.switcher.value)) {
      dojo.style(this.container, 'opacity', '1');
      dojo.style(this.hiderdiv, 'display', 'none');
    } else {
      dojo.style(this.container, 'opacity', '0.5');
      dojo.style(this.hiderdiv, 'display', 'block');
    }
  },

  validateInt: function(){
    var val = parseInt(this.input.value, 10);
    if(!val) val = 0;
    this.input.value = val;
  },

  validateFloat: function(){
    var val = parseFloat(this.input.value);
    if(!val) val = 0;
    this.input.value = val;
  },

  mouseDown: function(m){
    dojo.connect(document, 'onmouseup', this, 'mouseUp');
    var f = dojo.hitch(this, 'modifyValue', m);
    f();
    this.interval = setInterval(f, 200);
  },

  mouseUp: function(){
    clearInterval(this.interval);
  },

  modifyValue: function(m) {
    var val = 0;
    if(this.validation == 'int') {
      val = parseInt(this.input.value);
    } else if(this.validation == 'float') {
      val = parseFloat(this.input.value);
    }
    val = val + m*this.scale;
    if(val < 0 && this.minus == 0) val = 0;
    this.input.value = val;
    this.change();
    OfflajnFireEvent(this.input, 'change');
  }
});



dojo.declare("OfflajnSwitcher", null, {
	constructor: function(args) {
	 dojo.mixin(this,args);
   this.w = 11;
	 this.init();
  },


  init: function() {
    this.switcher = dojo.byId('offlajnswitcher_inner' + this.id);
    this.input = dojo.byId(this.id);
    this.state = this.map[this.input.value];
    this.click = dojo.connect(this.switcher, 'onclick', this, 'controller');
    dojo.connect(this.input, 'onchange', this, 'setValue');
    this.elements = new Array();
    this.getUnits();
    this.setSwitcher();
  },

  getUnits: function() {
    var units = dojo.create('div', {'class': 'offlajnswitcher_units' }, this.switcher.parentNode, "after");
    dojo.forEach(this.units, function(item, i){
      this.elements[i] = dojo.create('span', {'class': 'offlajnswitcher_unit', 'innerHTML': item }, units);
      if(this.mode) {
        this.elements[i].innerHTML = '';
        this.elements[i] = dojo.create('img', {'src': this.url + item }, this.elements[i]);
      }
      this.elements[i].i = i;
      dojo.connect(this.elements[i], 'onclick', this, 'selectUnit');
    }, this);
  },

  getBgpos: function() {
    var pos = dojo.style(this.switcher, 'backgroundPosition');
    if(dojo.isIE <= 8){
      pos = dojo.style(this.switcher, 'backgroundPositionX')+' '+dojo.style(this.switcher, 'backgroundPositionY');
    }
    var bgp = pos.split(' ');
    bgp[1] = parseInt(bgp[1]);
    return !bgp[1] ? 0 : bgp[1];
  },

  selectUnit: function(e) {
    this.state = (e.target.i) ? 0 : 1;
    this.controller();
  },

  setSelected: function() {
    var s = (this.state) ? 0 : 1;
    dojo.removeClass(this.elements[s], 'selected');
    dojo.addClass(this.elements[this.state], 'selected');
  },

  controller: function() {
    if(this.anim) this.anim.stop();
    this.state ? this.setSecond() : this.setFirst();
  },


  setValue: function() {
    if(this.values[this.state] != this.input.value) {
      this.controller();
    }
  },

  setSwitcher: function() {
    (this.state) ? this.setFirst() : this.setSecond();
  },

  changeState: function(state){
    if(this.state != state){
      this.state = state;
      this.stateChanged();
    }
    this.setSelected();
  },

  stateChanged: function(){
    this.input.value = this.values[this.state];
    OfflajnFireEvent(this.input, 'change');
  },

  setFirst: function() {
    this.changeState(1);
    var bgp = this.getBgpos();
    this.anim = new dojo.Animation({
      curve: new dojo._Line(bgp, 0),
      node: this.switcher,
      duration: 200,
      onAnimate: function(){
				var str = "center " + Math.floor(arguments[0])+"px";
				dojo.style(this.node,"backgroundPosition",str);
			}
    }).play();
  },


  setSecond: function() {
    this.changeState(0);
    var bgp = this.getBgpos();
    this.anim = new dojo.Animation({
      curve: new dojo._Line(bgp, -1*this.w),
      node: this.switcher,
      duration: 200,
      onAnimate: function(){
				var str =  "center " + Math.floor(arguments[0])+"px";
				dojo.style(this.node,"backgroundPosition",str);
			}
    }).play();
  }

});

dojo.addOnLoad(function(){
      new OfflajnList({
        name: "jformparamsmoduleparametersTabmenutypejoomlamenu",
        options: [{"value":"mainmenu","text":"Mainmenu"},{"value":"hikashop_default","text":"Hikashop_default"},{"value":"services","text":"Services"},{"value":"doctorpage","text":"Doctorpage"},{"value":"chatters-vertical-menu","text":"Chatters-vertical-menu"}],
        selectedIndex: 0,
        json: "",
        width: 0,
        height: 0,
        fireshow: 0
      });
    
new OfflajnMultiSelectList({
      name: "jformparamsmoduleparametersTabmenutypejoomlamenutype",
      height: "10",
      type: "services",
      data: {"":"<div class=\"gk_hack multiselectitem\">All items<\/div><div class=\"gk_hack multiselectitem\">Menu_Item_Root<\/div>","doctorpage":"<div class=\"gk_hack multiselectitem\">All items<\/div><div class=\"gk_hack multiselectitem\">--- \u062b\u0628\u062a \u0646\u0627\u0645 \u067e\u0632\u0634\u06a9<\/div><div class=\"gk_hack multiselectitem\">--- \u0627\u0631\u062a\u0628\u0627\u0637 \u0628\u0627 \u0645\u0627<\/div><div class=\"gk_hack multiselectitem\">--- \u062f\u0631\u0628\u0627\u0631\u0647 \u0645\u0627<\/div><div class=\"gk_hack multiselectitem\">--- \u0642\u0648\u0627\u0646\u06cc\u0646<\/div><div class=\"gk_hack multiselectitem\">--- \u0633\u0648\u0627\u0644\u0627\u062a \u0645\u062a\u062f\u0627\u0648\u0644<\/div><div class=\"gk_hack multiselectitem\">--- \u0645\u0634\u0627\u0648\u0631\u0647 \u0631\u0627\u06cc\u06af\u0627\u0646 \u067e\u0632\u0634\u06a9\u06cc<\/div><div class=\"gk_hack multiselectitem\">--- \u0645\u0634\u0627\u0648\u0631\u0647 \u067e\u0632\u0634\u06a9\u06cc \u062f\u0631 \u062a\u0644\u06af\u0631\u0627\u0645<\/div><div class=\"gk_hack multiselectitem\">--- \u062f\u0631\u0628\u0627\u0631\u0647 \u06a9\u0631\u0648\u0646\u0627 \u0648\u06cc\u0631\u0648\u0633<\/div>","main":"<div class=\"gk_hack multiselectitem\">All items<\/div><div class=\"gk_hack multiselectitem\">--- com_banners<\/div><div class=\"gk_hack multiselectitem\">----- com_banners<\/div><div class=\"gk_hack multiselectitem\">----- com_banners_categories<\/div><div class=\"gk_hack multiselectitem\">----- com_banners_clients<\/div><div class=\"gk_hack multiselectitem\">----- com_banners_tracks<\/div><div class=\"gk_hack multiselectitem\">--- com_contact<\/div><div class=\"gk_hack multiselectitem\">----- com_contact_contacts<\/div><div class=\"gk_hack multiselectitem\">----- com_contact_categories<\/div><div class=\"gk_hack multiselectitem\">--- com_messages<\/div><div class=\"gk_hack multiselectitem\">----- com_messages_add<\/div><div class=\"gk_hack multiselectitem\">--- com_newsfeeds<\/div><div class=\"gk_hack multiselectitem\">----- com_newsfeeds_feeds<\/div><div class=\"gk_hack multiselectitem\">----- com_newsfeeds_categories<\/div><div class=\"gk_hack multiselectitem\">--- com_redirect<\/div><div class=\"gk_hack multiselectitem\">--- com_search<\/div><div class=\"gk_hack multiselectitem\">--- com_finder<\/div><div class=\"gk_hack multiselectitem\">--- com_joomlaupdate<\/div><div class=\"gk_hack multiselectitem\">--- com_tags<\/div><div class=\"gk_hack multiselectitem\">--- com_postinstall<\/div><div class=\"gk_hack multiselectitem\">--- com_associations<\/div><div class=\"gk_hack multiselectitem\">--- HikaShop<\/div><div class=\"gk_hack multiselectitem\">----- Products<\/div><div class=\"gk_hack multiselectitem\">----- Categories<\/div><div class=\"gk_hack multiselectitem\">----- Users<\/div><div class=\"gk_hack multiselectitem\">----- Orders<\/div><div class=\"gk_hack multiselectitem\">----- Configuration<\/div><div class=\"gk_hack multiselectitem\">----- Discounts<\/div><div class=\"gk_hack multiselectitem\">----- Help<\/div><div class=\"gk_hack multiselectitem\">----- Update_About<\/div><div class=\"gk_hack multiselectitem\">--- HikaMarket<\/div><div class=\"gk_hack multiselectitem\">--- RSMembership<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_OVERVIEW<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_TRANSACTIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_MEMBERSHIPS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_MEMBERSHIP_FIELDS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_CATEGORIES<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_EXTRAS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_UPGRADES<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_COUPONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_PAYMENT_INTEGRATIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_FILES<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_TERMS_CONDITIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_SUBSCRIBERS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_SUBSCRIPTIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_CUSTOM_FIELDS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_REPORTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_CONFIGURATION<\/div><div class=\"gk_hack multiselectitem\">----- COM_RSMEMBERSHIP_SYSLOGS<\/div><div class=\"gk_hack multiselectitem\">--- COM_GANTRY5<\/div><div class=\"gk_hack multiselectitem\">----- COM_GANTRY5_ADMIN_MENU_THEMES<\/div><div class=\"gk_hack multiselectitem\">----- COM_GANTRY5_ADMIN_MENU_THEME<\/div><div class=\"gk_hack multiselectitem\">--- COM_SMARTSLIDER3<\/div><div class=\"gk_hack multiselectitem\">--- COM_BLANK_MENU<\/div><div class=\"gk_hack multiselectitem\">--- com_notifly<\/div><div class=\"gk_hack multiselectitem\">--- COM_RESERVATION_MENU<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_RESERVES<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_DOCTORS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_APPOINTMENTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_CAPITALS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_COMMENTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_SESSIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_SICKS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_PLANS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_CONSULTANTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_RESERVATION_MENU_MESSAGES<\/div><div class=\"gk_hack multiselectitem\">--- COM_COMPONENTBUILDER_MENU<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_COMPILER<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_JOOMLA_COMPONENTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_JOOMLA_MODULES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_JOOMLA_PLUGINS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_ADMIN_VIEWS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_CUSTOM_ADMIN_VIEWS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_SITE_VIEWS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_TEMPLATES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_LAYOUTS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_DYNAMIC_GETS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_CUSTOM_CODES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_PLACEHOLDERS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_LIBRARIES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_SNIPPETS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_VALIDATION_RULES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_FIELDS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_FIELDTYPES<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_LANGUAGE_TRANSLATIONS<\/div><div class=\"gk_hack multiselectitem\">----- COM_COMPONENTBUILDER_MENU_HELP_DOCUMENTS<\/div><div class=\"gk_hack multiselectitem\">--- Helpdesk Pro<\/div><div class=\"gk_hack multiselectitem\">----- HDP_CONFIGURATION<\/div><div class=\"gk_hack multiselectitem\">----- HDP_CATEGORIES<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TICKETS<\/div><div class=\"gk_hack multiselectitem\">----- HDP_KNOWLEDGE_BASE<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TICKETS_REPORT<\/div><div class=\"gk_hack multiselectitem\">----- HDP_ACTIVITIES_REPORT<\/div><div class=\"gk_hack multiselectitem\">----- HDP_CUSTOM_FIELDS<\/div><div class=\"gk_hack multiselectitem\">----- HDP_EMAIL_MESSAGES<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TICKET_STATUSES<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TICKET_PRIORITIES<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TICKET_LABELS<\/div><div class=\"gk_hack multiselectitem\">----- HDP_PRE_REPLIES<\/div><div class=\"gk_hack multiselectitem\">----- HDP_TRANSLATION<\/div>","mainmenu":"<div class=\"gk_hack multiselectitem\">All items<\/div><div class=\"gk_hack multiselectitem\">--- \u062e\u0627\u0646\u0647<\/div><div class=\"gk_hack multiselectitem\">--- signin<\/div><div class=\"gk_hack multiselectitem\">--- \u062b\u0628\u062a \u0646\u0627\u0645 \u0645\u0634\u0627\u0648\u0631<\/div><div class=\"gk_hack multiselectitem\">--- \u0646\u0648\u0628\u062a \u062f\u0647\u06cc<\/div><div class=\"gk_hack multiselectitem\">--- \u062b\u0628\u062a \u0646\u0627\u0645 \u062f\u06a9\u062a\u0631<\/div><div class=\"gk_hack multiselectitem\">--- logout<\/div><div class=\"gk_hack multiselectitem\">--- submit ticket<\/div><div class=\"gk_hack multiselectitem\">--- Ticket List<\/div><div class=\"gk_hack multiselectitem\">--- submitTest<\/div>","services":"<div class=\"gk_hack multiselectitem\">All items<\/div><div class=\"gk_hack multiselectitem\">---  \u0645\u0634\u0627\u0648\u0631\u0647 \u0622\u0646\u0644\u0627\u06cc\u0646 \u067e\u0632\u0634\u06a9\u06cc<\/div><div class=\"gk_hack multiselectitem\">--- \u0645\u0634\u0627\u0648\u0631\u0647 \u062a\u0644\u0641\u0646\u06cc<\/div><div class=\"gk_hack multiselectitem\">--- \u0646\u0648\u0628\u062a \u062f\u0647\u06cc \u0622\u0646\u0644\u0627\u06cc\u0646<\/div><div class=\"gk_hack multiselectitem\">--- \u0628\u0627\u0646\u06a9 \u0633\u0644\u0627\u0645\u062a<\/div><div class=\"gk_hack multiselectitem\">--- \u0645\u062c\u0644\u0647 \u0633\u0644\u0627\u0645\u062a<\/div><div class=\"gk_hack multiselectitem\">--- \u062f\u06a9\u062a\u0631 \u0622\u0646\u0644\u0627\u06cc\u0646<\/div>"},
      options: [],
      joomla: 1,
      ids: {"":["1"],"doctorpage":["1763","1764","1765","1766","1767","1768","1769","1770"],"main":["2","3","4","5","6","7","8","9","10","11","13","14","15","16","17","18","19","20","21","22","445","446","447","448","449","450","451","452","453","454","460","461","462","463","464","465","466","467","468","469","470","471","472","473","474","475","476","477","1750","1751","1752","1753","1754","1778","2198","2199","2200","2201","2202","2203","2204","2205","2206","2207","2208","2223","2224","2225","2226","2227","2228","2229","2230","2231","2232","2233","2234","2235","2236","2237","2238","2239","2240","2241","2242","2245","2246","2247","2248","2249","2250","2251","2252","2253","2254","2255","2256","2257","2258"],"mainmenu":["101","138","148","421","505","139","2243","2244","2259"],"services":["1755","1756","1757","1758","1759","1760"]},
      mode: 1
    });

      new OfflajnOnOff({
        id: "jformparamsmoduleparametersTabmenutypeparenthref",
        mode: "",
        imgs: ""
      }); 
    

      new OfflajnList({
        name: "jformparamsmoduleparametersTabmenutypedisplaynumprod",
        options: [{"value":"0","text":"No"},{"value":"1","text":"Yes only the real count"},{"value":"2","text":"Yes the aggregated count on each category"}],
        selectedIndex: 0,
        json: "",
        width: 0,
        height: 0,
        fireshow: 0
      });
    

      new OfflajnOnOff({
        id: "jformparamsmoduleparametersTabmenutypesubheader0",
        mode: "",
        imgs: ""
      }); 
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutypesubheader1",
        validation: "int",
        attachunit: "",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnCombine({
        id: "jformparamsmoduleparametersTabmenutypesubheader",
        num: 2,
        switcherid: "jformparamsmoduleparametersTabmenutypesubheader0",
        hideafter: "0",
        islist: "0"
      }); 
    

      new OfflajnOnOff({
        id: "jformparamsmoduleparametersTabmenutypemenu_images",
        mode: "",
        imgs: ""
      }); 
    

      new OfflajnOnOff({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon0",
        mode: "",
        imgs: ""
      }); 
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon1",
        validation: "int",
        attachunit: "px",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon2",
        validation: "int",
        attachunit: "px",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon3",
        validation: "int",
        attachunit: "px",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    
dojo.addOnLoad(function(){ 
      new OfflajnSwitcher({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon4",
        units: ["Scale","Crop"],
        values: ["1","0"],
        map: {"1":0,"0":1},
        mode: 0,
        url: "http:\/\/lmsyaran.ir\/administrator\/..\/modules\/mod_vertical_menu\/params\/offlajnswitcher\/images\/"
      }); 
    });

      new OfflajnCombine({
        id: "jformparamsmoduleparametersTabmenutyperesizeicon",
        num: 5,
        switcherid: "jformparamsmoduleparametersTabmenutyperesizeicon0",
        hideafter: "2",
        islist: "0"
      }); 
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius0",
        validation: "int",
        attachunit: "",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius1",
        validation: "int",
        attachunit: "",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius2",
        validation: "int",
        attachunit: "",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    

      new OfflajnText({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius3",
        validation: "int",
        attachunit: "",
        mode: "",
        scale: "",
        minus: 0,
        onoff: "",
        placeholder: ""
      });
    
dojo.addOnLoad(function(){ 
      new OfflajnSwitcher({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius4",
        units: ["%","px"],
        values: ["%","px"],
        map: {"%":0,"px":1},
        mode: 0,
        url: "http:\/\/lmsyaran.ir\/administrator\/..\/modules\/mod_vertical_menu\/params\/offlajnswitcher\/images\/"
      }); 
    });

      new OfflajnCombine({
        id: "jformparamsmoduleparametersTabmenutypeiconborderradius",
        num: 5,
        switcherid: "",
        hideafter: "0",
        islist: "0"
      }); 
    });
      djConfig = {};})();