<?php

namespace Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds\Sources;

use DJClassifiedsSEO;
use JRoute;
use Nextend\Framework\Database\Database;
use Nextend\Framework\Filesystem\Filesystem;
use Nextend\Framework\Form\Container\ContainerTable;
use Nextend\Framework\Form\Element\MixedField\GeneratorOrder;
use Nextend\Framework\Form\Element\Select\Filter;
use Nextend\Framework\Form\Joomla\Element\Select\MenuItems;
use Nextend\Framework\Notification\Notification;
use Nextend\Framework\Parser\Common;
use Nextend\Framework\ResourceTranslator\ResourceTranslator;
use Nextend\Framework\Url\Url;
use Nextend\SmartSlider3\Generator\AbstractGenerator;
use Nextend\SmartSlider3\Platform\Joomla\ImageFallback;
use Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds\Elements\DjclassifiedsCategories;
use Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds\Elements\DjclassifiedsLocations;
use Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds\Elements\DjclassifiedsTypes;

class DjclassifiedsItems extends AbstractGenerator {

    protected $layout = 'image';

    public function getDescription() {
        return sprintf(n2_('Creates slides from %1$s content.'), 'DJ Classifieds');
    }

    public function renderFields($container) {

        Notification::notice(sprintf('%s is deprecated and will be removed after %s.', 'DJ Classifieds generator', 'December 31st, 2020'));

        parent::renderFields($container);

        $filterGroup = new ContainerTable($container, 'filter', n2_('Filter'));

        $source = $filterGroup->createRow('source-row');
        new DjclassifiedsCategories($source, 'categories', n2_('Categories'), 0, array(
            'isMultiple' => true,
            'size'       => 10
        ));

        new DjclassifiedsLocations($source, 'locations', n2_('Locations'), 0, array(
            'isMultiple' => true,
            'size'       => 10
        ));

        new DjclassifiedsTypes($source, 'types', n2_('Types'), 0, array(
            'isMultiple' => true,
            'size'       => 10
        ));


        $limit = $filterGroup->createRow('limit-row');

        new Filter($limit, 'expired', n2_('Expired'), '-1');

        new Filter($limit, 'started', n2_('Started'), '1');

        new Filter($limit, 'auction', n2_('Auction'), 0);

        new Filter($limit, 'negotiable', n2_('Negotiable price'), 0);

        new Filter($limit, 'blocked', n2_('Blocked by User'), '-1');

        new Filter($limit, 'paid', n2_('Paid'), 0);

        new Filter($limit, 'buynow', n2_('Buynow'), 0);

        $url = $filterGroup->createRow('url-row');

        new MenuItems($url, 'itemid', n2_('Menu item (item ID)'), 0, array(
            'tipLabel'       => n2_('URL'),
            'tipDescription' => n2_('Your url will point to the item within this menu item. You will only get a good result, if you will pick one of your DJ Classifields menu items or leave it on \'Default\'.'),
            'tipLink'        => '??????'
        ));

        $orderGroup = new ContainerTable($container, 'order-group', n2_('Order'));
        $order      = $orderGroup->createRow('order-row');
        new GeneratorOrder($order, 'djclassifiedsorder', 'date_start|*|asc', array(
            'options' => array(
                ''             => n2_('None'),
                'i.name'       => n2_('Name'),
                'i.date_start' => n2_('Start date'),
                'i.date_exp'   => n2_('Expiration date'),
                'ABS(i.price)' => n2_('Price'),
                'i.id'         => 'ID'
            )
        ));
    }

    protected function fileExists($path, $root = JPATH_SITE) {
        $file = $root . $path;
        if (Filesystem::fileexists($file)) {
            return ResourceTranslator::urlToResource(Url::pathToUri($file));
        } else {
            return '';
        }
    }

    protected function _getData($count, $startIndex) {
        if (!defined("DS")) {
            define('DS', DIRECTORY_SEPARATOR);
        }

        require_once(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_djclassifieds' . DS . 'lib' . DS . 'djseo.php');

        $categories = array_map('intval', explode('||', $this->data->get('categories', 0)));
        $locations  = array_map('intval', explode('||', $this->data->get('locations', 0)));
        $types      = array_map('intval', explode('||', $this->data->get('types', 0)));

        $where = array(
            "i.published = 1 "
        );

        if (!in_array(0, $categories) && count($categories) > 0) {
            $where[] = "i.cat_id IN (" . implode(',', $categories) . ")";
        }

        if (!in_array(0, $locations) && count($locations) > 0) {
            $where[] = "i.region_id IN (" . implode(',', $locations) . ")";
        }

        if (!in_array(0, $types) && count($types) > 0) {
            $where[] = "i.type_id IN (" . implode(',', $types) . ")";
        }

        $today = date('Y-m-d h:i:s', time());

        switch ($this->data->get('expired', '-1')) {
            case 1:
                $where[] = "i.date_exp <= '" . $today . "'";
                break;
            case -1:
                $where[] = "i.date_exp > '" . $today . "'";
                break;
        }

        switch ($this->data->get('started', '1')) {
            case 1:
                $where[] = "i.date_start <= '" . $today . "'";
                break;
            case -1:
                $where[] = "i.date_start > '" . $today . "'";
                break;
        }

        switch ($this->data->get('negotiable', 0)) {
            case 1:
                $where[] = "i.price_negotiable = 1 ";
                break;
            case -1:
                $where[] = "i.price_negotiable = 0 ";
                break;
        }

        switch ($this->data->get('blocked', 0)) {
            case 1:
                $where[] = "i.blocked = 1 ";
                break;
            case -1:
                $where[] = "i.blocked = 0 ";
                break;
        }

        switch ($this->data->get('paid', 0)) {
            case 1:
                $where[] = "i.payed = 1 ";
                break;
            case -1:
                $where[] = "i.payed = 0 ";
                break;
        }

        switch ($this->data->get('buynow', 0)) {
            case 1:
                $where[] = "i.buynow = 1 ";
                break;
            case -1:
                $where[] = "i.buynow = 0 ";
                break;
        }

        switch ($this->data->get('auction', 0)) {
            case 1:
                $where[] = "i.auction = 1 ";
                break;
            case -1:
                $where[] = "i.auction = 0 ";
                break;
        }

        $query = "SELECT 
                    i.id, i.cat_id, i.name, i.alias, i.description, i.intro_desc, i.date_start, i.date_exp, 
                    i.price, i.contact, i.address, i.post_code, i.video, i.website, i.currency, 
                    i.metakey, i.metadesc, i.email, i.bid_min, i.bid_max, i.price_reserve, i.price_start, 
                    im.path, im.name AS image_name, im.ext, im.caption,
                    c.name AS category_name, c.alias AS category_alias,
                    r.name AS region_name, r.id AS region_id 
                    FROM #__djcf_items AS i 
                    LEFT JOIN #__djcf_images AS im ON i.id = im.item_id AND im.type='item'  
                    LEFT JOIN #__djcf_categories AS c ON i.cat_id = c.id  
                    LEFT JOIN #__djcf_regions AS r ON i.region_id = r.id  
                    WHERE " . implode(' AND ', $where);

        $order = Common::parse($this->data->get('djclassifiedsorder', 'date_start|*|asc'));
        if ($order[0]) {
            $query .= ' ORDER BY ' . $order[0] . ' ' . $order[1] . ' ';
        }

        $query .= ' LIMIT ' . $startIndex . ', ' . $count;

        $result = Database::queryAll($query);

        if ($this->data->get('itemid', 0)) {
            $itemid = '&Itemid=' . $this->data->get('itemid', 0);
        } else {
            $itemid = '';
        }

        $data = array();
        for ($i = 0; $i < count($result); $i++) {
            $r = array(
                'name'        => $result[$i]['name'],
                'title'       => $result[$i]['name'],
                'description' => $result[$i]['description'],
                'intro_desc'  => $result[$i]['intro_desc'],
                'url'         => JRoute::_(DJClassifiedsSEO::getItemRoute($result[$i]['id'], $result[$i]['cat_id'], $result[$i]['region_id']) . $itemid, false)
            );

            if (!empty($result[$i]['image_name'])) {
                $r += array(
                    'image_original' => $this->fileExists($result[$i]['path'] . $result[$i]['image_name'] . '.' . $result[$i]['ext']),
                    'image_ths'      => $this->fileExists($result[$i]['path'] . $result[$i]['image_name'] . '_ths.' . $result[$i]['ext']),
                    'image_thm'      => $this->fileExists($result[$i]['path'] . $result[$i]['image_name'] . '_thm.' . $result[$i]['ext']),
                    'image_thb'      => $this->fileExists($result[$i]['path'] . $result[$i]['image_name'] . '_thb.' . $result[$i]['ext']),
                );

                $r['image'] = ImageFallback::fallback(array(
                    ltrim($r['image_original'], '$/'),
                    ltrim($r['image_thb'], '$/'),
                    ltrim($r['image_thm'], '$/'),
                    ltrim($r['image_ths'], '$/')
                ), array(
                    $result[$i]['description'],
                    $result[$i]['intro_desc']
                ));
            }

            $r += array(
                'date_start'    => $result[$i]['date_start'],
                'date_exp'      => $result[$i]['date_exp'],
                'price'         => $result[$i]['price'],
                'currency'      => $result[$i]['currency'],
                'contact'       => $result[$i]['contact'],
                'address'       => $result[$i]['address'],
                'post_code'     => $result[$i]['post_code'],
                'video'         => $result[$i]['video'],
                'website'       => $result[$i]['website'],
                'metakey'       => $result[$i]['metakey'],
                'metadesc'      => $result[$i]['metadesc'],
                'email'         => $result[$i]['email'],
                'bid_min'       => $result[$i]['bid_min'],
                'bid_max'       => $result[$i]['bid_max'],
                'price_reserve' => $result[$i]['price_reserve'],
                'price_start'   => $result[$i]['price_start'],
                'image_caption' => $result[$i]['caption'],
                'id'            => $result[$i]['id'],
                'cat_id'        => $result[$i]['cat_id'],
            );

            $data[] = $r;
        }

        return $data;
    }
}