HDP = window.HDP || {};
HDP.jQuery = jQuery.noConflict();
(function ($) {
    HDP.addAttachment = function () {
        if (currentNumberAttachment >= maxAttachment) {
            alert("You cannot add more attachment to ticket. Maximum Attachment per ticket is : " + maxAttachment);
        } else {
            var attachmentId = '#hdp_attachment_' + currentNumberAttachment;
            $(attachmentId).show('');
            currentNumberAttachment++;
        }
    };

    HDP.removeAttachment = function () {
        if (currentNumberAttachment > 1) {
            var attachmentId = '#hdp_attachment_' + (currentNumberAttachment - 1);
            $(attachmentId).hide('');
            currentNumberAttachment--;
        } else {
            alert("There are no remaining attachment to remove");
        }
    };

    HDP.showFields = function (form) {
        var newCategoryId = form.category_id.value;
        if (newCategoryId == '') {
            newCategoryId = 0;
        }
        var allFields = fields[0];
        if (allFields) {
            for (var i = 0; i < allFields.length; i++) {
                if (allFields[i]) {
                    var trId = '#field_' + allFields[i];
                    $(trId).show('');
                }
            }
        }
        if (currentCategory > 0) {
            var oldFields = fields[currentCategory];
            //Hide the old fields
            if (oldFields) {
                for (var i = 0; i < oldFields.length; i++) {
                    if (oldFields[i]) {
                        var trId = '#field_' + oldFields[i];
                        $(trId).hide('');
                    }
                }
            }
        }
        var newFields = fields[newCategoryId];
        if (newFields) {
            for (var i = 0; i < newFields.length; i++) {
                if (newFields[i]) {
                    var trId = '#field_' + newFields[i];
                    $(trId).show('');
                }
            }
        }
        currentCategory = newCategoryId;
    };

    HDP.showMessageBox = function () {
        if (currentStatus) {
            $('#tr_message_id').hide();
            currentStatus = 0;
        } else {
            $('#tr_message_id').show();
            currentStatus = 1;
        }
    };

    HDP.changeTicketCategory = function (newCategoryId) {
        form = document.adminForm;
        form.new_value.value = newCategoryId;
        form.task.value = 'ticket.update_category';
        form.submit();
    };

    HDP.applyTicketLabel = function (labelId) {
        form = document.adminForm;
        form.new_value.value = labelId;
        form.task.value = 'ticket.apply_label';
        form.submit();
    };

    HDP.changeTicketPriority = function (newPriority) {
        form = document.adminForm;
        form.new_value.value = newPriority;
        form.task.value = 'ticket.update_priority';
        form.submit();
    };

    HDP.changeTicketStatus = function (newStatus) {
        form = document.adminForm;
        form.new_value.value = newStatus;
        form.task.value = 'ticket.update_status';
        form.submit();
    };

    HDP.ticketRating = function (rating) {
        form = document.adminForm;
        form.new_value.value = rating;
        form.task.value = 'ticket.save_rating';
        form.submit();
    };

    HDP.ticketList = function () {
        if (typeof jItemId == 'undefined') {
            location.href = 'index.php?option=com_helpdeskpro&view=tickets';
        } else {
            location.href = 'index.php?option=com_helpdeskpro&view=tickets&Itemid=' + jItemId;
        }
    };

    $(document).ready(function () {
        $('.edit_comment').on("click", function (event) {
            event.preventDefault();
            var messageId = $(this).attr('id');
            $.fn.editable.defaults.mode = 'popup';
            $('#hdp_ticket_edit-text-' + messageId).editable({
                validate: function (value) {
                    if ($.trim(value) == '') return 'This value is required.';
                },
                inputclass: 'input-xxlarge',
                type: 'textarea',
                placement: 'top',
                success: function (response, newValue) {
                    $('.editable-pre-wrapped').css("white-space", "pre-wrap");
                    var data = {
                        'task': 'ticket.update_comment',
                        'message_id': messageId,
                        'new_message': newValue
                    };
                    $.ajax({
                        type: 'POST',
                        url: hdpSiteUrl + 'index.php?option=com_helpdeskpro',
                        data: data,
                        error: function (jqXHR, textStatus, errorThrown) {
                            alert(textStatus);
                        }
                    });
                }
            }).click();
            event.stopPropagation();
        });

        //remove comment
        $('.remove_comment').click(function () {
            var r = confirm("Do you want to delete the selected message ?");
            if (r == true) {
                var messageId = $(this).attr('id');
                var data = {
                    'task': 'ticket.remove_comment',
                    'message_id': messageId
                };
                $(this).attr('disabled', 'disabled');
                $.ajax({
                    type: 'POST',
                    url: hdpSiteUrl + 'index.php?option=com_helpdeskpro',
                    data: data,
                    success: function () {
                        $('#mesage-' + messageId).remove();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        alert(textStatus);
                    }
                });
            }
        })
    });
}(HDP.jQuery));