<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.41
	@build			18th September, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		planrule.php
	@author			Lmskaran <https://Lmskaran.com>
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__)

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormRule;
use Joomla\Registry\Registry;

/**
 * Form Rule (Planrule) class for the Joomla Platform.
 */
class JFormRuleEplanrule extends FormRule
{

    /***[JCBGUI.validation_rule.php.10.$$$$]***/
    public function test(\SimpleXMLElement $element, $value, $group = null, Registry $input = null, Form $form = null)
    {

        $user= jFactory::getUser();
        $user_id= $user->get('id');

        if ((!file_exists(JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php')) || (!file_exists(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php'))) {
            echo 'CB not installed';
            return;
        }

        include_once(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php');

        $cbUser =& CBuser::getInstance($user_id);
        $user =& $cbUser->getUserData();

        $degree = $user->get('cb_gradetahsili');
        if ($degree== '22')
            $value['final_price_per_min']= 'master';
        elseif ($degree== '33')
            $value['final_price_per_min']= 'phd';


        // dump($degree,"degree");
        if (!$degree){
            return array("status"=>false,"msg"=>"سطح تحصیلات شما هنوز تایید نشده است");
        }

        //$value['final_price_per_min']= 'master';
        $plan_type= $value['plantype'];
        switch ($plan_type)
        {
            case 1:
                return $this->handle_mobile_plan($value);
                break;
            case 2:
                return $this->handle_text_plan($value);
                break;
            case 3:
                return $this->handle_video_plan($value);
                break;
        }

    }

    private function handle_mobile_plan($value)
    {
        $return_data=[];
        $min= 30;
        $max= 30;
        $waitingTime= 0;
        $master_price_per_min= 4800;
        $phd_price_per_min= 5500;

        if ($value['final_price_per_min']== 'master')
            $final_price_per_min= $master_price_per_min;
        else if ($value['final_price_per_min']== 'phd')
            $final_price_per_min= $phd_price_per_min;

        $time= $value['time'];
        $price= $value['price'];


        $total= (int) $time * $final_price_per_min;
        $min_price= $total - (20/100*$total);
        $max_price= $total + (20/100*$total);

        $return_data['total']= 0;
        if ($time < $min or $time > $max)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداقل زمان مشاوره تلفنی {$min} دقیقه و حداکثر زمان مشاوره تلفنی {$max} دقیقه میباشد";
            return $return_data;
        }

        $return_data['total']= $total;

        if ($value['waitingtime'] < 0 or  $value['waitingtime'] > $waitingTime)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداکثر زمان انتظار برای مشاوره متنی {$waitingTime} دقیقه میباشد";
            return $return_data;
        }


        if ($value['submit'])
        {
            if ($price < $min_price or $price > $max_price )
            {
                $return_data['status']= false;
                $return_data['msg']= "حداقل هزینه مشاوره تلفنی {$min_price} و حداکثر هزینه مشاوره تلفنی {$max_price} میباشد";
                return $return_data;
            }

            $return_data['status']= true;
            $return_data['msg']= "پلن شما با موفقیت ایجاد گردید";
            return $return_data;
        }

        $return_data['status']= false;
        $return_data['msg']= "";
        return $return_data;
    }


    private function handle_text_plan($value)
    {
        $return_data=[];
        $min= 30;
        $max= 30;
        $waitingTime= 0;
        $master_price_per_min= 4500;
        $phd_price_per_min= 5000;

        if ($value['final_price_per_min']== 'master')
            $final_price_per_min= $master_price_per_min;
        else if ($value['final_price_per_min']== 'phd')
            $final_price_per_min= $phd_price_per_min;

        $time= $value['time'];
        $price= $value['price'];


        $total= (int) $time * $final_price_per_min;
        $min_price= $total - (20/100*$total);
        $max_price= $total + (20/100*$total);

        $return_data['total']= 0;
        if ($time < $min or $time > $max)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداقل زمان مشاوره متنی {$min} دقیقه و حداکثر زمان مشاوره متنی {$max} دقیقه میباشد";
            return $return_data;
        }

        $return_data['total']= $total;

        if ($value['waitingtime'] < 0 or  $value['waitingtime'] > $waitingTime)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداکثر زمان انتظار برای مشاوره متنی {$waitingTime} دقیقه میباشد";
            return $return_data;
        }


        if ($value['submit'])
        {
            if ($price < $min_price or $price > $max_price )
            {
                $return_data['status']= false;
                $return_data['msg']= "حداقل هزینه مشاوره متنی {$min_price} و حداکثر هزینه مشاوره متنی {$max_price} میباشد";
                return $return_data;
            }

            $return_data['status']= true;
            $return_data['msg']= "پلن شما با موفقیت ایجاد گردید";
            return $return_data;
        }

        $return_data['status']= false;
        $return_data['msg']= "";
        return $return_data;
    }


    private function handle_video_plan($value)
    {
        $return_data=[];
        $min= 30;
        $max= 30;
        $waitingTime= 0;
        $master_price_per_min= 5000;
        $phd_price_per_min= 6000;

        if ($value['final_price_per_min']== 'master')
            $final_price_per_min= $master_price_per_min;
        else if ($value['final_price_per_min']== 'phd')
            $final_price_per_min= $phd_price_per_min;

        $time= $value['time'];
        $price= $value['price'];


        $total= (int) $time * $final_price_per_min;
        $min_price= $total - (20/100*$total);
        $max_price= $total + (20/100*$total);

        $return_data['total']= 0;
        if ($time < $min or $time > $max)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداقل زمان مشاوره ویدیویی {$min} دقیقه و حداکثر زمان مشاوره ویدیویی {$max} دقیقه میباشد";
            return $return_data;
        }

        $return_data['total']= $total;

        if ($value['waitingtime'] < 0 or  $value['waitingtime'] > $waitingTime)
        {
            $return_data['status']= false;
            $return_data['msg']= "حداکثر زمان انتظار برای مشاوره ویدیویی {$waitingTime} دقیقه میباشد";
            return $return_data;
        }


        if ($value['submit'])
        {
            if ($price < $min_price or $price > $max_price )
            {
                $return_data['status']= false;
                $return_data['msg']= "حداقل هزینه مشاوره ویدیویی {$min_price} و حداکثر هزینه مشاوره ویدیویی {$max_price} میباشد";
                return $return_data;
            }

            $return_data['status']= true;
            $return_data['msg']= "پلن شما با موفقیت ایجاد گردید";
            return $return_data;
        }

        $return_data['status']= false;
        $return_data['msg']= "";
        return $return_data;
    }/***[/JCBGUI$$$$]***/

}
