<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', '#jform_catid', null, array('disable_search_threshold' => 0 ));
JHtml::_('formbehavior.chosen', 'select');

// Create shortcut to parameters.
$params = clone($this->state->get('params'));
$params->merge(new Registry($this->item->attribs));

$app = JFactory::getApplication();
$input = $app->input;

JFactory::getDocument()->addScriptDeclaration('
	Joomla.submitbutton = function(task)
	{
		if (task == "event.cancel" || document.formvalidator.isValid(document.getElementById("item-form")))
		{
			jQuery("#permissions-sliders select").attr("disabled", "disabled");
			Joomla.submitform(task, document.getElementById("item-form"));

			// @deprecated 4.0  The following js is not needed since 3.7.0.
			if (task !== "event.apply")
			{
				window.parent.jQuery("#templateEdit' . (int) $this->item->id . 'Modal").modal("hide");
			}
		}
	};
');

// In case of modal
$isModal = $input->get('layout') == 'modal' ? true : false;
$layout  = $isModal ? 'modal' : 'edit';
$tmpl    = $isModal || $input->get('tmpl', '', 'cmd') === 'component' ? '&tmpl=component' : '';
?>
<style type="text/css">
	#cf .input-append input[type="text"]{
		display: inline-block;
	}
</style>
<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=event&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-validate">
<div id="cf" class="event-edit tx-flex">
	<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
	<?php endif;?>
	<div class="tx-main">
		<div class="page-header">
		  <h1>Edit Event</h1>
		  <!-- Nav tabs -->
		  <ul class="nav nav-tabs" role="tablist">
		    <li class="active"><a href="#message" aria-controls="home" role="tab" data-toggle="tab">Message</a></li>
		  </ul>
		</div> <!-- page header -->
		<div class="page-content">
			<div class="tab-content">
				<div class="tab-pane active" id="message">
					<div class="row">
						<div class="col-md-8">
							<div class="panel panel-default">
								<div class="panel-heading">Event options</div>
								<div class="panel-body">
									<?php echo $this->form->renderField('template'); ?>
									<?php echo $this->form->renderField('url'); ?>
									<?php echo $this->form->renderField('image_url'); ?>
									<?php echo $this->form->renderField('title'); ?>
									<?php echo $this->form->renderField('name'); ?>
									<?php echo $this->form->renderField('email'); ?>
									<?php echo $this->form->renderField('ip'); ?>
									
									<?php echo $this->form->renderField('city'); ?>
									<?php echo $this->form->renderField('state'); ?>
									<?php echo $this->form->renderField('country'); ?>
									
									<?php echo $this->form->renderField('created'); ?>

								</div>
							</div>
						</div>
						<div class="col-md-4">
							<!-- 
							<h4>Help Document</h4>
							<div class="panel panel-default">
								<div class="panel-body">
									Coming soon...
								</div>
							</div>
							 -->
						</div>
					</div>
				</div>			
			</div>
		</div>
	</div>
</div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="return" value="<?php echo $input->getCmd('return'); ?>" />
	<?php echo JHtml::_('form.token'); ?>
</form>
