<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		coursescategory.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Coursescategory Form Field class for the Moojla component
 */
class JFormFieldCoursescategory extends JFormFieldList
{
	/**
	 * The coursescategory field type.
	 *
	 * @var		string
	 */
	public $type = 'coursescategory';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
		$params = JComponentHelper::getParams('com_moojla');
		$shop_integration = trim($params->get('shop_integration'));
		$user = JFactory::getUser();
		// Get the databse object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		
		if($shop_integration == 'hk' ){
			$query->select($db->quoteName(array('category_id','category_name'),array('id','title')));
			$query->from($db->quoteName('#__hikashop_category', 'a'));
			$query->where($db->quoteName('a.category_type') . ' =  "product"');
			$query->where($db->quoteName('a.category_published') . ' = 1');
		}

		
		$db->setQuery((string)$query);
		if($shop_integration != "0"){
			$items = $db->loadObjectList();
		}
		else
		{
			$items = array();
		}
		$options = array();
		if ($items)
		{
			$options[] = JHtml::_('select.option', '', 'Select an option');
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->id, $item->title);
			}
		}
		return $options;
	}
}
