<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');
$params = JComponentHelper::getParams( 'com_invoices' );

$payment_status = InvoicesHelper::getPaymentStatus();

$this->cs_modules = array();
?>

<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'invoices'.DS.'tmpl'.DS.'default_menu.php'); ?>

<div id="im-app" class="wrap push shrink invoice-manager">

  <?php echo $this->loadTemplate('totals'); ?>

  <form action="index.php" method="post" name="adminForm" id="adminForm" class="">

    <?php echo $this->loadTemplate('filter'); ?>

    <table class="table table-hover">
      <thead>
        <tr>
          <th width="20" class="hidden-xs"> <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" /></th>
          <th width="5"><?php echo InvoicesHelper::build_order_header('ID', 'pa.id', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th><?php echo InvoicesHelper::build_order_header('INVOICE', 'i.id', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('CONTACT', 'co.name', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th><?php echo InvoicesHelper::build_order_header('AMOUNT', 'pa.payment_amount', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th><?php echo InvoicesHelper::build_order_header('STATUS', 'pa.payment_status', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('CREATION_DATE', 'pa.created_datetime', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('DUE_DATE', 'pa.payment_duedate', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('PAYMENT_DATETIME', 'pa.payment_datetime', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo JText::_('INVOICE_TOTAL'); ?> </th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('PAYMENT_TYPE', 'pa.payment_type', $this->lists['order'], $this->lists['order_Dir']); ?></th>

        </tr>
      </thead>

      <tbody id="payments-body">

        <tr
          v-for="payment in payments"
          is="payment"
          :payment="payment"
          :id="'row' + payment.id"
          class="item-row"
        >
        </tr>

      </tbody>

    </table>

    <div id="loadmoreajaxloader_invoices" class="text-muted clear_row text-center" v-show="isLoading">
      <div class="mdl-spinner mdl-spinner--single-color mdl-js-spinner is-active"></div>
    </div>

    <div class="no-more-entries text-muted clear_row text-center " v-show="!more_items"><?php echo JText::_('NO_MORE_ENTRIES'); ?></div>

    <div id="end_container_payments" class="clear_row"></div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="controller" value="payment" />
    <input type="hidden" name="filter_order" id="filter_order" value="<?php echo $this->lists['order']; ?>" />
    <input type="hidden" name="filter_order_Dir" id="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
  </form>

  <?php echo $this->loadTemplate('editmodal'); ?>

</div>

<div align="center" class="footer-sticky hidden-xs"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>

<template id="payment-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'payment.php'); ?>
</template>

<template id="paymentform-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'payment'.DS.'form.php'); ?>
</template>

<template id="invoice-suggestion-template" >
<?php echo $this->loadTemplate('invoice_result_template'); ?>
</template>

<?php if(file_exists(JPATH_SITE.DS.'modules'.DS.'mod_content_statistics_compare'.DS.'tmpl'.DS.'components'.DS.'googlecharts.php')){ ?>
<template id="googlecharts-template" >
<?php include(JPATH_SITE.DS.'modules'.DS.'mod_content_statistics_compare'.DS.'tmpl'.DS.'components'.DS.'googlecharts.php'); ?>
</template>
<?php } ?>

<script type="text/javascript">

var pagination_step = 20<?php //echo $this->limit; ?>;
var start = 0;
var pendingKeyword = null;
var component = "<?php echo $this->input->get('option'); ?>";
var appId = "<?php echo $this->input->get('appId'); ?>";

var clearingFilters = false;

//http://www.sitepoint.com/jquery-infinite-scrolling-demos/
jQuery( document ).ready(function() {

  jQuery(window).scroll(function()
  {

    if(jQuery(window).scrollTop() >= jQuery('#end_container_payments').offset().top + jQuery('#end_container_payments').height() - jQuery(window).height())
    {
      if(!vm.isLoading && vm.more_items){
        vm.isLoading = true;
        load_more_items();
      }
    }

  });

});
</script>

<script>

  var vm = {
    summary : {
      num_payments: 0,
      total_paid: 0,
      total_pending: 0,
      total_late: 0
    },
    payments: [],
    current_action: '',
    current_payment: new Payment({id:0}),
    format: {
      before : "<?php echo $params->get('currency_before', ''); ?>",
      after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_before : "<?php echo $params->get('currency_before', ''); ?>",
      currency_after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_id : "<?php echo $params->get('currency_id', '1'); ?>",
      noMoreEntriesText : "<?php echo JText::_('NO_MORE_ENTRIES'); ?>",
      decimals : "<?php echo $params->get('decimals', '2'); ?>",
      number_decimals : "<?php echo $params->get('decimals', '2'); ?>",
      decpoint : "<?php echo $params->get('decpoint', '.'); ?>",
      thousands : "<?php echo $params->get('thousands', ','); ?>",
      minus_format : "<?php echo $params->get('minus_format', 'minus'); ?>",
    },
    isLoading: true,
    more_items: true,
    cal_start: "<?php echo $this->cal_start ?>",
    cal_end: "<?php echo $this->cal_end ?>",
    status_id: "<?php echo $this->status_id ?>",
    keywords: "<?php echo $this->keywords ?>",
    user_id: "<?php echo $this->user_id ?>",
    invoice_id: "<?php echo $this->invoice_id ?>",
    filter_currency_id: "<?php echo $this->currency_id ?>",
    filter_order: "<?php echo $this->lists['order'] ?>",
    filter_order_Dir: "<?php echo $this->lists['order_Dir'] ?>",
    currencies: {<?php foreach($this->currencies as $currency_id => $currency){ ?>
                  <?php if($currency->id) { echo $currency->id; ?>: <?php echo json_encode($currency); ?>,<?php } ?>
                <?php } ?>},
    currency_id: "<?php echo $this->currency_id ? $this->currency_id : $params->get('currency_id', '1'); ?>",
    default_currency_id: "<?php echo $params->get('currency_id', '1'); ?>",
    statuses: {
      <?php
      $statuses = InvoicesHelper::getStatusPaymentFilters();
      foreach($statuses as $status){
        $thestatus = new stdClass();
        $thestatus->id = $status->id;
        $thestatus->name = JText::_($status->name); ?>
        <?php echo $status->id ?>: <?php echo json_encode($thestatus) ?>,
      <?php } ?>
    },
    cs_charts: {
      <?php foreach($this->cs_modules as $cs_module){ ?>
        cs_chart_<?php echo $cs_module->id; ?>: cs_chart_<?php echo $cs_module->id; ?>,
      <?php } ?>
    }
  };

  /* PAYMENT COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'payment.js'); ?>

  /* PAYMENT FORM COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'paymentform.js'); ?>

  Vue.component('payment', payment_component);
  Vue.component('paymentform', paymentform_component);

  new Vue({
    el: '#im-app',
    data: vm,
    methods: {

      clearFilters: function(){
        clearingFilters = true;
        clearFilters();

        reset_list_fields();
        load_more_items();

      },

    },
    watch: {

      status_id: function (val) {

        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      cal_start: function (val) {
        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      cal_end: function (val) {
        if(!clearingFilters){
          reset_list_fields();
          load_more_items();
        }
      },
      keywords: function (val) {

        if(!clearingFilters){
          if (!this.isLoading) {
            //doKeywordSearch();
            if (val == pendingKeyword) pendingKeyword = null;
            reset_list_fields();
            load_more_items();
          } else {
            pendingKeyword = val;
          }
        }
      },
    },
    mounted: function(){

      vm.isLoading = true;
      load_more_items();
    }
  });

</script>
