<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view' );

class InvoicesViewInvoice extends JViewLegacy
{

	public $layout_type = "INVOICE" ;

	protected $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

	}

	function display($tpl = null)
	{
		//cridem el CSS
		$document	= JFactory::getDocument();

		//get the invoice
		$this->invoice			= $this->get('Data');
		$this->items			= $this->get('Items');
		$this->taxes			= $this->get('Taxes');
		$this->templates		= $this->get('TemplatesData');
		$this->status			= $this->get('Status');
		$this->payments			= $this->get('Payments');

		$this->params = JComponentHelper::getParams( 'com_invoices' );

		$isNew		= ($this->invoice->id < 1);

		$text = $isNew ? JText::_( 'NEW' ) : JText::_( 'EDIT' );
		$title = $isNew ? JText::_( 'INVOICE' ) : $this->invoice->to_name;

		JToolbarHelper::title(   $title . ': <small><small>[ ' . $text.' ]</small></small>','invoices' );

		JToolbarHelper::apply();
		JToolbarHelper::save();

		if ($isNew)  {
			JToolbarHelper::cancel();
		} else {

			JToolbarHelper::cancel( 'cancel', JText::_('CLOSE') );

		}

		if($this->input->getVar('layout') != "form"){
			$this->taxes			= $this->get('TaxesInvoice');
			$this->payments			= $this->get('PaymentsInvoice');
			$this->payments2			= $this->get('PaymentsInvoice2');
		}

		$this->template			= $this->get('Template');

		// JS
		$document->addScript('components/com_invoices/assets/js/items.js');
		$document->addScript('components/com_invoices/assets/js/users.js');
		//http://isocra.com/2008/02/table-drag-and-drop-jquery-plugin/
		$document->addScript('components/com_invoices/assets/jquery.tablednd.js');

		$document->addScriptDeclaration('var currency_before = "'.$this->invoice->currency_before.'"; var currency_after = "'.$this->invoice->currency_after.'"; var numtaxes = '.count($taxes).';');

		$document->addScriptDeclaration('var yesword = "'.JText::_('JYES').'"; var noword = "'.JText::_('JNO').'"; ');

		$document->addScriptDeclaration('var default_tax = '.str_replace(",",".",$params->get('tax',0)).'; ');

		$document->addScriptDeclaration('var number_decimals = '.$params->get('decimals_editing',2).'; ');

		parent::display($tpl);
	}

}
