<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');
$params = JComponentHelper::getParams( 'com_invoices' );
?>

<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'invoices'.DS.'tmpl'.DS.'default_menu.php'); ?>

<div id="im-app" class="wrap push shrink invoice-manager">

  <form action="index.php" method="post" name="adminForm" id="adminForm">

    <?php echo $this->loadTemplate('filter'); ?>

    <table class="table table-hover">
      <thead>
        <tr>

          <th class="hidden-xs" width="20"> <input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" /></th>
          <th width="5"><?php echo InvoicesHelper::build_order_header('ID', 'co.id', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th><?php echo InvoicesHelper::build_order_header('NAME', 'co.name', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('COMPANY', 'co.company', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('LOCATION', 'co.country', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo InvoicesHelper::build_order_header('LINKED_TO_USER', 'u.username', $this->lists['order'], $this->lists['order_Dir']); ?></th>
          <th class="hidden-xs"><?php echo JText::_('TOTAL_INVOICES'); ?></th>
          <th></th>
          <th class="hidden-xs"></th>
        </tr>
      </thead>

      <tbody id="contacts-body">

        <tr
          v-for="contact in contacts"
          is="contact"
          :contact="contact"
          :id="'row' + contact.id"
          :class="{'item-row': true, 'active': current_contact.id == contact.id}"
        >
        </tr>

      </tbody>

    </table>

    <div id="loadmoreajaxloader_invoices" class="text-muted clear_row text-center">
      <div class="mdl-spinner mdl-spinner--single-color mdl-js-spinner is-active"></div>
    </div>

    <div class="no-more-entries text-muted clear_row text-center hide"><?php echo JText::_('NO_MORE_ENTRIES'); ?></div>

    <div id="end_container_contacts" class="clear_row"></div>

    <input type="hidden" name="option" value="com_invoices" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="controller" value="contact" />
    <input type="hidden" name="filter_order" id="filter_order" value="<?php echo $this->lists['order']; ?>" />
    <input type="hidden" name="filter_order_Dir" id="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>" />
  </form>

  <?php echo $this->loadTemplate('detailsmodal'); ?>

</div>

<div align="center" class="footer-sticky hidden-xs"><?php echo InvoicesHelper::showInvoicesFooter(); ?></div>

<template id="contact-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'contact.php'); ?>
</template>

<template id="contactdetails-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'contact'.DS.'details.php'); ?>
</template>

<template id="contactform-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'contact'.DS.'form.php'); ?>
</template>

<template id="invoice-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'invoice.php'); ?>
</template>

<template id="payment-vue-template" >
<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'payment.php'); ?>
</template>

<template id="preview-vue-template" >
  <div>
  <?php foreach ($this->templates as $template) {
    $search = array("{company_logo}");
    $replace = array(JURI::root().'media'.DS.'com_invoices'.DS.$template->company_logo);
    echo "<div v-if='invoice.template_id == ".$template->id."'>".str_replace($search, $replace, InvoicesHelper::templateToVue($template->content))."</div>";
  } ?>
  </div>
</template>

<!-- <template id="invoiceform-vue-template" >
<?php //include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'invoice'.DS.'form.php'); ?>
</template> -->

<script type="text/javascript">

var isloading;
var pagination_step = 20<?php //echo $this->limit; ?>;
var start = 0;
var split_view = <?php echo $params->get('list_view', 1); ?>;
var more_items = true;

//Filter fields
var filterFields = {
  keywords: "",
  user_id: "",
  filter_order: "",
  filter_order_Dir: ""
};
var pendingKeyword = null;

var component = "<?php echo $this->input->getVar('option'); ?>";
var appId = "<?php echo $this->input->getVar('appId'); ?>";

var item_to_highlight = 0 ;

//http://www.sitepoint.com/jquery-infinite-scrolling-demos/
jQuery( document ).ready(function() {
  isloading = true;

  filterFields.keywords = jQuery('#keywords').val();

  filterFields.filter_order = jQuery('#filter_order').val();
  filterFields.filter_order_Dir = jQuery('#filter_order_Dir').val();

  load_more_items();

  jQuery(window).scroll(function()
  {

    if(jQuery(window).scrollTop() >= jQuery('#end_container_contacts').offset().top + jQuery('#end_container_contacts').height() - jQuery(window).height())
    {
      if(!isloading && more_items){
        isloading = true;
        load_more_items();
      }
    }

  });

});
</script>

<script>

var taxes = {
  <?php foreach($this->taxes as $tax){ ?>
    <?php echo $tax->id ?>: {
      computed_value: 0
    },
  <?php } ?>
};

  var vm = {
    summary : {
      num_invoices: 0,
      total_invoices: [],
      total_income: [],
      pending_income: [],
      taxes: {
        <?php foreach($this->taxes as $tax){ ?>
          <?php echo $tax->id ?>: {
            computed_value: 0
          },
        <?php } ?>
      },
      update: 0
    },
    contacts: [],
    current_action: '',
    current_contact: new Contact({id:0}),
    current_invoice: new Invoice({id:0}),
    format: {
      before : "<?php echo $params->get('currency_before', ''); ?>",
      after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_before : "<?php echo $params->get('currency_before', ''); ?>",
      currency_after : "<?php echo $params->get('currency_after', ''); ?>",
      currency_id : "<?php echo $params->get('currency_id', '1'); ?>",
      noMoreEntriesText : "<?php echo JText::_('NO_MORE_ENTRIES'); ?>",
      decimals : "<?php echo $params->get('decimals', '2'); ?>",
      number_decimals : "<?php echo $params->get('decimals', '2'); ?>",
      decpoint : "<?php echo $params->get('decpoint', '.'); ?>",
      thousands : "<?php echo $params->get('thousands', ','); ?>",
      minus_format : "<?php echo $params->get('minus_format', 'minus'); ?>",
    },
    alltaxes: {
      <?php foreach($this->alltaxes as $tax){ ?>
        <?php echo $tax->id ?>: <?php echo json_encode($tax) ?>,
      <?php } ?>
    },
    keywords: "<?php echo $this->keywords ?>",
    filter_order: "<?php echo $this->lists['order'] ?>",
    filter_order_Dir: "<?php echo $this->lists['order_Dir'] ?>",
    currencies: {<?php foreach($this->currencies as $currency_id => $currency){ ?>
                  <?php if($currency->id) { echo $currency->id; ?>: <?php echo json_encode($currency); ?>,<?php } ?>
                <?php } ?>},
    currency_id: "<?php echo $this->currency_id ? $this->currency_id : $params->get('currency_id', '1'); ?>",
    default_currency_id: "<?php echo $params->get('currency_id', '1'); ?>",
    defaults:{
      tax_id: <?php echo $params->get('tax_id', 0); ?>,
      tax: "<?php echo $params->get('tax', ""); ?>",
      currency_id: "<?php echo $params->get('currency_id', '1'); ?>",
    },
    statuses: {
      <?php
      $statuses = InvoicesHelper::getStatus();
      foreach($statuses as $status){
        $thestatus = new stdClass();
        $thestatus->id = $status;
        $thestatus->name = JText::_($status); ?>
        <?php echo $status ?>: <?php echo json_encode($thestatus) ?>,
      <?php } ?>
    },
  };

  /* CONTACT COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'contact.js'); ?>

  /* DETAILS/FORM COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'contactdetails.js'); ?>

  /* CONTACT FORM COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'contactform.js'); ?>

  /* INVOICE COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoice.js'); ?>

  /* INVOICE PREVIEW COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoicepreview.js'); ?>

  /* INVOICE FORM COMPONENT */

  <?php //include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'invoiceform.js'); ?>

  /* PAYMENT COMPONENT */

  <?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'assets'.DS.'js'.DS.'components'.DS.'payment.js'); ?>

  Vue.component('contact', contact_component);
  Vue.component('contactdetails', contactdetails_component);
  Vue.component('contactform', contactform_component);
  Vue.component('invoice', invoice_component);
  Vue.component('invoicepreview', invoicepreview_component);
  //Vue.component('invoiceform', invoiceform_component);
  Vue.component('payment', payment_component);

  new Vue({
    el: '#im-app',
    data: vm,
    methods: {
      display_tax: function(tax_id){
        return display_tax(tax_id);
      },
      isSplitView: function(){
        if(is_mobile() || !split_view) return false;
        else return true;
      },
      saveContact: function () {
        save_contact()
      },

      preview_next: function(){
        indexes = jQuery.map(this.contacts, function(obj, index) {
          if(obj.id == vm.current_contact.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.contacts[index - 1] !== "undefined") this.contacts[index - 1].preview();
      },
      preview_prev: function(){
        indexes = jQuery.map(this.contacts, function(obj, index) {
          if(obj.id == vm.current_contact.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.contacts[index + 1] !== "undefined") this.contacts[index + 1].preview();
      },
      exists_next: function(){
        indexes = jQuery.map(this.contacts, function(obj, index) {
          if(obj.id == vm.current_contact.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.contacts[index - 1] !== "undefined") return true;
        return false
      },
      exists_prev: function(){
        indexes = jQuery.map(this.contacts, function(obj, index) {
          if(obj.id == vm.current_contact.id) {
              return index;
          }
        })

        index = indexes[0]
        if (typeof this.contacts[index + 1] !== "undefined") return true;
        return false
      }

    },
    watch: {

      current_contact: function (contact) {
        //when the current_contact changes, we make sure to load any missing stuff (invoices, quotes)
        contact.getUnloadedStuff();

      }
    }
  });

</script>
