<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>

<form action="index.php"
      method="post"
      name="adminForm_modal"
      id="adminForm_modal"
      enctype="multipart/form-data"
      class="form-horizontal">

  <div class="form-group form-group-lg">
    <label class="control-label col-md-3" for="name"> <?php echo JText::_( 'NAME' ); ?> </label>
    <div class="controls col-md-9">
      <input  class="form-control"
              type="text"
              name="name"
              id="name"
              maxlength="255"
              v-model="contact.name"
              />
    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="company"> <?php echo JText::_( 'COMPANY' ); ?> </label>
    <div class="controls col-md-9">
      <input  class="form-control"
              type="text"
              name="company"
              id="company"
              maxlength="255"
              v-model="contact.company" />
    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="address"> <?php echo JText::_( 'ADDRESS' ); ?> </label>
    <div class="controls col-md-9">
      <textarea class="form-control"
                name="address"
                id="address"
                cols="40"
                rows="4"
                v-model="contact.address">
      </textarea>
    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="email"> <?php echo JText::_( 'EMAIL' ); ?> </label>
    <div class="controls col-md-9">
      <input  class="form-control"
              type="email"
              name="email"
              id="email"
              maxlength="255"
              v-model="contact.email" />
    </div>
  </div>

  <div class="form-group">
    <label class="control-label col-md-3" for="city"> <?php echo JText::_( 'LOCATION_CITY' ); ?> </label>
    <div class="controls col-md-9">

      <div class="row">
        <div class="col-xs-6">
          <input  class="form-control "
                  type="text"
                  name="zipcode"
                  id="zipcode"
                  maxlength="255"
                  v-model="contact.zipcode"
                  placeholder="<?php echo JText::_( 'RECIPIENT_ZIPCODE_PLACEHOLDER' ); ?>" />
        </div>
        <div class="col-xs-6">
          <input  class="form-control "
                  type="text"
                  name="city"
                  id="city"
                  maxlength="250"
                  v-model="contact.city"
                  placeholder="<?php echo JText::_( 'RECIPIENT_CITY_PLACEHOLDER' ); ?>" />
        </div>
      </div>

    </div>
  </div>
  <div class="form-group">
    <label class="control-label col-md-3" for="country"> <?php echo JText::_( 'LOCATION_COUNTRY' ); ?> </label>
    <div class="controls col-md-9">
     <div class="row">
      <div class="col-xs-6">
        <input  class="form-control "
                type="text"
                name="state"
                id="state"
                maxlength="250"
                v-model="contact.state"
                placeholder="<?php echo JText::_( 'RECIPIENT_STATE_PLACEHOLDER' ); ?>" />
      </div>
      <div class="col-xs-6">
        <input  class="form-control "
                type="text"
                name="country"
                id="country"
                maxlength="250"
                v-model="contact.country"
                placeholder="<?php echo JText::_( 'RECIPIENT_COUNTRY_PLACEHOLDER' ); ?>" />
      </div>
    </div>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="vatid"> <?php echo JText::_( 'VATID' ); ?> </label>
  <div class="controls col-md-9">
    <input  class="form-control"
            type="text"
            name="vatid"
            id="vatid"
            maxlength="250"
            v-model="contact.vatid" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="phone"> <?php echo JText::_( 'PHONE' ); ?> </label>
  <div class="controls col-md-9">
    <input  class="form-control"
            type="text"
            name="phone"
            id="phone"
            maxlength="250"
            v-model="contact.phone" />
  </div>
</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-3" > <?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?> </label>
  <div class="controls col-md-9">

    <div class="btn-group" id="sign_group" data-toggle="buttons">

      <label  class="btn btn-default"
              :class="{'active': contact.vincular_cliente}"
              for="vincular_cliente_checkbox"
              id="label_user"
              @click="toggleContactOptions(1)"><?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?>

        <input  class="radio_toggle"
                type="radio"
                value="1"
                name="vincular_cliente_checkbox"
                id="vincular_cliente_checkbox"
                v-model="contact.vincular_cliente" />
      </label>
      <label  class="btn btn-default"
              :class="{'active': !contact.vincular_cliente}"
              for="vincular_cliente_checkbox4"
              @click="toggleContactOptions(0)"><?php echo JText::_( 'DO_NOT_LINK_TO_JOOMLA_USER' ); ?>
        <input  class="radio_toggle"
                type="radio"
                value="0"
                name="vincular_cliente_checkbox"
                id="vincular_cliente_checkbox4"
                v-model="contact.vincular_cliente" />
      </label>

      </div>

    </div>
  </div>

  <div class="form-group">
    <label class="control-label col-md-3" > </label>

    <div class="controls col-md-9">
      <div class="row">

        <div class="col-md-4">

          <input  type="text"
                  class="form-control disabled"
                  readonly
                  id="vincular_cliente"
                  size="40"
                  v-model="username_id"
                  placeholder="<?php echo JText::_( 'JOOMLA_USERNAME_PLACEHOLDER' ); ?>" />
          <input  class="inputbox input-mini small-margin-top"
                  type="hidden"
                  name="user_id"
                  id="user_id"
                  size="4"
                  maxlength="11"
                  v-model="contact.user_id" />

        </div>

        <div class="col-md-8">

          <div class="controls">
            <input  class="form-control"
                    type="text"
                    name="search_user"
                    id="search_user"
                    value=""
                    size="30"
                    placeholder="<?php echo JText::_('TYPE_TO_SEARCH_USER'); ?>" />
          </div>

        </div>
      </div>
    </div>

  </div>

  <input type="hidden" name="option" value="com_invoices" />
  <input type="hidden" name="id" v-model="contact.id" />
  <input type="hidden" name="task" value="save" />
  <input type="hidden" name="controller" value="contact" />
  <input type="hidden" name="ajax" id="ajaxfield" value="1" />

</form>
