<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Activities;

use JHtmlSidebar;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\Utils\Html as HtmlUtisl;
use OSL\View\HtmlView;

// no direct access
defined('_JEXEC') or die;

/***
 * @property \OSSolution\HelpdeskPro\Admin\Model\Activities $model
 */
class Html extends HtmlView
{
	protected $lists = [];

	protected function beforeRender()
	{
		$state = $this->model->getState();
		$users = $this->model->getUsers();

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('Select User'), 'id', 'username');
		$options   = array_merge($options, $users);

		$this->lists['filter_user_id']    = HTMLHelper::_('select.genericlist', $options, 'filter_user_id', 'onchange="submit();" class="form-select"', 'id', 'username', $state->filter_user_id);
		$this->lists['filter_start_hour'] = HTMLHelper::_('select.integerlist', 0, 23, 1, 'filter_start_hour', ' class="input-mini" ', $state->filter_start_hour);
		$this->lists['filter_end_hour']   = HTMLHelper::_('select.integerlist', 0, 23, 1, 'filter_end_hour', ' class="input-mini" ', $state->filter_end_hour);
		$this->data                       = $this->model->getData();

		$userMap = [];

		foreach ($users as $user)
		{
			$userMap[$user->id] = $user->username;
		}

		if (!\HelpdeskproHelper::isJoomla4())
		{
			// Add sidebar
			HtmlUtisl::addSubMenus($this->container->option, $this->name);

			$this->sidebar = JHtmlSidebar::render();
		}
		else
		{
			$this->sidebar = '';
		}

		$this->state   = $state;
		$this->userMap = $userMap;
	}
}