<?php
/**
* @package        Komento
* @copyright      Copyright (C) 2010 - 2017 Stack Ideas Sdn Bhd. All rights reserved.
* @copyright      Copyright (C) 2017 Jon Brown @ QuantumWarp.com
* @license        GNU/GPL, see LICENSE.php
* Komento is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
 
// No direct access
defined('_JEXEC') or die('Restricted access');
 
// Always load abstract class - This file also includes extra information about the functions here and the advanced functions not covered
//require_once(JPATH_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_komento' . DIRECTORY_SEPARATOR . 'komento_plugins' . DIRECTORY_SEPARATOR .'abstract.php'); 
require_once(JPATH_ROOT . '/components/com_komento/komento_plugins/abstract.php');
 
class KomentoCommoojlaCourse extends KomentoExtension
{
    /******************************************************
     *
     * START
     * [BASIC FUNCTIONS (METHODS)]
     * These functions are mandatory
     *
     ******************************************************/ 
        
    // This property (object) stores all the required properties by Komento
    public $_item;
    // This property (array) stores all the key mappings of the required item properties to map from Komento's default key to your component's custom key
    public $_map = array(
        // not needed with custom getContentId()
        'id' => 'remoteid',
        // not needed with custom getContentTitle()
        'title' => 'shortname',
        // not needed with custom getContentHits()
        'hits' => 'hits',
        // not needed with custom getAuthorId()
        'created_by' => 'created_by',
        // not needed with custom getCategoryId()
        'catid' => 'cat_id',
        // not needed with custom getContentPermalink()
        'permalink' => 'permalink_field'
         );
    // Constructor - Add all required files for your component here and run its constructor
    public function __construct($component)
    {
        // dump($component, "component");
        // Load all required files by component
        // $this->addFile(your component's files);
         // $this->addFile(JPATH_ADMINISTRATOR . '/components/com_moojla/config.php');
        // This must be left at the end of this constructor function
        parent::__construct($component);
    }
    // This method should load the article's main properties based on article ID
    public function load($cid)
    {
        // dump($cid, "cid");
        static $instances = array();
        if (!isset($instances[$cid])) {
            // populate $this->_item with:
            // id_field
            // title_field
            // hits_field
            // created_by_field
            // catid_field
            // permalink_field
            // Create a Database Object
            $db = KT::getDBO();
             
            // Create SQL query to load a single article
            $query = 'SELECT `remoteid` as id, `shortname`, `hits`, `created_by`, `cat_id` FROM `#__moojla_course` WHERE `remoteid` = ' . $db->quote($cid);
            $db->setQuery($query);
            // Run the single article query and if there are no objects to load call the onLoadArticleError event
            if (!$this->_item = $db->loadObject()) {
                return $this->onLoadArticleError($cid);
            }
            // Generate the permalink for this article
            $this->_item->permalink_field = 'index.php?option=com_moojla&view=coursedetail&id=' . $this->_item->id;
            // Call the prepareLink function and leave the rest to us
            // Unless you have custom SEF methods, then use "getContentPermalink" function to overwrite
            $this->_item->permalink_field = $this->prepareLink($this->_item->permalink_field);
            $instances[$cid] = $this->_item;
        }
        $this->_item = $instances[$cid];
        // dump($this, "this");
        return $this;
    }
     
    // This method should load all the article IDs filtered by category IDs
    public function getContentIds($categories = '')
    {
        // dump($categories, "categories getContentIds");
        // Create a Database Object
        $db = KT::getDBO();
         
        // Make sure the query is empty
        $query = '';
         
        // If no categories are supplied then load all article IDs
        if (empty($categories)) {
            $query = 'SELECT `id` FROM `#__moojla_course` ORDER BY `id`';
        }
         
        // If categories are supplied then load all article IDs for articles belonging to those categories
        else
        {
            if (is_array($categories)) {
                $categories = implode(',', $categories);
            }
            $query = 'SELECT `id` FROM `#__moojla_course` WHERE `cat_id` IN (' . $categories . ') ORDER BY `id`';
        }
         
        // Run the query and return the results as an array
        $db->setQuery($query);
        $res = $db->loadResultArray();
        // dump($res, "res");
        return $res;
    }
    // This method should load all the category IDs of the component
    // Make sure you select 'Single Level' or 'Nested' categories
    public function getCategories()
    {
        // dumpmessage("getCategories");
        // Create a Database Object
        $db = KT::getDBO();
         
        // Single Level Categories
        $query = 'SELECT `cat_id`, `cat_name` FROM `#__moojla_course`';
         
        // Nested Categories
        // $query = 'SELECT `id`, `title`, `level`, `parent_id` FROM `#__CATEGORY_TABLE`';
         
        // Run query and return categories
        $db->setQuery($query);
        $categories = $db->loadObjectList();
        // Populate category tree for Komento Admin Integration Tab for this plugin (optional)
        // This is used in Komento where you select which categories the plugin should be active on etc...
        /*
        foreach ($categories as &$row) {
            // Single Level Categories
            //$row->level = 0;
             
            // Nested Categories
            $repeat = ($row->level - 1 >= 0) ? $row->level - 1 : 0;           
             
            // Build and Add the Category Tree entry
            $row->treename = str_repeat('.&#160;&#160;&#160;', $repeat) . ($row->level - 1 > 0 ? '|_&#160;' : '') . $row->title;
        }
        */
        return $categories;
    }
    // This method lets Komento know if this is the front page or category layout (Determine if is listing view)
    public function isListingView()
    {
      // dumpmessage("isListingView");
        $views = array('featured', 'category', 'categories', 'archive', 'frontpage');
        return in_array(JRequest::getCmd('view'), $views);
    }
    // This method lets Komento know if this is the page that the comment form should be displayed on (Determine if is entry view)
    public function isEntryView()
    {
      // dumpmessage("isEntryView");
        return JRequest::getCmd('view') == 'coursedetail';
    }
    // This method is the main method that appends Komento on the article
    public function onExecute(&$course, $html, $view, $options = array())
    {
        // dump($course, "course");
        // dump($html, "html");
        // dump($view, "view");
        // $html is the html content generated by komento (includes listing and form)
         
        // Select 1 of the following outputs
        // This appends the HTML to the article object
        $course->text .= $html;
        //return;
        // Return the Komento HTML code
        return $html;
    }
     
    /******************************************************
     *
     * END
     * [BASIC FUNCTIONS (METHODS)]
     *
     ******************************************************/
        
}
?>