<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    30th April, 2015
 * @author     Llewellyn van der Merwe <https://dev.vdm.io>
 * @git        Joomla Component Builder <https://git.vdm.dev/joomla/Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JLoader::register('ComponentbuilderHelper', JPATH_ADMINISTRATOR . '/components/com_componentbuilder/helpers/componentbuilder.php'); 

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use VDM\Joomla\Componentbuilder\Compiler\Factory as CFactory;
use VDM\Joomla\Componentbuilder\Compiler\Utilities\Indent;
use VDM\Joomla\Componentbuilder\Compiler\Utilities\Line;
use VDM\Joomla\Utilities\ArrayHelper;

/**
 * Extension - Componentbuilder Export Compiler plugin.
 *
 * @package   ComponentbuilderExportCompiler
 * @since     1.2.1
 */
class PlgExtensionComponentbuilderExportCompiler extends CMSPlugin
{
	/**
	 * Application object
	 *
	 * @var    CMSApplication
	 * @since  1.0.0
	 */
	protected  $app;

	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 * @since  1.0.0
	 */
	protected  $autoloadLanguage = true;

	/**
	 * The language string builder
	 * 
	 * @var     array
	 */
	protected $languageArray = [];

	/*
	 * The Export Text Only switch
	 * 
	 * @var      int
	 */
	protected $exportTextOnly = 0;

	/*
	 * The Strict Field Export Permissions switch
	 * 
	 * @var      bool
	 */
	protected $strictFieldExportPermissions = false;

	/**
	 * Event Triggered in the compiler [on Before Get Component Data]
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function jcb_ce_onAfterGetComponentData()
	{
		if ($this->exportTextOnly && $this->componentActive())
		{
			// activate export text only
			CFactory::_('Config')->set('export_text_only', (int) $this->exportTextOnly);

			// activate strict_permission_per_field if set in plugin (default true)
			CFactory::_('Config')->set('permission_strict_per_field', (bool) $this->strictFieldExportPermissions);
		}
	}

	/**
	 * Event Triggered in the compiler [on After Model Component Data]
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function jcb_ce_onAfterModelComponentData(&$component)
	{
		// check if we have export for any view
		if ($this->componentActive())
		{
			// set the export/import option
			if (isset($component->admin_views) && ArrayHelper::check($component->admin_views))
			{
				foreach ($component->admin_views as $view)
				{
					if (!$this->exportTextOnly && (isset($view['port']) && $view['port'] || 1 == $view['settings']->add_custom_import))
					{
						$this->exportTextOnly = 1;
						$this->strictFieldExportPermissions = (bool) $this->params->get('strict_permission_per_field', 1);
					}
				}
			}
		}
	}

	/**
	 * Event Triggered in the compiler [on Before Set Lang File Data]
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function jcb_ce_onBeforeSetLangFileData()
	{
		if ($this->exportTextOnly && $this->componentActive() && ArrayHelper::check($this->languageArray))
		{
			foreach($this->languageArray as $key => $string)
			{
				CFactory::_('Language')->set('adminsys', $key, $string);
			}
		}
	}

	/**
	 * Event Triggered in the compiler [on Before Set Config Field sets]
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function jcb_ce_onBeforeSetConfigFieldsets(&$timer)
	{
		// only add fields after second time
		if ($this->exportTextOnly && $this->componentActive() && $timer == 2)
		{
			// main lang prefix
			$lang = CFactory::_('Config')->lang_prefix . '_CONFIG';
			// start building field set for config
			$configFieldSets[] = Indent::_(1) . "<fieldset";
			$configFieldSets[] = Indent::_(2) . 'name="export_text_only_config"';
			$configFieldSets[] = Indent::_(2) . 'label="' . $lang . '_EXPORT_TEXT_ONLY_TAB_LABEL"';
			$configFieldSets[] = Indent::_(2) . 'description="' . $lang . '_EXPORT_TEXT_ONLY_TAB_DESCRIPTION">';
			// setup lang
			$this->languageArray[$lang . '_EXPORT_TEXT_ONLY_TAB_LABEL'] = "Export Options";
			$this->languageArray[$lang . '_EXPORT_TEXT_ONLY_TAB_DESCRIPTION'] = "Here are some extra option to adjust the export behavior of admin views.";
			// add custom Export Options
			if (isset($configFieldSetsCustomField['Export Options']) && ArrayHelper::check($configFieldSetsCustomField['Export Options']))
			{
				$configFieldSets[] = implode("", $configFieldSetsCustomField['Export Options']);
				unset($configFieldSetsCustomField['Export Options']);
			}
			else
			{
				$this->languageArray[$lang . '_EXPORT_TEXT_ONLY_LABEL'] = "Export Text Only";
				$this->languageArray[$lang . '_EXPORT_TEXT_ONLY_DESCRIPTION'] = "This option enables the export of string/text instead of linked IDs in all admin views that have an export option.";

				$this->languageArray[$lang . '_ACTIVATE'] = "Activate";
				$this->languageArray[$lang . '_DEACTIVATE'] = "Deactivate";

				$configFieldSets[] = PHP_EOL . Indent::_(2) . "<!--" . Line::_(__Line__, __Class__) . " Export Text Only Field. Type: Radio. (joomla) -->";
				$configFieldSets[] = Indent::_(2) . "<field";
				$configFieldSets[] = Indent::_(3) . "type=\"radio\"";
				$configFieldSets[] = Indent::_(3) . "name=\"export_text_only\"";
				$configFieldSets[] = Indent::_(3) . "label=\"" . $lang . "_EXPORT_TEXT_ONLY_LABEL\"";
				$configFieldSets[] = Indent::_(3) . "description=\"" . $lang . "_EXPORT_TEXT_ONLY_DESCRIPTION\"";
				$configFieldSets[] = Indent::_(3) . "class=\"btn-group btn-group-yesno\"";
				$configFieldSets[] = Indent::_(3) . "default=\"0\">";
				$configFieldSets[] = Indent::_(3) . "<!--" . Line::_(__Line__, __Class__) . " Option Set. -->";
				$configFieldSets[] = Indent::_(3) . "<option value=\"1\">";
				$configFieldSets[] = Indent::_(4) . $lang . "_ACTIVATE</option>";
				$configFieldSets[] = Indent::_(3) . "<option value=\"0\">";
				$configFieldSets[] = Indent::_(4) . $lang . "_DEACTIVATE</option>";
				$configFieldSets[] = Indent::_(2) . "</field>";

				// add  strict Field Export Permissions field
				if ($this->strictFieldExportPermissions)
				{
					$this->languageArray[$lang . '_STRICT_PERMISSION_PER_FIELD_LABEL'] = "Use Strict Permission per/field";
					$this->languageArray[$lang . '_STRICT_PERMISSION_PER_FIELD_DESCRIPTION'] = "Use strict permissions per/field in the export methods where there are fields permissions in a view.";

					$configFieldSets[] = PHP_EOL . Indent::_(2) . "<!--" . Line::_(__Line__, __Class__) . " Strict_permission_per_field Field. Type: Radio. (joomla) -->";
					$configFieldSets[] = Indent::_(2) . "<field";
					$configFieldSets[] = Indent::_(3) . "type=\"radio\"";
					$configFieldSets[] = Indent::_(3) . "name=\"strict_permission_per_field\"";
					$configFieldSets[] = Indent::_(3) . "label=\"" . $lang . "_STRICT_PERMISSION_PER_FIELD_LABEL\"";
					$configFieldSets[] = Indent::_(3) . "description=\"" . $lang . "_STRICT_PERMISSION_PER_FIELD_DESCRIPTION\"";
					$configFieldSets[] = Indent::_(3) . "class=\"btn-group btn-group-yesno\"";
					$configFieldSets[] = Indent::_(3) . "default=\"1\">";
					$configFieldSets[] = Indent::_(3) . "<!--" . Line::_(__Line__, __Class__) . " Option Set. -->";
					$configFieldSets[] = Indent::_(3) . "<option value=\"1\">";
					$configFieldSets[] = Indent::_(4) . $lang . "_ACTIVATE</option>";
					$configFieldSets[] = Indent::_(3) . "<option value=\"0\">";
					$configFieldSets[] = Indent::_(4) . $lang . "_DEACTIVATE</option>";
					$configFieldSets[] = Indent::_(2) . "</field>";
				}
			}
			// close that fieldset
			$configFieldSets[] = Indent::_(1) . "</fieldset>";
		}
	}


	/**
	 * The array of active components
	 * 
	 * @var     array
	 */
	protected $componentsActive;

	/**
	 * The activate option
	 * 
	 * @var     int
	 */
	protected $activateOption = 0;

	/**
	 * Set the line number in comments
	 * 
	 * @return  bool
	 * 
	 */
	protected function componentActive()
	{
		// check the active option
		if (!$this->activateOption)
		{
			$this->activateOption = $this->params->get('activate_option', 1);
		}
		// active for all components
		if ($this->activateOption == 1)
		{
			return true;
		}
		// first check is we have the active components set
		if ($this->activateOption == 2 && !ArrayHelper::check($this->componentsActive))
		{
			$this->componentsActive = $this->params->get('components');
		}
		// only check if there are active
		if (ArrayHelper::check($this->componentsActive))
		{
			return in_array((int) CFactory::_('Config')->component_id, $this->componentsActive);
		}
		return false;
	}

}
