<?php

namespace Nextend\SmartSlider3Pro\Generator\Joomla\Redshop\Elements;

use JHTML;
use Nextend\Framework\Database\Database;
use Nextend\Framework\Form\Element\Select;


class RedshopCategories extends Select {

    public function __construct($insertAt, $name = '', $label = '', $default = '', $parameters = array()) {
        parent::__construct($insertAt, $name, $label, $default, $parameters);

        $query = 'SELECT
                m.id AS id, 
                m.name AS name, 
                m.name AS title,
                m.parent_id as parent_id
            FROM #__redshop_category m
            WHERE m.published = 1                
            ORDER BY m.id';

        $menuItems = Database::queryAll($query, false, "object");
        $children  = array();
        if ($menuItems) {
            foreach ($menuItems as $v) {
                $pt   = $v->parent_id;
                $list = isset($children[$pt]) ? $children[$pt] : array();
                array_push($list, $v);
                $children[$pt] = $list;
            }
        }
        jimport('joomla.html.html.menu');
        $options = JHTML::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0);

        $this->options['0'] = n2_('All');

        if (count($options)) {
            foreach ($options AS $option) {
                $this->options[$option->id] = $option->treename;
            }
        }
    }

}
