<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.36
	@build			28th March, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		hikashopplans.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.5.$$$$]***/
jimport( 'joomla.plugin.plugin' );/***[/JCBGUI$$$$]***/


class PlgReservationHikashopplans extends JEvent
{

/***[JCBGUI.joomla_plugin.main_class_code.66.$$$$]***/
    public function onReservationPlanCreated($data)
    {
        $filename = __DIR__ . '/testlog.txt';
        // file_put_contents($filename, 'data = ' . print_r($data, true) . "\n" , FILE_APPEND);
        
        require_once( JPATH_ADMINISTRATOR.'/components/com_hikashop/helpers/helper.php' );
        $config = hikashop_config();
        $allowed = $config->get('allowedfiles');
        $imageHelper = hikashop_get('helper.image');
        
        $file_class = hikashop_get('class.file');
        $uploadPath = $file_class->getPath('product','');
        $category = 2;
        
        $product_code = "reserve".$data['id'];

        // SELECT rc.id, rc.userid, u.name, c.title FROM `#__reservation_consultant` AS rc INNER JOIN `#__users` AS u ON u.id = rc.userid INNER JOIN `#__categories` AS c ON c.id = rc.catid WHERE rc.id = consultantid
        
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query
            ->select(array('rc.id', 'rc.userid', 'u.name', 'c.title'))
            ->from($db->quoteName('#__reservation_consultant', 'rc'))
            ->join('INNER', $db->quoteName('#__users', 'u') . ' ON ' . $db->quoteName('rc.userid') . ' = ' . $db->quoteName('u.id'))
            ->join('INNER', $db->quoteName('#__categories', 'c') . ' ON ' . $db->quoteName('c.id') . ' = ' . $db->quoteName('rc.catid'))
            ->where($db->quoteName('rc.id') . ' = ' . $db->quote($data['consultantid']));;
        $db->setQuery($query);
        $results = $db->loadObjectList();

        switch($data['plantype'])
        {
            case 1:
                $consultanttype = JText::_('COM_RESERVATION_PLAN_TEL');
                break;
            case 2:
                $consultanttype = JText::_('COM_RESERVATION_PLAN_CHAT');
                break;
            
            
            default:
                $consultanttype = $data['plantype'];
        }

        $consultantname = $results[0]->name;
        $consultantcat  = $results[0]->title;
        $name = "مشاوره $consultanttype دکتر $consultantname ($consultantcat)";

        $cost = $data["price"];
        $desc = "";
        
        
        
        $product_class = hikashop_get('class.product');
        $element = new JObject ();
        $element->categories = array ($category);
        $element->related = array();
        $element->options = array();
        $element->product_name = $name;
        $element->product_description = $desc;
        $element->product_code = $product_code;
        $element->product_published = $data['published'];

        // $db = JFactory::getDbo();
        // $query = $db->getQuery(true);
        // $query->select($db->quoteName(array('category_id')));
        // $query->from($db->quoteName('#__hikashop_category'));
        // $query->where($db->quoteName('category_namekey') . ' = ' . $db->quote('default_tax'));

        // $db->setQuery($query);
        // $tax_id = $db->loadResult();

        // if ($tax_id)
        // {
          // $element->product_tax_id = $tax_id;

          // $db = JFactory::getDbo();
          // $query = $db->getQuery(true);
          // $query->select($db->quoteName(array('tax_namekey')));
          // $query->from($db->quoteName('#__hikashop_taxation'));
          // $query->where($db->quoteName('category_namekey') . ' = ' . $db->quote('default_tax'));
          // $db->setQuery($query);
          // $tax_namekey = $db->loadResult();

          // $db = JFactory::getDbo();
          // $query = $db->getQuery(true);
          // $query->select($db->quoteName(array('tax_rate')));
          // $query->from($db->quoteName('#__hikashop_tax'));
          // $query->where($db->quoteName('tax_namekey') . ' = ' . $db->quote($tax_namekey));
          // $db->setQuery($query);
          // $tax_rate = $db->loadResult();

          // $div = $tax_rate + 1;
          // /*$price_without_tax = $cost / $div;*/
          // $price_without_tax = $cost;
          // $cost = $price_without_tax;
        // }

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(array('product_id')));
        $query->from($db->quoteName('#__hikashop_product'));
        $query->where($db->quoteName('product_code') . ' = ' . $db->quote($product_code));
        $db->setQuery($query);
        $products = $db->loadObjectList();

        if (count ($products))
        {
          $element->product_id = current($products)->product_id;
        }
        
        $element->prices[0] = new JObject ();
        $element->prices[0]->price_value = $cost;

        // $db = JFactory::getDbo();
        // $query = $db->getQuery(true);
        // $query->select($db->quoteName(array('currency_id')));
        // $query->from($db->quoteName('#__hikashop_currency'));
        // $query->where($db->quoteName('currency_code') . ' = ' . $db->quote($currency));
        // $db->setQuery($query);
        // $currency_id = $db->loadResult();
        // $element->prices[0]->price_currency_id = $currency_id;
        
        $element->product_type = "main";
        // $quantity = intval($enrol_json['customint3']);
        // if($quantity > 0)
          // $element->product_quantity = $quantity;
        // else
          // $element->product_quantity = -1;

        // if($enrol_json['enrolstartdate'])
          // $element->product_sale_start 	= $enrol_json['enrolstartdate'];
        // else
          // $element->product_sale_start = '';
        // if($enrol_json['enrolenddate'])
          // $element->product_sale_end 		= $enrol_json['enrolenddate'];
        // else
          // $element->product_sale_end  = '';

        // $element->product_min_per_order = 0;
        // $element->product_max_per_order = 1;

        $status = $product_class->save($element);
        
        if ($status)
        {
          $product_class->updateCategories($element, $status);
          $product_class->updatePrices($element, $status);
        }
        
        
        
    }
    public function onReservationPlanStateChanged($pks, $value)
    {
        $filename = __DIR__ . '/onReservationPlanStateChanged.txt';
        // file_put_contents($filename, 'pk = ' . print_r($pk, true) . "\n" , FILE_APPEND);
        // file_put_contents($filename, 'value = ' . print_r($value, true) . "\n" , FILE_APPEND);
        
        foreach($pks as $pk)
        {
            $product_code = "reserve".$pk;
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query->select($db->quoteName(array('product_id')));
            $query->from($db->quoteName('#__hikashop_product'));
            $query->where($db->quoteName('product_code') . ' = ' . $db->quote($product_code));
            $db->setQuery($query);
            $products = $db->loadObjectList();
            if(!empty($products))
            {
                $product = current($products);
                JLoader::register('ReservationModelPlan', JPATH_ADMINISTRATOR . '/components/com_reservation/models/plan.php');
                $plan_model = new ReservationModelPlan();
                $data = (array)$plan_model->getItem($pk);
                $this->onReservationPlanCreated($data);
            }
        }
    }/***[/JCBGUI$$$$]***/

}
