<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/lmsyaran/public_html/templates/g5_hydrogen/custom/particles/collapsible-section.yaml',
    'modified' => 1522074190,
    'data' => [
        'name' => 'Collapsible Section',
        'description' => 'Make a section collapsible.',
        'type' => 'atom',
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable Collapsible Section particles.',
                    'default' => true
                ],
                '_note' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-info',
                    'content' => 'Create the sections that you want to be collapsible.'
                ],
                'items' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'Sections',
                    'description' => 'Create each section that you want to be collapsible.',
                    'value' => 'name',
                    'ajax' => true,
                    'fields' => [
                        '.sectionid' => [
                            'type' => 'input.text',
                            'description' => 'Enter the ID of the section that you want to be collapsible, for example \'g-showcase\'.',
                            'label' => 'Section ID'
                        ],
                        '.toggletext' => [
                            'type' => 'input.text',
                            'description' => 'Enter the clickable text that will trigger the toggle.',
                            'label' => 'Toggle Text',
                            'default' => 'Click to expand'
                        ],
                        '.icon' => [
                            'type' => 'input.icon',
                            'label' => 'Icon',
                            'description' => 'Select an icon to be placed in front of the toggle text.'
                        ],
                        '.collapsed' => [
                            'type' => 'select.select',
                            'label' => 'Collapsed by default',
                            'description' => 'Select if the section should be collapsed by default.',
                            'placeholder' => 'Select...',
                            'default' => 'true',
                            'options' => [
                                'true' => 'Yes',
                                'false' => 'No'
                            ]
                        ],
                        '.class' => [
                            'type' => 'input.selectize',
                            'label' => 'CSS Class'
                        ],
                        '.extra' => [
                            'type' => 'collection.keyvalue',
                            'label' => 'Tag Attributes',
                            'description' => 'Extra Tag attributes.',
                            'key_placeholder' => 'Key (data-*, style, ...)',
                            'value_placeholder' => 'Value',
                            'exclude' => [
                                0 => 'id',
                                1 => 'class'
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ]
];
