<?php
/**
* @version 2.0.0
* @package RSTickets! Pro 2.0.0
* @copyright (C) 2010 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.keepalive');
JHtml::_('jquery.framework', true);
JFactory::getDocument()->addScript('https://www.gstatic.com/charts/loader.js');
JFactory::getDocument()->addScriptDeclaration('
    google.charts.load(\'current\', {\'packages\':[\'corechart\']});
    
    google.charts.setOnLoadCallback(RSTicketsReports.selectReport);
    
    RSTicketsReports.nrDepartments = '.$this->count_departments.';
    RSTicketsReports.nrStaff = '.$this->count_staff.';
    
    jQuery(document).ready(function(){
        RSTicketsReports.checkReport(jQuery(\'#report\').val());
    });
');
JHtml::_('script', 'plg_rsticketsproreports/reports.js', array('relative' => true, 'version' => 'auto'));
JHtml::_('stylesheet', 'plg_rsticketsproreports/reports.css', array('relative' => true, 'version' => 'auto'));
?>
<div id="rst_reports_container" class="<?php echo RsticketsproAdapterGrid::row(); ?>">
	<div class="<?php echo RsticketsproAdapterGrid::column(3); ?>">
		<form method="post" action="<?php echo JRoute::_('index.php?option=com_rsticketspro&view=reports'); ?>" id="adminForm" name="adminForm">
			<?php
			$this->plain->addTitle(JText::_('RST_SELECT_REPORT'), 'select_report');
			$this->plain->addContent($this->loadTemplate('select_report'));

			foreach ($this->options as $layout => $title)
			{
				// add the tab title
				$this->plain->addTitle($title, $layout);
			
				$content = $this->loadTemplate($layout);

				// add the tab content
				$this->plain->addContent($content);
			}
			// render tabs
			$this->plain->render();
			?>
		</form>
		
		<div style="text-align: center;">
			<p><button type="button" onclick="rst_refresh_report();" class="button btn btn-primary"><?php echo JText::_('RST_REPORTS_REFRESH_GRAPH'); ?></button></p>
		</div>
	</div>
	
	<div class="<?php echo RsticketsproAdapterGrid::column(9); ?>">
		<div>
			<?php echo JHtml::_('image', 'com_rsticketspro/loading.gif', JText::_('Loading'), array('id' => 'rst_loading'), true); ?>
		</div>
		<div id="rst_report">
			<?php echo $this->loadTemplate('no_report'); ?>
		</div>
		<div class="clearfix"></div>
	</div>
</div>