<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		appointment.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Appointment Form Field class for the Reservation component
 */
class JFormFieldAppointment extends JFormFieldList
{
	/**
	 * The appointment field type.
	 *
	 * @var		string
	 */
	public $type = 'appointment';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Get the databse object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.id','a.appointment','c.title','u.name'),array('id','appointmentid_appointment','title','name')));
		$query->from($db->quoteName('#__reservation_appointment', 'a'));
$query->join('inner',$db->quoteName('#__reservation_consultant','co') . ' on' .$db->quoteName('a.doctorid').'='.$db->quoteName('co.id'));
		$query->join('inner',$db->quoteName('#__users','u') . ' on' .$db->quoteName('u.id').'='.$db->quoteName('co.userid'));
		$query->join('inner',$db->quoteName('#__categories','c') . ' on' .$db->quoteName('c.id').'='.$db->quoteName('co.catid'));
		$query->where($db->quoteName('a.published') . ' = 1');
		$query->order('a.appointment ASC');
		// Implement View Level Access (if set in table)
		if (!$user->authorise('core.options', 'com_reservation'))
		{
			$columns = $db->getTableColumns('#__reservation_appointment');
			if(isset($columns['access']))
			{
				$groups = implode(',', $user->getAuthorisedViewLevels());
				$query->where('a.access IN (' . $groups . ')');
			}
		}
		$db->setQuery((string)$query);
		$items = $db->loadObjectList();
		$options = array();
		if ($items)
		{
			if ($this->multiple === false)
			{
				$options[] = JHtml::_('select.option', '', JText::_('COM_RESERVATION_SELECT_AN_OPTION'));
			}
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->id, $item->name.'('.$item->title.'-'.$item->appointmentid_appointment.')');
			}
		}
		return $options;
	}
}
