<?php
/**
 * @version			2.2.0
 * @author     		Nicholas G. Antimisiaris
 * @authoremail		nant@joomlapolis.com
 * @authorurl		www.joomlapolis.com
 * @package    		Joomla 2 CiviCRM User Sync
 * @file			joomla2civicrmusersyncbot.php
 * @copyright  		Copyright (C) 2013-2019. All rights reserved
 * @license    		GNU GPL version 2
 */


// No direct access
defined('_JEXEC') or die('No direct access');

jimport('joomla.plugin.plugin');


class  plguserjoomla2civicrmusersyncbot extends JPlugin
{

	/*
	 * Link Joomla User to (create first if needed) CiviCRM contact on Joomla new user save
	 *
	 * @param   array   $user       Holds the new user data.
	 * @param   boolean $isnew      True if a new user is stored.
	 * @param   boolean $success    True if user was successfully stored in the database.
	 * @param   string  $msg        Message in case of failed db storage.
	 *
	 * @return	void
	 */
	public function onUserAfterSave($user, $isnew, $success, $msg)
	{

		if (!$success || !$isnew) { // if this is not a successfully newly created joomla user action then no action
			return;
		}

		if (!file_exists(JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php')) {
			return;
		}

		jimport('joomla.user.helper');
		$app = JFactory::getApplication();

		switch ($app->scope) {

			case 'com_comprofiler': // case of Community Builder invoking user creation

				$j2c_input		= $app->input;
				$j2c_firstname	= $j2c_input->get('firstname', null, null);
				$j2c_lastname	= $j2c_input->get('lastname', null, null);
				$j2c_middlename	= $j2c_input->get('middlename', null, null);
				$j2c_email 		= strtolower(trim($j2c_input->get('email', null, null)));

				if ($j2c_firstname == null) { // CB single name setting is enabled and needs splitting

					$j2c_name = $j2c_input->get('name', null, null);
					if ($j2c_name == null) { // should not happen but better safe ...
						$j2c_name = $user['name'];
					}
					$j2c_namesplit	= $this->doSplitName($j2c_name);
					$j2c_firstname	= $j2c_namesplit['first'];
					$j2c_middlename	= $j2c_namesplit['middle'];
					$j2c_lastname	= $j2c_namesplit['last'];

				}
				break;

			case 'com_users': // case of Joomla user component invoking user creation

				$j2c_email		= strtolower(trim($user['email']));
				$j2c_name		= $user['name'];
				$j2c_namesplit	= $this->doSplitName($j2c_name);
				$j2c_firstname	= $j2c_namesplit['first'];
				$j2c_middlename	= $j2c_namesplit['middle'];
				$j2c_lastname	= $j2c_namesplit['last'];
				break;

			case 'com_civicrm': // case of CiviCRM invoking user creation

				// Do not do anything - let CiviCRM handle this as it already does
				return;
				break;

			default: // other extensions creating Joomla users

				// Do not do anything if unknown component triggered user save
				return;
				break;
		}

		// Get plugin configurations
		$j2c_multicontacthandling		= $this->params->get('j2c_multicontacthandling', 1);
		$j2c_domainid					= (int) $this->params->get('j2c_domainid', 1);
		$j2c_locationtype				= (int) $this->params->get('j2c_locationtype', 1);
		$j2c_version					= (string) $this->params->get('j2c_civicrmversion', 0);

		$j2c_nc_add_group				= (int) $this->params->get('j2c_nc_add_group',0);
		$j2c_nc_group					= $this->params->get('j2c_nc_group',0);

		$j2c_nc_add_tag					= (int) $this->params->get('j2c_nc_add_tag',0);
		$j2c_nc_tag						= $this->params->get('j2c_nc_tag',0);

		$j2c_nc_add_note				= (int) $this->params->get('j2c_nc_add_note',0);
		$j2c_nc_note_subject			= (string) $this->params->get('j2c_nc_note_subject',"");
		$j2c_nc_note_message			= (string) $this->params->get('j2c_nc_note_subject',"");
		$j2c_nc_noteid					= (int) $this->params->get('j2c_nc_noteid',0);

		$j2c_nc_activity				= (int) $this->params->get('j2c_nc_activity',0);
		$j2c_nc_schedule				= (string) $this->params->get('j2c_nc_schedule','+3 DAYS');
		$j2c_nc_duration				= (int) $this->params->get('j2c_nc_duration',0);
		$j2c_nc_activitystatus			= (int) $this->params->get('j2c_nc_activitystatus',1);
		$j2c_nc_activitypriority		= (int) $this->params->get('j2c_nc_activitypriority',1);
		$j2c_nc_activitytype			= (int) $this->params->get('j2c_nc_activitytype',1);
		$j2c_nc_activitysubject			= (string) $this->params->get('j2c_nc_activitysubject',
											"New registration contact");
		$j2c_nc_activitymessage			= (string) $this->params->get('j2c_nc_activitymessage',"");
		$j2c_nc_activityids				= $this->params->get('j2c_nc_activityids','0');

		$j2c_sc_add_group				= (int) $this->params->get('j2c_sc_add_group',0);
		$j2c_sc_group					= $this->params->get('j2c_sc_group',0);

		$j2c_sc_add_tag					= (int) $this->params->get('j2c_sc_add_tag',0);
		$j2c_sc_tag						= $this->params->get('j2c_sc_tag',0);

		$j2c_sc_add_note				= (int) $this->params->get('j2c_sc_add_note',0);
		$j2c_sc_note_subject			= (string) $this->params->get('j2c_sc_note_subject',"");
		$j2c_sc_note_message			= (string) $this->params->get('j2c_sc_note_subject',"");
		$j2c_sc_noteid					= (int) $this->params->get('j2c_sc_noteid',0);

		$j2c_sc_activity				= (int) $this->params->get('j2c_sc_activity',0);
		$j2c_sc_schedule				= (string) $this->params->get('j2c_sc_schedule','+3 DAYS');
		$j2c_sc_duration				= (int) $this->params->get('j2c_sc_duration',0);
		$j2c_sc_activitystatus			= (int) $this->params->get('j2c_sc_activitystatus',1);
		$j2c_sc_activitypriority		= (int) $this->params->get('j2c_sc_activitypriority',1);
		$j2c_sc_activitytype			= (int) $this->params->get('j2c_sc_activitytype',1);
		$j2c_sc_activitysubject			= (string) $this->params->get('j2c_sc_activitysubject',
											"New registration for existing contact");
		$j2c_sc_activitymessage			= (string) $this->params->get('j2c_sc_activitymessage',"");
		$j2c_sc_activityids				= $this->params->get('j2c_sc_activityids','0');

		$j2c_mc_add_group				= (int) $this->params->get('j2c_mc_add_group',0);
		$j2c_mc_group					= $this->params->get('j2c_mc_group',0);

		$j2c_mc_add_tag					= (int) $this->params->get('j2c_mc_add_tag',0);
		$j2c_mc_tag						= $this->params->get('j2c_mc_tag',0);

		$j2c_mc_add_note				= (int) $this->params->get('j2c_mc_add_note',0);
		$j2c_mc_note_subject			= (string) $this->params->get('j2c_mc_note_subject',"");
		$j2c_mc_note_message			= (string) $this->params->get('j2c_mc_note_subject',"");
		$j2c_mc_noteid					= (int) $this->params->get('j2c_mc_noteid',0);

		$j2c_mc_activity				= (int) $this->params->get('j2c_mc_activity',0);
		$j2c_mc_schedule				= (string) $this->params->get('j2c_mc_schedule','+3 DAYS');
		$j2c_mc_duration				= (int) $this->params->get('j2c_mc_duration',0);
		$j2c_mc_activitystatus			= (int) $this->params->get('j2c_mc_activitystatus',1);
		$j2c_mc_activitypriority		= (int) $this->params->get('j2c_mc_activitypriority',1);
		$j2c_mc_activitytype			= (int) $this->params->get('j2c_mc_activitytype',1);
		$j2c_mc_activitysubject			= (string) $this->params->get('j2c_mc_activitysubject',
											"New registration for existing multi-contact");
		$j2c_mc_activitymessage			= (string) $this->params->get('j2c_mc_activitymessage',"");
		$j2c_mc_activityids				= $this->params->get('j2c_mc_activityids','0');

		$j2c_juserid = $user['id'];

		if (version_compare($j2c_version, '5.0.0', '<')) {
			$app->enqueueMessage(JText::_($j2c_version & 'CiviCRM 5.0.0 or better required'), 'error');
			return;
		}

		require_once JPATH_ROOT . '/administrator/components/com_civicrm/helpers/api.php';
		CivicrmHelperApi::civiimport('api');
		CivicrmHelperApi::civiimport('UFMatch');

		$params = array(
			'email'		=> $j2c_email,
			'options'	=> array(
				' sort'	=> ' is_primary DESC'
			),
			'version'	=> 3
		);

		$j2c_contact = civicrm_api('Contact', 'Get', $params);

		if ( $j2c_contact['is_error'] ) { // if contact search failed


			$app->enqueueMessage(
				JText::sprintf(
					'CiviCRM contact search failed: %s',
					$j2c_contact['error_message']
				),
				'error'
			);
			return;
		}

		$j2c_number_of_contacts_found = $j2c_contact['count'];

		if ($j2c_number_of_contacts_found > 0) { // at least 1 CiviCRM contact found


			if ($j2c_number_of_contacts_found == 1) { // single matching email found so lets UF_Match link

				$j2c_contactid = $j2c_contact['id'];

				// Get existing record info to use later for possible update in case of Individual record type
				$j2c_contactrecord = $j2c_contact['values'][$j2c_contactid];

				$j2c_contactrecordtype = $j2c_contactrecord['contact_type'];
				$j2c_contactrecordfirstname = $j2c_contactrecord['first_name'];
				$j2c_contactrecordmiddlename = $j2c_contactrecord['middle_name'];
				$j2c_contactrecordlastname = $j2c_contactrecord['last_name'];


				$params = array(
					'contact_id'	=> $j2c_contactid,
					'version'		=> 3
				);

				// Being paranoid or safe - lets make sure the CiviCRM contact is not already linked
				$j2c_result = civicrm_api('uf_match', 'get', $params);
				if ($j2c_result['count'] != 0) {
					// error handling goes here
					$app->enqueueMessage(JText::_('CiviCRM contact not found but matching exists'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					return;
				}

				$params = array(
					'contact_id'	=> $j2c_contactid,
					'uf_id'			=> $j2c_juserid,
					'uf_name'		=> $j2c_email,
					'domain_id'		=> $j2c_domainid,
					'version'		=> 3
				);

				$j2c_result = civicrm_api('uf_match', 'create', $params);

				if ($j2c_result['is_error'] != 0) {
					// error handling goes here
					$app->enqueueMessage(JText::_('CiviCRM contact match creation failed'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
				}

				// code to sync first, middle, last names if they are currently empty in existing civi contact

				if	( 	$j2c_contactrecordtype=='Individual' &&
						($j2c_contactrecordfirstname == "") &&
						($j2c_contactrecordmiddlename == "") &&
						($j2c_contactrecordlastname == "" )
					) {
						$params = array(
							'contact_id'	=> $j2c_contactid,
							'version'		=> 3,
							'first_name'	=> $j2c_firstname,
							'last_name'		=> $j2c_lastname,
							'middle_name'	=> $j2c_middlename
						);

						$j2c_result = civicrm_api('contact', 'update', $params);

						if ($j2c_result['is_error'] != 0) {
							// error handling goes here
							$app->enqueueMessage(JText::_('CiviCRM contact update failed'), 'error');
							$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
						}
				}

				$j2c_contact2use 			= $j2c_contactid;
				$j2c_add_group				= $j2c_sc_add_group;
				$j2c_group					= $j2c_sc_group;
				$j2c_add_tag				= $j2c_sc_add_tag;
				$j2c_tag					= $j2c_sc_tag;

				$j2c_addnote2use			= $j2c_sc_add_note;
				$j2c_notesubject2use		= $j2c_sc_note_subject;
				$j2c_notemessage2use		= $j2c_sc_note_message;
				$j2c_noteid2use				= $j2c_sc_noteid;

				$j2c_activity2use 			= $j2c_sc_activity;
				$j2c_schedule2use			= $j2c_sc_schedule;
				$j2c_duration2use			= $j2c_sc_duration;
				$j2c_activitystatus2use		= $j2c_sc_activitystatus;
				$j2c_activitypriority2use	= $j2c_sc_activitypriority;
				$j2c_activitytype2use 		= $j2c_sc_activitytype;
				$j2c_activitysubject2use 	= $j2c_sc_activitysubject;
				$j2c_activitymessage2use 	= $j2c_sc_activitymessage;
				$j2c_activityids2use		= $j2c_sc_activityids;


			} else { // multiple matching emails found so we need to decide what to do

				$j2c_activity2use 			= $j2c_mc_activity;
				$j2c_add_group				= $j2c_mc_add_group;
				$j2c_group					= $j2c_mc_group;
				$j2c_add_tag				= $j2c_mc_add_tag;
				$j2c_tag					= $j2c_mc_tag;
				$j2c_schedule2use			= $j2c_mc_schedule;
				$j2c_duration2use			= $j2c_mc_duration;
				$j2c_addnote2use			= $j2c_mc_add_note;
				$j2c_notesubject2use		= $j2c_mc_note_subject;
				$j2c_notemessage2use		= $j2c_mc_note_message;
				$j2c_noteid2use				= $j2c_mc_noteid;
				$j2c_activitystatus2use		= $j2c_mc_activitystatus;
				$j2c_activitypriority2use	= $j2c_mc_activitypriority;
				$j2c_activitytype2use 		= $j2c_mc_activitytype;
				$j2c_activitysubject2use 	= $j2c_mc_activitysubject;
				$j2c_activitymessage2use 	= $j2c_mc_activitymessage;
				$j2c_activityids2use		= $j2c_mc_activityids;


				switch( $j2c_multicontacthandling ) { // act as plugin parameter configuration dictates

					case '0': // Skip and do not sync - might want to send email to admins here
						// TODO might want to send email to admins here - does not make sense to add activities
						return;
						break;

					case '1': // use oldest (first) contact record found
						$j2c_contact2use 			= reset($j2c_contact['values']); // get first key in results array
						break;

					case '2': // use newest (last) contact record found
						$j2c_contact2use = end($j2c_contact['values']); // get last key in results array
						break;

					case '3': // create new contact record and then match
						$params = array(
							'version'			=> 3,
							'contact_type'		=> 'Individual',
							'first_name'		=> $j2c_firstname,
							'last_name'			=> $j2c_lastname,
							'middle_name'		=> $j2c_middlename,
							'dupe_check'		=> 0,
							'api.email.create'	=> array(
								'email'				=> $j2c_email,
								'location_type_id'	=> $j2c_locationtype, // email location type from plugin parameters
								'is_primary'		=> 1
							)
						);

						$j2c_contact2use = civicrm_api('contact', 'create', $params);

						if ($j2c_contact['is_error']) {
							$app->enqueueMessage(JText::_('CiviCRM contact creation failed'), 'error');
							$app->enqueueMessage(JText::_( $j2c_contact['error_message'] ), 'error');
							return;
						}

						break;

					default:	// should not happen, but if it does just return without doing anything
						return;
						break;

				}

				$params = array(
					'contact_id'	=> $j2c_contact2use['id'],
					'version'		=> 3
				);

				// Being paranoid or safe - lets make sure the CiviCRM contact is not already linked
				$j2c_result = civicrm_api('uf_match', 'get', $params);
				if ($j2c_result['count'] != 0) {
					// error handling goes here
					$app->enqueueMessage(JText::_('CiviCRM contact not found but matching exists'), 'error');
					return;
				}

				$params = array(
					'contact_id'	=> $j2c_contact2use['id'],
					'uf_id'			=> $j2c_juserid,
					'uf_name'		=> $j2c_email,
					'domain_id'		=> $j2c_domainid,
					'version'		=> 3
				);

				$j2c_result = civicrm_api('uf_match', 'create', $params);

				if ($j2c_result['is_error'] != 0) {
					// error handling goes here
					$app->enqueueMessage(JText::_('CiviCRM contact match creation failed'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					return;
				}

				// code to sync first, middle, last names if they are currently empty in existing civi contact

				// Get existing record info to use later for possible update in case of Individual record type
				$j2c_contactrecord = $j2c_contact['values'][$j2c_contact2use['id']];

				$j2c_contactrecordtype = $j2c_contactrecord['contact_type'];
				$j2c_contactrecordfirstname = $j2c_contactrecord['first_name'];
				$j2c_contactrecordmiddlename = $j2c_contactrecord['middle_name'];
				$j2c_contactrecordlastname = $j2c_contactrecord['last_name'];

				if	( 	$j2c_contactrecordtype=='Individual' &&
					($j2c_contactrecordfirstname == "") &&
					($j2c_contactrecordmiddlename == "") &&
					($j2c_contactrecordlastname == "" )
				) {
					$params = array(
						'contact_id'	=> $j2c_contact2use['id'],
						'version'		=> 3,
						'first_name'	=> $j2c_firstname,
						'last_name'		=> $j2c_lastname,
						'middle_name'	=> $j2c_middlename
					);

					$j2c_result = civicrm_api('contact', 'update', $params);

					if ($j2c_result['is_error'] != 0) {
						// error handling goes here
						$app->enqueueMessage(JText::_('CiviCRM contact update failed'), 'error');
						$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					}
				}

			}


		} else { // no CiviCRM contact found for given Joomla user email so lets create one

			$params = array(
				'version'			=> 3,
				'contact_type'		=> 'Individual',
				'first_name'		=> $j2c_firstname,
				'last_name'			=> $j2c_lastname,
				'middle_name'		=> $j2c_middlename,
				'dupe_check'		=> 0,
				'api.email.create'	=> array(
					'email'				=> $j2c_email,
					'location_type_id'	=> $j2c_locationtype, // home email
					'is_primary'		=> 1
				)
			);

			$j2c_contact = civicrm_api('contact', 'create', $params);

			if ($j2c_contact['is_error']) {
				$app->enqueueMessage(JText::_('Contact creation failed'), 'error');
				$app->enqueueMessage(JText::_( $j2c_contact['error_message'] ), 'error');
				return;
			}

			$j2c_contactid = $j2c_contact['id'];

			$params = array(
				'contact_id'	=> $j2c_contactid,
				'version'		=> 3,
			);

			// Being paranoid or safe - lets make sure the CiviCRM contact is not already linked
			$j2c_result = civicrm_api('uf_match', 'get', $params);
			if ($j2c_result['count'] != 0) {
				// error handling goes here
				$app->enqueueMessage(JText::_('Contact not found but matching exists'), 'error');
				$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
				return;
			}

			$params = array(
				'contact_id'	=> $j2c_contactid,
				'uf_id'			=> $j2c_juserid,
				'uf_name'		=> $j2c_email,
				'domain_id'		=> $j2c_domainid,
				'version'		=> 3
			);

			$j2c_result = civicrm_api('uf_match', 'create', $params);

			if ($j2c_result['is_error']) {
				$app->enqueueMessage(JText::_('Contact match creation failed'), 'error');
				$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
				return;
			}

			$j2c_contact2use 			= $j2c_contactid;
			$j2c_add_group				= $j2c_nc_add_group;
			$j2c_group					= $j2c_nc_group;
			$j2c_add_tag				= $j2c_nc_add_tag;
			$j2c_tag					= $j2c_nc_tag;
			$j2c_addnote2use			= $j2c_nc_add_note;
			$j2c_notesubject2use		= $j2c_nc_note_subject;
			$j2c_notemessage2use		= $j2c_nc_note_message;
			$j2c_noteid2use				= $j2c_nc_noteid;
			$j2c_activity2use 			= $j2c_nc_activity;
			$j2c_schedule2use			= $j2c_nc_schedule;
			$j2c_duration2use			= $j2c_nc_duration;
			$j2c_activitystatus2use		= $j2c_nc_activitystatus;
			$j2c_activitypriority2use	= $j2c_nc_activitypriority;
			$j2c_activitytype2use 		= $j2c_nc_activitytype;
			$j2c_activitysubject2use 	= $j2c_nc_activitysubject;
			$j2c_activitymessage2use 	= $j2c_nc_activitymessage;
			$j2c_activityids2use		= $j2c_nc_activityids;

		}

		// group assignments go here
		if ($j2c_add_group && $j2c_contact2use && $j2c_group) { // if we have contact and group assignment task

			$j2c_groupcount = count($j2c_group);

			for ($j2c_i=0; $j2c_i < $j2c_groupcount; $j2c_i++) {

				$params = array(
					'version' => 3,
					'sequential' => 1,
					'contact_id' => $j2c_contact2use,
					'group_id' => $j2c_group[$j2c_i]
				);
				$j2c_result = civicrm_api('GroupContact', 'create', $params);

				if ($j2c_result['is_error']) {
					$app->enqueueMessage(JText::_('Group assignment failed'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					return;
				}
			}
		}

		// tag assignments go here
		if ($j2c_add_tag && $j2c_contact2use && $j2c_tag) { // if we have contact and tag assignment task

			$j2c_tagcount = count($j2c_tag);

			for ($j2c_i=0; $j2c_i < $j2c_tagcount; $j2c_i++) {

				$params = array(
					'version' => 3,
					'sequential' => 1,
					'contact_id' => $j2c_contact2use,
					'tag_id' => $j2c_tag[$j2c_i]
				);
				$j2c_result = civicrm_api('EntityTag', 'create', $params);

				if ($j2c_result['is_error']) {
					$app->enqueueMessage(JText::_('Tag assignment failed'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					return;
				}
			}
		}

		// note creation goes here
		// $j2c_addnote2use
		// $j2c_notesubject2use
		// $j2c_notemessage2use
		// $j2c_noteid2use

		if ($j2c_addnote2use && $j2c_contact2use) { // if we have contact and note creation task

			if ($j2c_noteid2use != 0) {
				$params = array(
					'version' => 3,
					'entity_table' => 'civicrm_contact',
					'entity_id' => $j2c_contact2use,
					'contact_id' => $j2c_noteid2use,
					'subject' => $j2c_notesubject2use,
					'note' => $j2c_notemessage2use
				);
			} else {
				$params = array(
					'version' => 3,
					'entity_table' => 'civicrm_contact',
					'entity_id' => $j2c_contact2use,
					'contact_id' => $j2c_contact2use,
					'subject' => $j2c_notesubject2use,
					'note' => $j2c_notemessage2use
				);
			}

			$j2c_result = civicrm_api('Note', 'create', $params);

			if ($j2c_result['is_error']) {
					$app->enqueueMessage(JText::_('Note creation failed'), 'error');
					$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
					return;
			}
		}


		// $j2c_contact2use contains the id of the contact that was synced, 0 means no sync happened

		if ($j2c_activity2use && $j2c_contact2use) {

			if ( strpos($j2c_activityids2use, ",") === false ) { // if assigned to single contact then parameter does not have to be an array
				$params = array(
					'contact_id'	=> $j2c_activityids2use,
					'version'		=> 3
				);
				$j2c_idsearch = civicrm_api('Contact', 'Get', $params);
				$j2c_idfound = $j2c_idsearch['count'];

				if (!$j2c_idfound) { // if not valid id, then we use 0 for not assigned

					$j2c_safeactivityids2use = 0;
				} else {
					$j2c_safeactivityids2use = $j2c_activityids2use;
				}
			} else { // if we have a comma separated list of contact_ids
				$j2c_safeactivityids2use = array();
				$j2c_activitylist = explode(",", $j2c_activityids2use);
				$j2c_activitylistcount = count($j2c_activitylist);

				for ($j2c_i=0; $j2c_i < $j2c_activitylistcount; $j2c_i++) {

					$params = array(
						'contact_id'	=> $j2c_activitylist[$j2c_i],
						'version'		=> 3
					);
					$j2c_idsearch = civicrm_api('Contact', 'Get', $params);
					$j2c_idfound = $j2c_idsearch['count'];

					if ($j2c_idfound) { // if valid id, then we add it to array

						$j2c_safeactivityids2use[] = $j2c_activitylist[$j2c_i];
					}
				}

				if (count($j2c_safeactivityids2use) == 0) {
					$j2c_safeactivityids2use = 0;
				}
			}

			$params = array(
				'source_contact_id'		=> $j2c_contact2use,
				'activity_type_id'		=> $j2c_activitytype2use,
				'subject' 				=> $j2c_activitysubject2use,
				'activity_date_time' 	=> date('Y-m-d H:i:s', strtotime($j2c_schedule2use)),
				'duration'				=> (int) $j2c_duration2use,
				'status_id' 			=> (int) $j2c_activitystatus2use,
				'priority_id' 			=> (int) $j2c_activitypriority2use,
				'details' 				=> $j2c_activitymessage2use,
				'assignee_contact_id' 	=> $j2c_safeactivityids2use,
				'target_contact_id'		=> $j2c_contact2use,
				'version' 				=> 3
			);

			$j2c_result = civicrm_api( 'Activity', 'create', $params );

			if ($j2c_result['is_error']) {
				$app->enqueueMessage(JText::_('Activity creation failed'), 'error');
				$app->enqueueMessage(JText::_( $j2c_result['error_message'] ), 'error');
				return;
			}
		}

	} //end onUserAfterSave


	/**
	 * splits single name string into first, middle, last
	 *
	 * @param string $name
	 * @return array
	 */
	public static function doSplitName($name)
	{
		$results = array();
		$r = explode(' ', $name);
		$size = count($r);

		switch ($size) {

			case 0: // this should never happen because Joomla name is mandatory
				$results['first']	= '-';
				$results['middle']	= '';
				$results['last']	= '-';
				break;

			case 1: // this might happen
				$results['first']	= $r[0];
				$results['middle']	= '';
				$results['last']	= '-';
				break;

			case 2:
				$results['first']	= $r[0];
				$results['middle']	= '';
				$results['last']	= $r[1];
				break;

			default:
				$results['first']	= $r[0];
				$results['middle']	= $r[1];
				$results['last']	= $r[2];
				$i = 3;
				while ($i <= $size) {
					$results['last'] .= ' ' . $r[$i++];
				}
		}

		return $results;
	}

}