<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Plugin\ProfileBook\CBProfileBook;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework, $_CB_database, $_PLUGINS;

if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
	echo 'CB not installed'; return;
}

include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

cbimport( 'cb.html' );
cbimport( 'language.front' );

$_PLUGINS->loadPluginGroup( 'user' );

if ( ! $_PLUGINS->getLoadedPlugin( 'user', 'cb.profilebook' ) ) {
	echo 'CB ProfileBook not installed'; return;
}

outputCbJs();
outputCbTemplate();

$viewer				=	CBuser::getMyUserDataInstance();
$mode				=	$params->get( 'pblatest_mode', 'b' );
$connections		=	(int) $params->get( 'pblatest_connections', 0 );
$limit				=	(int) $params->get( 'pblatest_limit', 5 );
$include			=	$params->get( 'pblatest_include', null );
$exclude			=	$params->get( 'pblatest_exclude', null );

$templateClass		=	'cb_template cb_template_' . selectTemplate( 'dir' ) . ' pbModule';

$query				=	"SELECT COUNT(*)"
					.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plug_profilebook' ) . " AS a";

switch ( $connections ) {
	case 1: // Posts By
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON a." . $_CB_database->NameQuote( 'posterid' ) . " = b." . $_CB_database->NameQuote( 'memberid' );
		break;
	case 2: // Posts To
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON a." . $_CB_database->NameQuote( 'userid' ) . " = b." . $_CB_database->NameQuote( 'memberid' );
		break;
	case 3: // Posts By and To
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON ( a." . $_CB_database->NameQuote( 'posterid' ) . " = b." . $_CB_database->NameQuote( 'memberid' )
					.	" OR a." . $_CB_database->NameQuote( 'userid' ) . " = b." . $_CB_database->NameQuote( 'memberid' ) . " )";
		break;
}

$query				.=	"\n WHERE a." . $_CB_database->NameQuote( 'published' ) . " = 1"
					.	( $mode != 'a' ? "\n AND a." . $_CB_database->NameQuote( 'mode' ) . " = " . $_CB_database->Quote( $mode ) : null )
					.	( $include ? "\n AND a." . $_CB_database->NameQuote( 'userid' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $include ) ) : null )
					.	( $exclude ? "\n AND a." . $_CB_database->NameQuote( 'userid' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $exclude ) ) : null )
					.	( $connections ? "\n AND b." . $_CB_database->NameQuote( 'referenceid' ) . " = " . Application::MyUser()->getUserId() : null );
$_CB_database->setQuery( $query );
$total				=	$_CB_database->loadResult();

if ( ! $total ) {
	return;
}

$query				=	"SELECT a.*"
					.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plug_profilebook' ) . " AS a";

switch ( $connections ) {
	case 1: // Posts By
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON a." . $_CB_database->NameQuote( 'posterid' ) . " = b." . $_CB_database->NameQuote( 'memberid' );
		break;
	case 2: // Posts To
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON a." . $_CB_database->NameQuote( 'userid' ) . " = b." . $_CB_database->NameQuote( 'memberid' );
		break;
	case 3: // Posts By and To
		$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler_members' ) . " AS b"
					.	" ON ( a." . $_CB_database->NameQuote( 'posterid' ) . " = b." . $_CB_database->NameQuote( 'memberid' )
					.	" OR a." . $_CB_database->NameQuote( 'userid' ) . " = b." . $_CB_database->NameQuote( 'memberid' ) . " )";
		break;
}

$query				.=	"\n WHERE a." . $_CB_database->NameQuote( 'published' ) . " = 1"
					.	( $mode != 'a' ? "\n AND a." . $_CB_database->NameQuote( 'mode' ) . " = " . $_CB_database->Quote( $mode ) : null )
					.	( $include ? "\n AND a." . $_CB_database->NameQuote( 'userid' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $include ) ) : null )
					.	( $exclude ? "\n AND a." . $_CB_database->NameQuote( 'userid' ) . " NOT IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $exclude ) ) : null )
					.	( $connections ? "\n AND b." . $_CB_database->NameQuote( 'referenceid' ) . " = " . Application::MyUser()->getUserId() : null )
					.	"\n ORDER BY a." . $_CB_database->NameQuote( 'date' ) . " DESC";
$_CB_database->setQuery( $query, 0, ( $limit ? $limit : 0 ) );
/** @noinspection PhpUnusedLocalVariableInspection */
$rows				=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\ProfileBook\Table\EntryTable', array( $_CB_database ) );

CBProfileBook::getTemplate();

require JModuleHelper::getLayoutPath( 'mod_cbpblatest', $params->get( 'layout', 'default' ) );