<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Invites\Trigger;

use CB\Database\Table\UserTable;
use CB\Plugin\Invites\Table\InviteTable;
use CBLib\Application\Application;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * @param UserTable $user
	 */
	public function acceptInvites( $user )
	{
		global $_CB_database;

		$code		=	$user->getString( 'invite_code' );

		if ( ( ! $code ) && ( ! Application::Application()->isClient( 'administrator' ) ) ) {
			$code	=	Application::Session()->get( 'invite_code' );
		}

		$query		=	'SELECT *'
					.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' );
		if ( $code ) {
			$query	.=	"\n WHERE ( " . $_CB_database->NameQuote( 'to' ) . " = " . $_CB_database->Quote( $user->getString( 'email' ) )
					.	' OR ' . $_CB_database->NameQuote( 'code' ) . ' = ' . $_CB_database->Quote( $code ) . ' )';
		} else {
			$query	.=	"\n WHERE " . $_CB_database->NameQuote( 'to' ) . " = " . $_CB_database->Quote( $user->getString( 'email' ) );
		}
		$_CB_database->setQuery( $query );
		$invites	=	$_CB_database->loadObjectList( null, '\CB\Plugin\Invites\Table\InviteTable', array( $_CB_database ) );

		/** @var InviteTable[] $invites */
		foreach ( $invites as $invite ) {
			$invite->accept( $user );
		}
	}

	/**
	 * @param UserTable $user
	 */
	public function deleteInvites( $user )
	{
		global $_CB_database;

		if ( ! $this->params->getBool( 'general_delete', true ) ) {
			return;
		}

		$query		=	'SELECT *'
					.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' )
					.	"\n WHERE ( " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
					.	' OR ' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 )
					.	' OR ' . $_CB_database->NameQuote( 'to' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) ) . ' )';
		$_CB_database->setQuery( $query );
		$invites	=	$_CB_database->loadObjectList( null, '\CB\Plugin\Invites\Table\InviteTable', array( $_CB_database ) );

		/** @var InviteTable[] $invites */
		foreach ( $invites as $invite ) {
			$invite->delete();
		}
	}
}
