<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Invites/(.+)%i', __DIR__ . '/library/$1.php' );

class_alias( '\CB\Plugin\Invites\Tab\InvitesTab', 'cbinvitesTab' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\Invites\Trigger\AdminTrigger' );

$_PLUGINS->registerFunction( 'onAfterUserRegistration', 'acceptInvites', '\CB\Plugin\Invites\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterNewUser', 'acceptInvites', '\CB\Plugin\Invites\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deleteInvites', '\CB\Plugin\Invites\Trigger\UserTrigger' );

$_PLUGINS->registerFunction( 'onBuildRoute', 'build', '\CB\Plugin\Invites\Trigger\RouterTrigger' );
$_PLUGINS->registerFunction( 'onParseRoute', 'parse', '\CB\Plugin\Invites\Trigger\RouterTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array( 'invite_code' => '\CB\Plugin\Invites\Field\InviteField' ) );
