<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

namespace CB\Plugin\GroupJiveVideo\Trigger;

use CB\Plugin\GroupJiveVideo\Table\VideoTable;
use CB\Database\Table\UserTable;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * Deletes data when a user is deleted
	 *
	 * @param  UserTable $user
	 * @param  int       $status
	 */
	public function deleteVideos( $user, $status )
	{
		global $_CB_database;

		if ( $this->params->getBool( 'groups_video_delete', true ) ) {
			$query		=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_video' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
			$_CB_database->setQuery( $query );
			$videos		=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJiveVideo\Table\VideoTable', array( $_CB_database ) );

			/** @var VideoTable[] $videos */
			foreach ( $videos as $video ) {
				$video->delete();
			}
		}
	}
}