<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveVideo;

use CB\Plugin\GroupJiveVideo\Table\VideoTable;

defined('CBLIB') or die();

class CBGroupJiveVideo
{
	/** @var VideoTable[]  */
	private static $videoCache	=	array();

	/**
	 * Caches a prefetched array of videos for reuse
	 *
	 * @param VideoTable[] $videos
	 */
	public static function prefetchVideos( $videos )
	{
		foreach ( $videos as $video ) {
			$rowId						=	$video->getInt( 'id', 0 );

			if ( ! $rowId ) {
				continue;
			}

			self::$videoCache[$rowId]	=	$video;
		}
	}

	/**
	 * returns a cached video object
	 *
	 * @param int $id
	 * @return VideoTable
	 */
	public static function getVideo( $id )
	{
		if ( ! $id ) {
			return new VideoTable();
		}

		if ( ! isset( self::$videoCache[$id] ) ) {
			$row					=	new VideoTable();

			$row->load( (int) $id );

			self::$videoCache[$id]	=	$row;
		}

		return self::$videoCache[$id];
	}
}