<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\ReconfirmEmail\Trigger;

use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;

defined('CBLIB') or die();

class AdminTrigger extends \cbPluginHandler
{

	/**
	 * Displays backend menu items
	 *
	 * @param array $menu
	 * @param bool  $disabled
	 */
	public function adminMenu( &$menu, $disabled )
	{
		global $_CB_framework;

		if ( ! $this->params->get( 'general_menu', true, GetterInterface::BOOLEAN ) ) {
			return;
		}

		$pluginMenu					=	array();

		$pluginMenu['component']	=	array(	'title' => CBTxt::T( 'Reconfirm Email' ) );
		$pluginMenu['menu']			=	array(	array(	'title' => CBTxt::T( 'Emails' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'action' => 'showreconfirmemails', 'cid' => $this->getPluginId() ) ), 'icon' => 'cbreconfirmemail-logs' ),
												array(	'title' => CBTxt::T( 'Configuration' ), 'link' => $_CB_framework->backendViewUrl( 'editrow', true, array( 'table' => 'pluginsbrowser', 'action' => 'editrow', 'cid' => $this->getPluginId(), 'cbprevstate' => base64_encode( 'option=com_comprofiler&view=showPlugins' ) ) ), 'icon' => 'cbreconfirmemail-config' )
											);

		$menu['reconfirm']			=	$pluginMenu;
	}
}