<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\NotificationTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveEventNotifications
{

	/**
	 * render frontend group event notify params
	 *
	 * @param NotificationTable $row
	 * @param array             $input
	 * @param GroupTable        $group
	 * @param UserTable         $user
	 * @param cbPluginHandler   $plugin
	 * @return string
	 */
	public static function showEventNotifications( $row, $input, $group, $user, $plugin )
	{
		$isModerator	=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner		=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$status			=	CBGroupJive::getGroupStatus( $user, $group );

		$return			=	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__event_new" class="col-form-label col-9 pr-2">' . CBTxt::T( 'Schedule of new event' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['event_new']
						.		'</div>'
						.	'</div>'
						.	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__event_edit" class="col-form-label col-9 pr-2">' . CBTxt::T( 'Edit of existing event' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['event_edit']
						.		'</div>'
						.	'</div>';

		if ( ( $isModerator || $isOwner || ( $status >= 2 ) ) && ( $group->params()->getInt( 'events', 1 ) === 2 ) ) {
			$return		.=	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__event_approve" class="col-form-label col-9 pr-2">' . CBTxt::T( 'New event requires approval' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['event_approve']
						.		'</div>'
						.	'</div>';
		}

		$return			.=	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__event_attend" class="col-form-label col-9 pr-2">' . CBTxt::T( 'User attends my existing events' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['event_attend']
						.		'</div>'
						.	'</div>'
						.	'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
						.		'<label for="params__event_unattend" class="col-form-label col-9 pr-2">' . CBTxt::T( 'User unattends my existing events' ) . '</label>'
						.		'<div class="cb_field col-3 text-right">'
						.			$input['event_unattend']
						.		'</div>'
						.	'</div>';

		return $return;
	}
}