<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveEvents\Table\EventTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveEventMessage
{

	/**
	 * render frontend event message
	 *
	 * @param EventTable      $row
	 * @param array           $input
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 */
	public static function showMessage( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$pageTitle					=	CBTxt::T( 'Message Guests' );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$return						=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayEventMessage', array( &$return, &$row, &$input, $group, $user ) );

		$showSubject				=	( ( $plugin->params->getInt( 'groups_events_message_type', 2 ) === 1 ) && $plugin->params->getBool( 'groups_events_message_subject', false ) );

		$return						.=	'<div class="gjEventMessage">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'send', 'id' => $row->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjEventMessageForm" id="gjEventMessageForm" class="form-auto m-0 cb_form gjEventMessageForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjEventMessageTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null );

		if ( $showSubject ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line cbtwolines">'
									.				'<label for="subject" class="col-form-label col-12">' . CBTxt::T( 'Subject' ) . '</label>'
									.				'<div class="cb_field col-12">'
									.					$input['subject']
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line cbtwolines">'
									.				( $showSubject ? '<label for="message" class="col-form-label col-12">' . CBTxt::T( 'Message' ) . '</label>' : null )
									.				'<div class="cb_field col-12">'
									.					$input['message']
									.				'</div>'
									.			'</div>';

		if ( $plugin->params->getBool( 'groups_events_message_captcha', false ) && ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line cbtwolines">'
									.				'<label class="col-form-label col-12">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-12">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line cbtwolines">'
									.				'<div class="cb_field col-12">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div>'
									.				'<input type="submit" value="' . htmlspecialchars( CBTxt::T( 'Send Message' ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.				' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.			'</div>'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayEventMessage', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}