<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveEvents\Table\EventTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveEventEdit
{

	/**
	 * render frontend event edit
	 *
	 * @param EventTable               $row
	 * @param array                    $input
	 * @param GroupTable               $group
	 * @param UserTable                $user
	 * @param CBplug_cbgroupjiveevents $plugin
	 */
	public static function showEventEdit( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$pageTitle					=	( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Edit Event' ) : CBTxt::T( 'New Event' ) );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$canModerate				=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );
		$return						=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayEventEdit', array( &$return, &$row, &$input, $group, $user ) );

		$return						.=	'<div class="gjEventEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'save', 'group' => ( ! $row->getInt( 'id', 0 ) ? $group->getInt( 'id' ) : null ), 'id' => $row->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjEventEditForm" id="gjEventEditForm" class="form-auto m-0 cb_form gjEventEditForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjEventEditTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null );

		if ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 1 ) !== -1 ) ) || ( $group->params()->getInt( 'events', 1 ) !== 2 ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select publish state of this event. Unpublished events will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="title" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Title' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['title']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the event title. This is the title that will distinguish this event from others. Suggested to input something to uniquely identify your event.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="event" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Event' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['event']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input a detailed description about this event.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="location" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Location' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['location']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the location for this event (e.g. My House, The Park, Restaurant Name, etc..).' ) )
									.				'</div>'
									.			'</div>';

		if ( $plugin->params->getBool( 'groups_events_address', true ) ) {
			$canGeoLocate			=	false;

			if ( isset( $_SERVER['HTTPS'] ) && ( ! empty( $_SERVER['HTTPS'] ) ) && ( $_SERVER['HTTPS'] !== 'off' ) ) {
				$js					=	"$( '.gjButtonLocation' ).on( 'click', function() {"
									.		"if ( typeof navigator.geolocation == 'undefined' ) {"
									.			"return null;"
									.		"}"
									.		"var input = $( this ).siblings( 'input' );"
									.		"navigator.geolocation.getCurrentPosition( function( position ) {"
									.			"input.val( position.coords.latitude + ',' + position.coords.longitude );"
									.		"});"
									.	"});";

				$_CB_framework->outputCbJQuery( $js );

				$canGeoLocate		=	true;
			}

			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="address" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Address' ) . '</label>'
									.				'<div class="cb_field col-sm-9">';

			if ( $canGeoLocate ) {
				$return				.=					'<div class="input-group d-inline-flex w-auto">'
									.						$input['address']
									.						'<div class="input-group-append">'
									.							'<button type="button" class="btn btn-secondary gjButton gjButtonLocation"><span class="fa fa-map-marker"></span></button>'
									.						'</div>'
									.					'</div>'
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input the address for this event or click the map button to attempt to find your current location.' ) );
			} else {
				$return				.=					$input['address']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input the address for this event.' ) );
			}

			$return					.=				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_datetime cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="start" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Start Date' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['start']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Select the date and time this event starts.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_datetime cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="end" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'End Date' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['end']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally select the end date and time for this event.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="limit" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Guest Limit' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['limit']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input a guest limit for this event.' ) )
									.				'</div>'
									.			'</div>';

		if ( $isModerator ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the event owner id. Event owner determines the creator of the event specified as User ID.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( ( ! $isModerator ) && $plugin->params->getBool( 'groups_events_captcha', false ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<input type="submit" value="' . htmlspecialchars( ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Event' ) : CBTxt::T( 'Schedule Event' ) ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.					' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.				'</div>'
									.			'</div>'
									.			( ! $row->getInt( 'id', 0 ) ? '<input type="hidden" id="group" name="group" value="' . $group->getInt( 'id', 0 ) . '" />' : null )
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayEventEdit', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}