<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

namespace CB\Plugin\GroupJiveEvents\Trigger;

use CB\Plugin\GroupJiveEvents\Table\AttendanceTable;
use CB\Plugin\GroupJiveEvents\Table\EventTable;
use CB\Database\Table\UserTable;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * Deletes data when a user is deleted
	 *
	 * @param  UserTable $user
	 * @param  int       $status
	 */
	public function deleteEvents( $user, $status )
	{
		global $_CB_database;

		if ( $this->params->getBool( 'groups_events_delete', true ) ) {
			$query		=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
			$_CB_database->setQuery( $query );
			$events		=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJiveEvents\Table\EventTable', array( $_CB_database ) );

			/** @var EventTable[] $events */
			foreach ( $events as $event ) {
				$event->delete();
			}

			$query		=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events_attendance' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
			$_CB_database->setQuery( $query );
			$attendance	=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJiveEvents\Table\AttendanceTable', array( $_CB_database ) );

			/** @var AttendanceTable[] $attendance */
			foreach ( $attendance as $attend ) {
				$attend->delete();
			}
		}
	}
}