<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveEvents;

use CB\Plugin\GroupJiveEvents\Table\EventTable;

defined('CBLIB') or die();

class CBGroupJiveEvents
{
	/** @var EventTable[]  */
	private static $eventCache	=	array();

	/**
	 * Caches a prefetched array of events for reuse
	 *
	 * @param EventTable[] $events
	 */
	public static function prefetchEvents( $events )
	{
		foreach ( $events as $event ) {
			$rowId						=	$event->getInt( 'id', 0 );

			if ( ! $rowId ) {
				continue;
			}

			self::$eventCache[$rowId]	=	$event;
		}
	}

	/**
	 * returns a cached event object
	 *
	 * @param int $id
	 * @return EventTable
	 */
	public static function getEvent( $id )
	{
		if ( ! $id ) {
			return new EventTable();
		}

		if ( ! isset( self::$eventCache[$id] ) ) {
			$row					=	new EventTable();

			$row->load( (int) $id );

			self::$eventCache[$id]	=	$row;
		}

		return self::$eventCache[$id];
	}
}