<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Privacy\Field;

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Privacy\Privacy;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Privacy\CBPrivacy;

defined('CBLIB') or die();

class PrivacyField extends \cbFieldHandler
{

	/**
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @param string     $output
	 * @param string     $formatting
	 * @param string     $reason
	 * @param int        $list_compare_types
	 * @return mixed|null
	 */
	public function getFieldRow( &$field, &$user, $output, $formatting, $reason, $list_compare_types )
	{
		$return			=	null;

		if ( ( $output == 'htmledit' ) && in_array( $reason, array( 'edit', 'register' ) ) ) {
			$field->set( 'profile', 0 );
			$field->set( 'readonly', 0 );

			$return		=	parent::getFieldRow( $field, $user, $output, $formatting, $reason, $list_compare_types );
		}

		return $return;
	}

	/**
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @param string     $output
	 * @param string     $reason
	 * @param int        $list_compare_types
	 * @return mixed|null|string
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		if ( ( $output == 'html' ) || ( ( $output == 'htmledit' ) && ( $reason == 'search' ) ) ) {
			return null;
		}

		if ( $field->getString( 'type', '' ) == 'privacy' ) {
			$asset			=	str_replace( '[field_id]', $field->get( 'fieldid', 0, GetterInterface::INT ), $field->params->getString( 'privacy_asset', '' ) );

			if ( ! $asset ) {
				$asset		=	'profile.field.' . $field->get( 'fieldid', 0, GetterInterface::INT );

				if ( $field->get( '_isGrouped', false, GetterInterface::BOOLEAN ) ) {
					$asset	.=	'.group.' . $field->get( '_fieldGroupId', 0, GetterInterface::INT ) . '.row.' . $field->get( '_fieldGroupIndex', 0, GetterInterface::INT );
				}
			}
		} else {
			$asset			=	'profile';
		}

		$privacy			=	new Privacy( $asset, $user );

		$privacy->parse( $field->params, 'privacy_' );

		if ( in_array( $reason, array( 'edit', 'register' ) ) ) {
			$privacy->set( 'ajax', false );
		}

		$privacy->name( $field->getString( 'name', '' ) . '__privacy' );
		$privacy->set( 'field', $field->get( 'fieldid', 0, GetterInterface::INT ) );

		if ( $output == 'htmledit' ) {
			if ( ( ( ( $reason == 'edit' ) && CBPrivacy::getGlobalParams()->get( 'profile_simple_edit', false, GetterInterface::BOOLEAN ) )
				   || ( ( $reason == 'register' ) && CBPrivacy::getGlobalParams()->get( 'profile_simple_registration', false, GetterInterface::BOOLEAN ) )
				 )
				 && ( ! $field->get( '_privacyEdit', false, GetterInterface::BOOLEAN ) )
				 && ( $this->input( 'function', null, GetterInterface::STRING ) != 'ajax_edit' )
				 && ( ! in_array( $field->get( 'fieldid', 0, GetterInterface::INT ), explode( '|*|', CBPrivacy::getGlobalParams()->getString( 'profile_simple_exclude_fields', '' ) ) ) )
				 && ( ! $field->get( '_isGrouped', false, GetterInterface::BOOLEAN ) )
			) {
				CBPrivacy::getGroupedPrivacy( $field, $privacy );

				return null;
			}

			$selector		=	$privacy->privacy( 'edit' );

			if ( ! $selector ) {
				return null;
			}

			$return			=	$this->formatFieldValueLayout( $selector, $reason, $field, $user, false )
							.	$this->_fieldIconsHtml( $field, $user, $output, $reason, null, 'html', null, null, null, true, 0 );

			return $return;
		} else {
			return $this->_formatFieldOutput( $field->getString( 'name', '' ), ( $privacy->authorized() ? 1 : 0 ), $output, false );
		}
	}

	/**
	 * Renders a field row with title and description into $output html formating
	 *
	 * @param  FieldTable  $field       Using: name, type, title, description, fieldid, profile, displaytitle
	 * @param  UserTable   $user        User being rendered
	 * @param  string      $oValue      HTML of the field value to render
	 * @param  string      $output      'html', 'htmledit', NOT SUPPORTED IN THIS FUNCTION: 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist'
	 * @param  string      $formatting  'tr', 'td', 'div', 'span', 'none',   'table'??
	 * @param  string      $reason      'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'search' for searches
	 * @param  string[]    $rowClasses  CSS classes for the row
	 * @return string                   HTML rendering
	 */
	protected function renderFieldHtml( $field, $user, $oValue, $output, $formatting, $reason, $rowClasses )
	{
		/** @var Privacy|null $simplePrivacy */
		$simplePrivacy	=	$field->get( '_privacy', null, GetterInterface::RAW );

		if ( ! $simplePrivacy ) {
			return parent::renderFieldHtml( $field, $user, $oValue, $output, $formatting, $reason, $rowClasses );
		}

		$field->set( '_privacy', null );
		$field->set( '_privacyEdit', true );

		$return			=	$simplePrivacy->privacy( 'edit' )
						.	$this->_fieldIconsHtml( $field, $user, $output, $reason, null, 'html', null, null, null, true, 0 );

		return parent::renderFieldHtml( $field, $user, $return, $output, $formatting, $reason, array() );
	}

	/**
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @param array      $postdata
	 * @param string     $reason
	 */
	public function commitFieldDataSave( &$field, &$user, &$postdata, $reason )
	{
		if ( in_array( $reason, array( 'edit', 'register' ) ) ) {
			if ( $field->getString( 'type', '' ) == 'privacy' ) {
				$asset			=	str_replace( '[field_id]', $field->get( 'fieldid', 0, GetterInterface::INT ), $field->params->getString( 'privacy_asset', '' ) );

				if ( ! $asset ) {
					$asset		=	'profile.field.' . $field->get( 'fieldid', 0, GetterInterface::INT );

					if ( $field->get( '_isGrouped', false, GetterInterface::BOOLEAN ) ) {
						$asset	.=	'.group.' . $field->get( '_fieldGroupId', 0, GetterInterface::INT ) . '.row.' . $field->get( '_fieldGroupIndex', 0, GetterInterface::INT );
					}
				}
			} else {
				$asset			=	'profile';
			}

			$privacy			=	new Privacy( $asset, $user );

			if ( $reason == 'register' ) {
				$privacy->set( 'guest', true );
			}

			$privacy->parse( $field->params, 'privacy_' );

			if ( in_array( $reason, array( 'edit', 'register' ) ) ) {
				$privacy->set( 'ajax', false );
			}

			$privacy->name( $field->getString( 'name', '' ) . '__privacy' );
			$privacy->set( 'field', $field->get( 'fieldid', 0, GetterInterface::INT ) );

			if ( $privacy->getString( 'layout', 'button' ) == 'hidden' ) {
				return;
			}

			$privacy->privacy( 'save' );
		}
	}
}