(function($) {
	var instances = [];
	var cache = {};
	var methods = {
		init: function( options ) {
			return this.each( function () {
				var $this = this;
				var cbprivacy = $( $this ).data( 'cbprivacy' );

				if ( cbprivacy ) {
					return; // cbprivacy is already bound; so no need to rebind below
				}

				cbprivacy = {};
				cbprivacy.options = ( typeof options != 'undefined' ? options : {} );
				cbprivacy.defaults = $.fn.cbprivacy.defaults;
				cbprivacy.settings = $.extend( true, {}, cbprivacy.defaults, cbprivacy.options );
				cbprivacy.element = $( $this );
				cbprivacy.hasAddUser = ( $( $this ).find( 'option[value="USER-ADD"]' ).length > 0 );

				if ( cbprivacy.settings.useData ) {
					$.each( cbprivacy.defaults, function( key, value ) {
						if ( ( key != 'init' ) && ( key != 'useData' ) ) {
							// Dash Separated:
							var dataValue = cbprivacy.element.data( 'cbprivacy' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ) );

							if ( typeof dataValue != 'undefined' ) {
								cbprivacy.settings[key] = dataValue;
							} else {
								// No Separater:
								dataValue = cbprivacy.element.data( 'cbprivacy' + key.charAt( 0 ).toUpperCase() + key.slice( 1 ).toLowerCase() );

								if ( typeof dataValue != 'undefined' ) {
									cbprivacy.settings[key] = dataValue;
								}
							}
						}
					});
				}

				cbprivacy.element.trigger( 'cbprivacy.init.before', [cbprivacy] );

				if ( ! cbprivacy.settings.init ) {
					return;
				}

				cbprivacy.dropdownTemplate = function( option ) {
					if ( typeof option.id != 'undefined' ) {
						var text = $( option.element ).data( 'cbprivacy-option-text' );

						if ( typeof text == 'undefined' ) {
							text = option.text;
						}

						var icon = $( option.element ).data( 'cbprivacy-option-icon' );

						if ( typeof icon != 'undefined' ) {
							return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionIcon">' + icon + '</span><span class="flex-grow-1 cbPrivacySelectOptionText">' + text + '</span></span>' );
						} else {
							return $( '<span class="d-flex align-items-center"><span class=" cbPrivacySelectOptionNoIcon"></span><span class="flex-grow-1 cbPrivacySelectOptionText">' + text + '</span></span>' );
						}
					} else {
						return option.text;
					}
				};

				cbprivacy.selectionTemplate = function( option ) {
					if ( typeof option.id != 'undefined' ) {
						var text = $( option.element ).data( 'cbprivacy-option-text' );

						if ( typeof text == 'undefined' ) {
							text = option.text;
						}

						var icon = $( option.element ).data( 'cbprivacy-option-icon' );

						if ( cbprivacy.settings.layout == 'icon' ) {
							if ( typeof icon != 'undefined' ) {
								return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionIcon">' + icon + '</span></span>' );
							} else {
								return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionNoIcon"><span class="cbPrivacySelectOptionIconCustom fa fa-cog"></span></span></span>' );
							}
						} else {
							var value = cbprivacy.element.cbselect( 'get' );

							if ( value && ( value.length > 1 ) ) {
								return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionIcon">' + icon + '</span><span class="flex-grow-1 cbPrivacySelectOptionText">' + cbprivacy.settings.custom + '</span><span class="cbPrivacySelectOptionIconCaret fa fa-caret-down"></span></span>' );
							} else {
								if ( typeof icon != 'undefined' ) {
									return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionIcon">' + icon + '</span><span class="flex-grow-1 cbPrivacySelectOptionText">' + text + '</span><span class="cbPrivacySelectOptionIconCaret fa fa-caret-down"></span></span>' );
								} else {
									return $( '<span class="d-flex align-items-center"><span class="cbPrivacySelectOptionNoIcon"><span class="cbPrivacySelectOptionIconCustom fa fa-cog"></span></span><span class="flex-grow-1 cbPrivacySelectOptionText">' + text + '</span><span class="cbPrivacySelectOptionIconCaret fa fa-caret-down"></span></span>' );
								}
							}
						}
					} else {
						return option.text;
					}
				};

				cbprivacy.selectingHandler = function( e, cbselect, value ) {
					var selected = cbprivacy.element.cbselect( 'get' );
					var set = null;
					var unset = [];
					var close = true;

					if ( value == 0 ) {
						set = '0';
					} else if ( value == 1 ) {
						set = '1';
					} else if ( value == 99 ) {
						set = '99';
					} else if ( value == 2 ) {
						unset = ['0', '1', '99'];

						$.each( selected, function( i, v ) {
							if ( v.indexOf( 'CONN-' ) > -1 ) {
								unset.push( v );
							} else if ( v == 'USER-ADD' ) {
								unset.push( 'USER-ADD' );
							}
						});
					} else if ( value == 3 ) {
						$.each( selected, function( i, v ) {
							if ( v.indexOf( 'CONN-' ) > -1 ) {
								unset.push( v );
							} else if ( v == 'USER-ADD' ) {
								unset.push( 'USER-ADD' );
							}
						});

						if ( ! unset.length ) {
							close = false;
						}
					} else if ( value == 'USER-ADD' ) {
						close = false;

						unset.push( 'USER-ADD' );
					} else if ( value.indexOf( 'USER-' ) > -1 ) {
						close = false;

						unset = ['0', '1', '99'];
					} else {
						close = false;

						if ( selected.indexOf( '0' ) > -1 ) {
							unset.push( '0' );
						} else if ( selected.indexOf( '1' ) > -1 ) {
							unset.push( '1' );
						} else if ( selected.indexOf( '99' ) > -1 ) {
							unset.push( '99' );
						} else if ( selected.indexOf( 'USER-ADD' ) > -1 ) {
							unset.push( 'USER-ADD' );
						} else if ( value.indexOf( 'CONN-' ) > -1 ) {
							if ( selected.indexOf( '2' ) > -1 ) {
								unset.push( '2' );
							}

							if ( selected.indexOf( '3' ) > -1 ) {
								unset.push( '3' );
							}
						}
					}

					if ( set ) {
						cbprivacy.element.cbselect( 'set', set );
					}

					if ( unset.length ) {
						cbprivacy.element.cbselect( 'unset', unset );

						// Also be sure to force off the highlighting:
						var dropdown = cbprivacy.element.cbselect( 'dropdown' );

						if ( dropdown.length ) {
							$.each( unset, function( i, v ) {
								dropdown.find( '.select2-results__option[id$="-' + v + '"]' ).removeClass( 'select2-results__option--highlighted' ).attr( 'aria-selected', 'false' );
							})
						}
					}

					if ( close ) {
						cbprivacy.element.cbselect( 'close' );
					}
				};

				cbprivacy.openHandler = function() {
					if ( ( ! cbprivacy.hasAddUser ) || ( ! cbprivacy.settings.users ) ) {
						return;
					}

					setTimeout( function() {
						var dropdown = cbprivacy.element.cbselect( 'dropdown' );

						if ( ! dropdown.length ) {
							return;
						}

						var addUser = dropdown.find( '.cbPrivacySelectAddUser' );

						if ( ! addUser.length ) {
							return;
						}

						addUser.autocomplete({
							appendTo: dropdown,
							classes: {
								'ui-autocomplete': 'm-0 p-0 list-unstyled bg-white border border-top-0 rounded-top-0 rounded-bottom auto-overflow cbPrivacyAutoCompleteResults'
							},
							minLength: 2,
							open: function() {
								dropdown.find( '.select2-results > .select2-results__options' ).addClass( 'no-overflow' );
							},
							close: function() {
								dropdown.find( '.select2-results > .select2-results__options' ).removeClass( 'no-overflow' );
							},
							change: function() {
								addUser.val( '' );
							},
							select: function( event, ui ) {
								// Reset the search:
								addUser.val( '' );
								event.preventDefault();

								if ( ui.item == null ) {
									return;
								}

								var userValue = 'USER-' + ui.item.value;

								if ( cbprivacy.element.find( 'option[value="' + userValue + '"]' ).length ) {
									return;
								}

								// Generate the new option using select2 APIs:
								var dataAdapter = cbprivacy.element.data( 'select2' ).dataAdapter;

								var userItem = dataAdapter._normalizeItem({
									id: userValue,
									text: ui.item.label
								});

								userItem.selected = true;

								var userOption = dataAdapter.option( userItem );

								userOption.attr( 'data-cbprivacy-option-icon', '<span class="cbPrivacySelectOptionIconUser fa fa-user"></span>' );

								userItem.element = userOption.get( 0 );

								var userResult = $( cbprivacy.element.data( 'select2' ).results.option( userItem ) );

								userResult.attr( 'aria-selected', 'true' );

								// Insert the new option element:
								userOption.insertAfter( cbprivacy.element.find( 'option[value="USER-ADD"]' ) );
								addUser.closest( '.select2-results__options' ).append( userResult );

								// Add the new option to the child data of our optgroup:
								var optGroup = addUser.closest( '.select2-results__option[role="group"]' );
								var optData = addUser.closest( '.select2-results__option[role="group"]' ).data();

								optData.data.children.push( userItem );

								optGroup.data( optData );

								// Notify select2 that our value has changed:
								cbprivacy.element.trigger( 'change' );
								cbprivacy.selectingHandler( event, cbprivacy.cbselect, userValue );
							},
							source: function( request, response ) {
								var term = request.term;

								if ( term in cache ) {
									response( cache[term] );
									return;
								}

								if ( cbprivacy.element.hasClass( 'privacySearching' ) ) {
									response();
									return;
								}

								var post = { value: term };

								cbprivacy.element.addClass( 'privacySearching' );

								$.ajax({
									url: cbprivacy.settings.users,
									type: 'POST',
									dataType: 'json',
									data: post,
									converters: {
										'text json': function( result ) {
											try {
												return JSON.parse( result );
											} catch( e ) {
												return null;
											}
										}
									}
								}).done( function( data ) {
									cache[term] = data;

									response( data );
								}).fail( function() {
									response();
								}).always( function() {
									cbprivacy.element.removeClass( 'privacySearching' );
								});
							}
						}).autocomplete( 'widget' ).css({
							fontFamily: 'inherit',
							fontSize: 'inherit',
							maxHeight: '200px'
						}).menu( 'option', {
							classes: {
								'ui-menu-item': 'cbPrivacyAutoCompleteResult',
								'ui-menu-item-wrapper': 'm-0 p-2 bg-none border-0 text-inherit cbPrivacyAutoCompleteOption'
							},
							blur: function( event, ui ) {
								ui.item.removeClass( 'bg-primary cbPrivacyAutoCompleteActive' );
								ui.item.children( '.ui-menu-item-wrapper' ).removeClass( 'text-white' );
							},
							focus: function( event, ui ) {
								ui.item.addClass( 'bg-primary cbPrivacyAutoCompleteActive' );
								ui.item.children( '.ui-menu-item-wrapper' ).addClass( 'text-white' );
							}
						});
					}, 5 );
				};

				cbprivacy.closeHandler = function() {
					if ( ( ! cbprivacy.settings.ajax ) || cbprivacy.element.hasClass( 'privacySaving' ) ) {
						return;
					}

					var value = cbprivacy.element.cbselect( 'get' );

					if ( ( value == null ) || ( value.length == 0 ) ) {
						return;
					}

					if ( $.isArray( value ) && $.isArray( cbprivacy.selected ) && ( value.join( ',' ) == cbprivacy.selected.join( ',' ) ) ) {
						return;
					}

					cbprivacy.selected = value;

					var id = cbprivacy.element.attr( 'name' );
					var post = {};

					post[id] = value;

					$.ajax({
						url: cbprivacy.settings.ajax,
						type: 'POST',
						data: post,
						dataType: 'html',
						beforeSend: function( jqXHR, textStatus, errorThrown ) {
							cbprivacy.element.addClass( 'privacySaving' );
							cbprivacy.element.prop( 'disabled', true );
							cbprivacy.element.cbselect( 'container' ).addClass( 'privacySaving' );

							cbprivacy.element.triggerHandler( 'cbprivacy.ajax.send', [cbprivacy, jqXHR, textStatus, errorThrown] );
						}
					}).fail( function( jqXHR, textStatus, errorThrown ) {
						cbprivacy.element.triggerHandler( 'cbprivacy.ajax.error', [cbprivacy, jqXHR, textStatus, errorThrown] );
					}).done( function( data, textStatus, jqXHR ) {
						cbprivacy.element.removeClass( 'privacySaving' );
						cbprivacy.element.prop( 'disabled', false );
						cbprivacy.element.cbselect( 'container' ).removeClass( 'privacySaving' );

						cbprivacy.element.triggerHandler( 'cbprivacy.ajax.success', [cbprivacy, data, textStatus, jqXHR] );
					});
				};

				cbprivacy.changeHandler = function() {
					var value = cbprivacy.element.cbselect( 'get' );

					if ( ( value == null ) || ( value.length == 0 ) ) {
						cbprivacy.element.cbselect( 'set', cbprivacy.element.children( 'option[value!=""]:first' ).val() );
					}
				};

				if ( cbprivacy.settings.layout == 'tags' ) {
					cbprivacy.cbselect = cbprivacy.element.cbselect({
						width: 'auto',
						closeOnSelect: false,
						minimumResultsForSearch: Infinity,
						templateResult: cbprivacy.dropdownTemplate
					});
				} else {
					cbprivacy.cbselect = cbprivacy.element.cbselect({
						width: 'auto',
						closeOnSelect: false,
						minimumResultsForSearch: Infinity,
						templateSelection: cbprivacy.selectionTemplate,
						templateResult: cbprivacy.dropdownTemplate
					});
				}

				// Turn off some CB Select rebinding behavior as we'll deal with that in CB Privacy usage:
				cbprivacy.element.off( 'remove.cbselect destroy.cbselect' );
				cbprivacy.element.off( 'rebind.cbselect' );
				cbprivacy.element.off( 'modified.cbselect' );
				cbprivacy.element.off( 'cloning.cbselect' );

				cbprivacy.element.on( 'cbselect.selecting', cbprivacy.selectingHandler );

				if ( cbprivacy.hasAddUser && cbprivacy.settings.users ) {
					cbprivacy.element.on( 'cbselect.open', cbprivacy.openHandler );
				}

				if ( cbprivacy.settings.ajax ) {
					cbprivacy.element.on( 'cbselect.close', cbprivacy.closeHandler );
				}

				cbprivacy.element.on( 'change.cbprivacy', cbprivacy.changeHandler ).change();

				cbprivacy.selected = cbprivacy.element.cbselect( 'get' );

				// Destroy the cbprivacy element:
				cbprivacy.element.on( 'remove.cbprivacy destroy.cbprivacy', function() {
					cbprivacy.element.cbprivacy( 'destroy' );
				});

				// Rebind the cbprivacy element to pick up any data attribute modifications:
				cbprivacy.element.on( 'rebind.cbprivacy', function() {
					cbprivacy.element.cbprivacy( 'rebind' );
				});

				// If the cbprivacy element is modified we need to rebuild it to ensure all our bindings are still ok:
				cbprivacy.element.on( 'modified.cbprivacy', function( e, oldId, newId, index ) {
					if ( oldId != newId ) {
						cbprivacy.element.cbprivacy( 'rebind' );
					}
				});

				// If the cbprivacy is cloned we need to rebind it back:
				cbprivacy.element.on( 'cloning.cbprivacy', function() {
					$( this ).cbprivacy( 'destroy' );

					$( this ).on( 'rebind.cbprivacy', function() {
						$( this ).off( 'rebind.cbprivacy' ); // disgard this binding as we're done with it

						cbprivacy.element.cbprivacy( cbprivacy.options );
					});

					$( this ).on( 'cloned.cbprivacy', function() {
						$( this ).off( 'cloned.cbprivacy' ); // disgard this binding as we're done with it

						$( this ).cbprivacy( cbprivacy.options );
					});

					return true;
				});

				cbprivacy.element.trigger( 'cbprivacy.init.after', [cbprivacy] );

				// Bind the cbprivacy to the element so it's reusable and chainable:
				cbprivacy.element.data( 'cbprivacy', cbprivacy );

				// Add this instance to our instance array so we can keep track of our cbprivacy instances:
				instances.push( cbprivacy );
			});
		},
		rebind: function() {
			var cbprivacy = $( this ).data( 'cbprivacy' );

			if ( ! cbprivacy ) {
				return this;
			}

			cbprivacy.element.cbprivacy( 'destroy' );
			cbprivacy.element.cbprivacy( cbprivacy.options );

			return this;
		},
		destroy: function() {
			var cbprivacy = $( this ).data( 'cbprivacy' );

			if ( ! cbprivacy ) {
				return false;
			}

			cbprivacy.element.off( '.cbprivacy' );
			cbprivacy.element.off( 'cbselect.selecting', cbprivacy.selectingHandler );

			if ( cbprivacy.settings.ajax ) {
				cbprivacy.element.off( 'cbselect.close', cbprivacy.closeHandler );
			}

			cbprivacy.element.cbselect( 'destroy' );
			cbprivacy.element.removeData( 'cbprivacy' );

			$.each( instances, function( i, instance ) {
				if ( instance.element == cbprivacy.element ) {
					instances.splice( i, 1 );

					return false;
				}

				return true;
			});

			cbprivacy.element.trigger( 'cbprivacy.destroyed', [cbprivacy] );

			return true;
		},
		instances: function() {
			return instances;
		}
	};

	$.fn.cbprivacy = function( options ) {
		if ( ! $.fn.cbselect ) {
			return this; // this plugin entirely depends on cbselect and if it's not available then just give up
		}

		if ( methods[options] ) {
			return methods[ options ].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( ( typeof options === 'object' ) || ( ! options ) ) {
			return methods.init.apply( this, arguments );
		}

		return this;
	};

	$.fn.cbprivacy.defaults = {
		init: true,
		useData: true,
		layout: 'tags',
		custom: 'Custom',
		ajax: null,
		users: null
	};
})(jQuery);