<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Notifications;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var NotificationTable[] $rows
 * @var cbPageNav           $pageNav
 * @var UserTable           $viewer
 * @var Notifications       $stream
 * @var CBplug_cbactivity   $this
 * @var string              $output
 *
 * @var array               $integrations
 * @var string              $direction
 */

global $_CB_framework, $_PLUGINS;

$autoUpdate				=	false;
$attributes				=	' data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '" data-cbactivity-direction="' . htmlspecialchars( $direction ) . '"';

if ( $output !== 'modal' ) {
	if ( $rows && $stream->getBool( 'auto_update', false ) ) {
		$autoUpdate		=	true;

		$attributes		.=	' data-cbactivity-autoupdate="true"';
	}

	if ( $stream->getBool( 'auto_load', false ) ) {
		$attributes		.=	' data-cbactivity-autoload="true"';
	}
}
?>
<div class="<?php echo ( $output === 'modal' ? 'm-2 d-flex flex-column h-100 mh-100 ' : null ); ?>notificationsStream streamBind streamContainer streamContainer<?php echo htmlspecialchars( ucfirst( $direction ) ) . ( $output === 'modal' ? ' streamContainerModal' . ( ! $rows ? ' streamModalEmpty' : null ) : null ); ?> stream<?php echo htmlspecialchars( $stream->id() ); ?>"<?php echo $attributes; ?>>
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $rows ) { ?>
		<?php if ( $output === 'modal' ) { ?>
			<?php if ( ! $stream->getBool( 'hidden', false ) ) { ?>
			<div class="flex-shrink-0 row no-gutters notificationsStreamToolbar streamToolbar">
				<div class="col-12 col-sm text-center text-sm-left">
					<a href="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'show', 'stream' => $stream->id() ) ); ?>" class="btn btn-light btn-sm border btn-sm-block notificationsButton notificationsButtonSeeAll"><?php echo CBTxt::T( 'See All' ); ?></a>
					<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'delete', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="align-middle notificationsButton notificationsButtonDeleteAll streamItemAction" data-cbactivity-container="stream" data-cbactivity-confirm="<?php echo htmlspecialchars( CBTxt::T( 'Are you sure you want to delete all Notifications?' ) ); ?>" data-cbactivity-confirm-button="<?php echo htmlspecialchars( CBTxt::T( 'Delete All Notifications' ) ); ?>"><?php echo CBTxt::T( 'Delete All' ); ?></a>
				</div>
				<div class="col-12 col-sm mt-1 mt-sm-0 text-center text-sm-right">
					<a href="javascript:void(0);" class="align-middle notificationsButton notificationsButtonClose cbTooltipClose"><span class="fa fa-times"></span> <span class="d-inline-block d-sm-none"><?php echo CBTxt::T( 'Close' ); ?></span></a>
				</div>
			</div>
			<?php } else { ?>
			<div class="text-center text-sm-left notificationsStreamToolbar streamToolbar">
				<a href="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'show', 'stream' => $stream->id() ) ); ?>" class="btn btn-light btn-sm border btn-sm-block notificationsButton notificationsButtonSeeAll"><?php echo CBTxt::T( 'See All' ); ?></a>
			</div>
			<?php } ?>
		<?php } else { ?>
		<div class="text-center text-sm-left notificationsStreamToolbar streamToolbar">
			<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'delete', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="notificationsButton notificationsButtonDeleteAll streamItemAction" data-cbactivity-container="stream" data-cbactivity-confirm="<?php echo htmlspecialchars( CBTxt::T( 'Are you sure you want to delete all Notifications?' ) ); ?>" data-cbactivity-confirm-button="<?php echo htmlspecialchars( CBTxt::T( 'Delete All Notifications' ) ); ?>"><?php echo CBTxt::T( 'Delete All' ); ?></a>
		</div>
		<?php } ?>
	<?php } elseif ( $output === 'modal' ) { ?>
	<div class="flex-shrink-0 row no-gutters notificationsStreamToolbar streamToolbar">
		<div class="col-12 col-sm text-center text-sm-left">
			<?php echo CBTxt::T( 'No notifications to display.' ); ?>
		</div>
		<div class="col-12 col-sm mt-1 mt-sm-0 text-center text-sm-right">
			<a href="javascript:void(0);" class="notificationsButton notificationsButtonClose cbTooltipClose"><span class="fa fa-times"></span> <span class="d-inline-block d-sm-none"><?php echo CBTxt::T( 'Close' ); ?></span></a>
		</div>
	</div>
	<?php } ?>
	<?php if ( $autoUpdate ) { ?>
	<div class="notificationsStreamToolbar streamToolbar hidden">
		<a href="javascript: void(0);" data-cbactivity-update-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'notifications', 'func' => 'update', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="notificationsButton notificationsButtonUpdate streamUpdate hidden"><span class="fa fa-refresh"></span></a>
	</div>
	<?php } ?>
	<?php if ( ( $direction === 'up' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="notificationsStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block notificationsButton notificationsButtonMore streamMore"><?php echo CBTxt::T( 'Previous' ); ?></a>
	</div>
	<?php } ?>
	<div class="<?php echo ( $output === 'modal' ? 'ml-n2 mr-n2 pl-2 pr-2 flex-grow-1 ' : null ); ?>notificationsStreamItems streamItems"><?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'notifications/rows', false ); ?></div>
	<?php if ( ( $direction === 'down' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="notificationsStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block notificationsButton notificationsButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayNotificationsStream', array( $rows, $pageNav, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( in_array( $output, array( 'modal', 'toggle' ), true ) ? CBActivity::reloadHeaders() : null ); ?>
</div>
