<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\LikeTable;
use CB\Plugin\Activity\Likes;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var LikeTable[]       $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Likes             $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 */
$i	=	0;

foreach ( $rows as $row ) {
	$i++
?>
<div class="pb-2 col-12 col-sm-6 col-md-4<?php echo ( $i % 2 === 0 ? ' pl-sm-1' : ' pr-sm-1' ) . ( $i % 3 === 0 ? ' pr-md-0 pl-md-1' : ( $i % 3 === 2 ? ' pl-md-1 pr-md-1' : ' pl-md-0 pr-md-1' ) ); ?> streamItem likeContainer">
	<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'likes/container', false ); ?>
</div>
<?php } ?>
<?php if ( in_array( $output, array( 'load', 'update' ), true ) ) { ?>
	<?php if ( $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block mt-2 likesButton likesButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	<?php } ?>
	<?php echo CBActivity::reloadHeaders(); ?>
<?php } ?>