<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend connected activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework;

$profileId						=	(int) $matches[1];

if ( $stream instanceof NotificationsInterface ) {
	$viewer						=	CBuser::getMyUserDataInstance();

	if ( isset( $matches[3] ) ) {
		switch ( $matches[3] ) {
			case 'pending':
				if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
					$title		=	CBTxt::T( 'would like to connect with you' );

					$insert		=	'<div class="text-right notificationsButtonsConn">'
								.		'<a href="' . $_CB_framework->viewUrl( 'acceptconnection', true, array( 'connectionid' => $row->getInt( 'user_id', 0 ) ) ) . '" class="btn btn-sm btn-sm-block btn-success notificationsButton notificationsButtonAcceptConn">' . CBTxt::T( 'Accept' ) . '</a>'
								.		' <a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'UE_CONFIRMREMOVECONNECTION', 'Are you sure you want to remove this connection?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->viewUrl( 'denyconnection', true, array( 'connectionid' => $row->getInt( 'user_id', 0 ) ) ) ) . '\'; })" class="btn btn-sm btn-sm-block btn-danger notificationsButton notificationsButtonRejectConn">' . CBTxt::T( 'Reject' ) . '</a>'
								.	'</div>';
				} else {
					if ( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user', 0 ) ) {
						$title	=	CBTxt::T( 'connection request is pending' );

						$insert	=	'<div class="text-right notificationsButtonsConn">'
								.		'<a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'UE_CONFIRMREMOVECONNECTION', 'Are you sure you want to remove this connection?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->viewUrl( 'removeconnection', true, array( 'connectionid' => $row->getInt( 'user_id', 0 ) ) ) ) . '\'; })" class="btn btn-sm btn-sm-block btn-danger notificationsButton notificationsButtonCancelConn">' . CBTxt::T( 'Cancel Request' ) . '</a>'
								.	'</div>';
					} else {
						$row->set( 'link', $_CB_framework->userProfileUrl( $profileId, false ) );

						$title	=	CBTxt::T( 'ACTIVITY_WOULD_LIKE_CONNECT_WITH_USER', 'would like to connect with [user]', array( '[user]' => CBuser::getInstance( $profileId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
					}
				}
				break;
			case 'accepted':
				if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
					$row->set( 'link', $_CB_framework->userProfileUrl( $row->getInt( 'user_id', 0 ), false ) );

					$title		=	CBTxt::T( 'accepted your connection request' );
				} else {
					$row->set( 'link', $_CB_framework->userProfileUrl( $profileId, false ) );

					if ( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user', 0 ) ) {
						$title	=	CBTxt::T( 'connection request was accepted' );
					} else {
						$title	=	CBTxt::T( 'ACTIVITY_ACCEPTED_CONNECT_FROM_USER', 'accepted connection request from [user]', array( '[user]' => CBuser::getInstance( $profileId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
					}
				}
				break;
			case 'rejected':
				if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
					$row->set( 'link', $_CB_framework->userProfileUrl( $row->getInt( 'user_id', 0 ), false ) );

					$title		=	CBTxt::T( 'rejected your connection request' );
				} else {
					$row->set( 'link', $_CB_framework->userProfileUrl( $profileId, false ) );

					if ( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user', 0 ) ) {
						$title	=	CBTxt::T( 'connection request was rejected' );
					} else {
						$title	=	CBTxt::T( 'ACTIVITY_REJECTED_CONNECT_FROM_USER', 'rejected connection request from [user]', array( '[user]' => CBuser::getInstance( $profileId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
					}
				}
				break;
		}
	} else {
		$row->set( 'link', $_CB_framework->userProfileUrl( $profileId, false ) );

		if ( $viewer->getInt( 'id', 0 ) === $profileId ) {
			$title				=	CBTxt::T( 'is now connected with you' );
		} else {
			$title				=	CBTxt::T( 'ACTIVITY_IS_NOW_CONNECTED_WITH_USER', 'is now connected with [user]', array( '[user]' => CBuser::getInstance( $profileId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
		}
	}
} else {
	$title						=	CBTxt::T( 'ACTIVITY_IS_NOW_CONNECTED_WITH_USER', 'is now connected with [user]', array( '[user]' => CBuser::getInstance( $profileId, false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
}