<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Comments;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CommentTable[]    $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Comments          $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var array             $integrations
 * @var bool              $canCreate
 * @var bool              $isReply
 * @var string            $direction
 */

global $_CB_framework, $_PLUGINS;

$autoUpdate				=	false;
$attributes				=	' data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '" data-cbactivity-direction="' . htmlspecialchars( $direction ) . '"';

if ( $output !== 'modal' ) {
	if ( $rows && $stream->getBool( 'auto_update', false ) ) {
		$autoUpdate		=	true;

		$attributes		.=	' data-cbactivity-autoupdate="true"';
	}

	if ( $stream->getBool( 'auto_load', false ) ) {
		$attributes		.=	' data-cbactivity-autoload="true"';
	}
}
?>
<div class="<?php echo ( $output === 'modal' ? 'm-2 d-flex flex-column h-100 mh-100 ' : null ); ?>commentsStream streamBind streamContainer streamContainer<?php echo htmlspecialchars( ucfirst( $direction ) ) . ( $output === 'modal' ? ' streamContainerModal' : null ); ?> stream<?php echo htmlspecialchars( $stream->id() ) . ( $isReply && ( ! $rows ) ? ' hidden' : null ); ?>"<?php echo $attributes; ?>>
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $output === 'modal' ) { ?>
	<div class="<?php echo ( $output === 'modal' ? 'flex-shrink-0 ' : null ); ?>row no-gutters commentsStreamToolbar streamToolbar">
		<div class="col-12 col-sm text-center text-sm-left">
			<a href="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'show', 'stream' => $stream->id() ) ); ?>" class="btn btn-light btn-sm border btn-sm-block commentsButton commentsButtonSeeAll"><?php echo CBTxt::T( 'See All' ); ?></a>
		</div>
		<div class="col-12 col-sm mt-1 mt-sm-0 text-center text-sm-right">
			<a href="javascript:void(0);" class="align-middle commentsButton commentsButtonClose cbTooltipClose"><span class="fa fa-times"></span> <span class="d-inline-block d-sm-none"><?php echo CBTxt::T( 'Close' ); ?></span></a>
		</div>
	</div>
	<?php } ?>
	<?php if ( ( $direction === 'down' ) && $canCreate ) { ?>
		<?php $this->showCommentEdit( 0, $viewer, $stream, $output ); ?>
	<?php } ?>
	<?php if ( $autoUpdate ) { ?>
	<div class="commentsStreamToolbar streamToolbar hidden">
		<a href="javascript: void(0);" data-cbactivity-update-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'update', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-primary btn-sm commentsButton commentsButtonUpdate streamUpdate hidden"><span class="fa fa-refresh"></span></a>
	</div>
	<?php } ?>
	<?php if ( ( $direction === 'up' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
		<?php if ( $rows && ( ! $isReply ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
		<div class="<?php echo ( $output === 'modal' ? 'flex-shrink-0 ' : null ); ?>row no-gutters commentsStreamToolbar streamToolbar">
			<div class="col-6">
				<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="commentsButton commentsButtonMore streamMore"><?php echo CBTxt::T( 'Show older comments' ); ?></a>
			</div>
			<div class="col-6 text-right">
				<span class="badge badge-light border font-weight-normal commentsStreamCount streamCount"><span class="fa fa-comments commentsStreamCountIcon streamCountIcon"></span> <?php echo CBTxt::T( 'COMMENTS_COUNT', '[comments] Comment|[comments] Comments|%%COUNT%%', array( '%%COUNT%%' => $pageNav->total, '[comments]' => CBActivity::getFormattedTotal( $pageNav->total ) ) ); ?></span>
			</div>
		</div>
		<?php } else { ?>
		<div class="commentsStreamToolbar streamToolbar streamMoreContainer">
			<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="commentsButton commentsButtonMore streamMore"><?php echo CBTxt::T( 'Show older comments' ); ?></a>
		</div>
		<?php } ?>
	<?php } elseif ( $rows && ( ! $isReply ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="text-right commentsStreamToolbar streamToolbar">
		<span class="badge badge-light border font-weight-normal commentsStreamCount streamCount"><span class="fa fa-comments commentsStreamCountIcon streamCountIcon"></span> <?php echo CBTxt::T( 'COMMENTS_COUNT', '[comments] Comment|[comments] Comments|%%COUNT%%', array( '%%COUNT%%' => $pageNav->total, '[comments]' => CBActivity::getFormattedTotal( $pageNav->total ) ) ); ?></span>
	</div>
	<?php } ?>
	<div class="<?php echo ( $output === 'modal' ? 'ml-n2 mr-n2 pl-2 pr-2 flex-grow-1 ' : null ); ?>commentsStreamItems streamItems"><?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'comments/rows', false ); ?></div>
	<?php if ( ( $direction === 'up' ) && $canCreate ) { ?>
		<?php $this->showCommentEdit( 0, $viewer, $stream, $output ); ?>
	<?php } ?>
	<?php if ( ( $direction === 'down' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="commentsStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="commentsButton commentsButtonMore streamMore"><?php echo CBTxt::T( 'Show more comments' ); ?></a>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayCommentsStream', array( $rows, $pageNav, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( in_array( $output, array( 'modal', 'toggle' ), true ) ? CBActivity::reloadHeaders() : null ); ?>
</div>