<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Comments;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CommentTable      $row
 * @var UserTable         $viewer
 * @var Comments          $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $pinnedTooltip
 * @var string            $reportedTooltip
 */

global $_CB_framework, $_PLUGINS;

$canModerate					=	CBActivity::canModerate( $stream );
$rowId							=	md5( $stream->id() . '_' . $row->getInt( 'id', 0 ) );
$rowOwner						=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );

if ( $row->getBool( 'system', false ) ) {
	$message					=	$row->getHtml( 'message' );
} else {
	$message					=	htmlspecialchars( $row->getString( 'message' ) );
}

$date							=	null;
$insert							=	null;
$footer							=	null;
$menu							=	array();

$integrations					=	implode( '', $_PLUGINS->trigger( 'activity_onDisplayStreamComment', array( &$row, &$message, &$insert, &$date, &$footer, &$menu, $stream, $output ) ) );

if ( $integrations ) {
	$footer						=	$integrations . $footer;
}

$message						=	$stream->parser( $message, $row )->parse( array( 'linebreaks' ) );
$action							=	( CBActivity::findParamOverride( $row, 'actions', false, $stream ) ? $stream->parser( $row->action( $stream ), $row )->parse( array( 'linebreaks' ) ) : null );
$location						=	( CBActivity::findParamOverride( $row, 'locations', false, $stream ) ? $row->location( $stream ) : null );
$tags							=	null;

if ( CBActivity::findParamOverride( $row, 'tags', false, $stream ) ) {
	$tags						=	$row->tags( $stream )->tags( 'tagged' );

	if ( $tags ) {
		$tags					=	CBTxt::T( 'COMMENT_TAGS', 'with [tags]', array( '[tags]' => $tags ) );
	}
}

if ( $action || $location || $tags ) {
	$subContent					=	( $action ? $action : null )
								.	( $location ? ( $action ? ' ' : null ) . $location : null )
								.	( $tags ? ( $action || $location ? ' ' : null ) . $tags : null );

	$message					.=	' <span class="streamItemSubContent">&mdash; ' . $subContent . '</span>';
}

if ( ( ! $row->isHidden() ) && CBActivity::findParamOverride( $row, 'likes', false, $stream ) ) {
	$like						=	$row->likes( $stream )->likes( 'button' );

	if ( $like ) {
		$date					.=	( $date ? ' ' : null ) . '&nbsp;-&nbsp; ' . $like;
	}
}

if ( ( ! $row->isHidden() ) && CBActivity::findParamOverride( $row, 'replies', false, $stream ) ) {
	$replies					=	$row->replies( $stream )->comments();

	if ( $replies ) {
		if ( CBActivity::canCreate( 'reply', $stream ) ) {
			$date				.=	( $date ? ' ' : null ) . '<span class="streamToggle streamToggleReplies" data-cbactivity-toggle-target=".commentsStream,.commentContainerNew" data-cbactivity-toggle-close="false" data-cbactivity-toggle-filter="false" data-cbactivity-toggle-active-classes="hidden">&nbsp;-&nbsp; <a href="javascript: void(0);"><span class="fa fa-comments-o"></span> ' . CBTxt::T( 'Reply' ) . '</a></span>';
		}

		if ( $footer ) {
			$footer				.=	'<div class="streamPanelFooterDivider border-default"></div>';
		}

		$footer					.=	$replies;
	}
}

$modified						=	$row->params()->getString( 'modified' );

if ( $modified ) {
	$modified					=	cbTooltip( null, cbFormatDate( $modified ), null, 'auto', null, '<span class="fa fa-edit"></span>', null, 'class="align-text-top streamIconEdited" data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' );
}

$theme							=	$row->theme( $stream );
$themeClasses					=	null;
$themeStyles					=	null;

if ( $theme ) {
	$themeClasses				=	' ' . trim( 'streamMessageTheme ' . htmlspecialchars( $theme['class'] ) );
	$themeStyles				=	( $theme['background'] ? ' style="background-image: url(' . htmlspecialchars( $theme['background'] ) . ')"' : null );
}

$menuItems						=	null;

if ( CBActivity::findParamOverride( $row, 'menu', true ) && ( $canModerate || $rowOwner || ( $viewer->getInt( 'id', 0 ) && ( ! $rowOwner ) ) || $menu ) ) {
	if ( $viewer->getInt( 'id', 0 ) && ( $row->isHidden() || ( ! $rowOwner ) ) ) {
		$hideUser				=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'profile', 0, true );

		if ( $row->isHidden() ) {
			if ( $row->getString( '_hidden_user' ) && ( ! $row->getBool( 'system', false ) ) ) {
				$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'unhide', 'type' => 'user', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'UNHIDE_COMMENTS_FROM_USER', 'Unhide Comments from <span class="text-info">[user]</span>', array( '[user]' => $hideUser ) ) . '</a></li>';
			}

			if ( $row->getString( '_hidden_asset' ) ) {
				$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'unhide', 'type' => 'asset', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'Unhide similar Comments' ) . '</a></li>';
			}

			if ( $row->getString( '_hidden_id' ) ) {
				$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'unhide', 'type' => 'comment', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemUnhide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-unlock-alt"></span> ' . CBTxt::T( 'Unhide this Comment' ) . '</a></li>';
			}
		} elseif ( ! $rowOwner ) {
			$menuItems			.=		( ! $row->getBool( 'system', false ) ? '<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'hide', 'type' => 'user', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'ARE_YOU_SURE_HIDE_COMMENTS_FROM_USER', 'Are you sure you want to hide all Comments from <span class="text-info">[user]</span>?', array( '[user]' => $hideUser ) ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'HIDE_COMMENTS_FROM_USER_BUTTON', 'Hide Comments from <strong>[user]</strong>', array( '[user]' => $hideUser ) ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'HIDE_COMMENTS_FROM_USER', 'Hide Comments from <span class="text-info">[user]</span>', array( '[user]' => $hideUser ) ) . '</a></li>' : null )
								.		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'hide', 'type' => 'asset', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to hide all Comments similar to this Comment?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Hide similar Comments' ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'Hide similar Comments' ) . '</a></li>'
								.		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'hide', 'type' => 'comment', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemHide streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to hide this Comment?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Hide this Comment' ) ) . '"><span class="fa fa-lock"></span> ' . CBTxt::T( 'Hide this Comment' ) . '</a></li>';
		}

		if ( $canModerate || $rowOwner || $menu ) {
			$menuItems			.=		'<li class="streamItemMenuItem"><div class="dropdown-divider"></div></li>';
		}
	}

	if ( $canModerate || $rowOwner ) {
		if ( $stream->getBool( 'pinned', true ) && Application::MyUser()->isGlobalModerator() && ( ! $row->isHidden() ) ) {
			if ( $row->isPinned( $stream ) ) {
				$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'unpin', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemEdit streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-star-o"></span> ' . CBTxt::T( 'Unpin this Comment' ) . '</a></li>';
			} else {
				$menuItems		.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'pin', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemEdit streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-star"></span> ' . CBTxt::T( 'Pin this Comment' ) . '</a></li>';
			}
		}

		if ( CBActivity::canEdit( $row, $stream, $viewer ) ) {
			$menuItems			.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemEdit streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';
		}

		if ( CBActivity::canDelete( $row, $stream, $viewer ) ) {
			$menuItems			.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemDelete streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to delete this Comment?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Delete Comment' ) ) . '"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
		}
	}

	if ( CBActivity::getGlobalParams()->getBool( 'reporting', true ) && $viewer->getInt( 'id', 0 ) && ( ! $rowOwner ) && ( ! $canModerate ) && ( ! CBActivity::canModerate( $stream, $row->getInt( 'user_id', 0 ) ) ) && ( ! $row->isHidden() ) ) {
		$menuItems				.=		'<li class="streamItemMenuItem"><a href="javascript: void(0);" data-cbactivity-action-url="' . $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'report', 'id' => $row->getInt( 'id', 0 ), 'stream' => $stream->id() ), 'raw', 0, true ) . '" class="dropdown-item commentMenuItemReport streamItemAction" data-cbactivity-container=".streamItem' . $rowId . '" data-cbactivity-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to report and hide this Comment?' ) ) . '" data-cbactivity-confirm-button="' . htmlspecialchars( CBTxt::T( 'Report and Hide this Comment' ) ) . '"><span class="fa fa-exclamation-circle"></span> ' . CBTxt::T( 'Report this Comment' ) . '</a></li>';
	}

	if ( $menu ) {
		$menuItems				.=		'<li class="streamItemMenuItem">' . implode( '</li><li class="streamItemMenuItem">', $menu ) . '</li>';
	}

	if ( $menuItems ) {
		$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 streamItemMenuItems commentMenuItems streamItemActions" data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '">'
								.		$menuItems
								.	'</ul>';
	}
}
?>
<div class="<?php echo ( $stream->getBool( 'inline', false ) ? 'position-relative streamItemInline ' : 'd-block card' . ( $row->isPinned( $stream ) ? ' panel-warning' : null ) . ' streamPanel ' ); ?>streamItem<?php echo ( $row->isPinned( $stream ) ? ' streamItemPinned' : null ); ?> commentContainer streamItem<?php echo $rowId; ?>" data-cbactivity-id="<?php echo $row->getInt( 'id', 0 ); ?>" data-cbactivity-timestamp="<?php echo Application::Date( $row->getString( 'date' ), 'UTC' )->getTimestamp(); ?>">
	<div class="<?php echo ( ! $stream->getBool( 'inline', false ) ? 'card-header bg-transparent border-0 p-0 streamPanelHeading ' : null ); ?>commentContainerHeader">
		<div class="<?php echo ( ! $stream->getBool( 'inline', false ) ? 'm-2 ' : null ); ?>media streamMedia commentContainerHeaderInner">
			<div class="media-left streamMediaLeft commentContainerLogo">
				<?php echo CBActivity::getOwnerAvatar( $row ); ?>
			</div>
			<div class="media-body pl-2 pr-5 text-small streamMediaBody commentContainerTitle">
				<div class="text-wrap commentContainerTitleTop<?php echo ( $message ? ' commentContainerContent' : null ); ?>">
					<?php if ( $message ) { ?>
						<?php if ( $themeClasses || $themeStyles ) { ?>
						<?php echo CBActivity::getOwnerName( $row ); ?>
						<div class="commentContainerContentInner cbMoreLess<?php echo $themeClasses; ?>"<?php echo $themeStyles; ?>>
							<div class="streamItemContent cbMoreLessContent clearfix">
								<?php echo $message; ?>
							</div>
							<div class="fade-edge cbMoreLessOpen hidden">
								<a href="javascript: void(0);" class="cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
							</div>
						</div>
						<?php } else { ?>
						<div class="commentContainerContentInner cbMoreLess">
							<div class="streamItemContent cbMoreLessContent clearfix">
								<?php echo CBActivity::getOwnerName( $row ); ?>
								<?php echo $message; ?>
							</div>
							<div class="fade-edge cbMoreLessOpen hidden">
								<a href="javascript: void(0);" class="cbMoreLessButton"><?php echo CBTxt::T( 'See More' ); ?></a>
							</div>
						</div>
						<?php } ?>
					<?php } else { ?>
						<?php echo CBActivity::getOwnerName( $row ); ?>
					<?php } ?>
				</div>
				<div class="text-muted commentContainerTitleBottom">
					<?php echo cbTooltip( null, cbFormatDate( $row->getString( 'date' ) ), null, 'auto', null, cbFormatDate( $row->getString( 'date' ), true, 'timeago' ), null, 'data-hascbtooltip="true" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' ); ?>
					<?php echo $modified; ?>
					<?php echo $date; ?>
				</div>
			</div>
		</div>
	</div>
	<?php if ( $insert ) { ?>
	<div class="<?php echo ( ! $stream->getBool( 'inline', false ) ? 'card-body p-0 streamPanelBody ' : null ); ?>streamItemDisplay commentContainerInsert">
		<div class="pl-2 <?php echo ( ! $stream->getBool( 'inline', false ) ? 'm-1' : 'mt-1' ); ?> commentContainerInsertInner"><?php echo $insert; ?></div>
	</div>
	<?php } ?>
	<?php if ( CBActivity::findParamOverride( $row, 'links', false, $stream ) && $row->attachments()->count() ) { ?>
	<div class="<?php echo ( ! $stream->getBool( 'inline', false ) ? 'card-body p-0 streamPanelBody ' : null ); ?>streamItemDisplay commentContainerAttachments">
		<div class="pl-2 <?php echo ( ! $stream->getBool( 'inline', false ) ? 'm-1' : 'mt-1' ); ?> commentContainerAttachmentsInner">
			<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/display', false ); ?>
		</div>
	</div>
	<?php } ?>
	<?php if ( $footer ) { ?>
	<div class="<?php echo ( ! $stream->getBool( 'inline', false ) ? 'card-body p-0 streamPanelBody ' : null ); ?>streamItemDisplay commentContainerFooter">
		<div class="pl-2 <?php echo ( ! $stream->getBool( 'inline', false ) ? 'm-2' : 'mt-1' ); ?> commentContainerInner"><?php echo $footer; ?></div>
	</div>
	<?php } ?>
	<?php if ( $row->isPinned( $stream ) || $row->params()->getInt( 'reports', 0 ) || $menuItems ) { ?>
	<div class="<?php echo ( ! $menuItems ? 'd-none d-sm-block ' : null ); ?>position-absolute<?php echo ( ! $stream->getBool( 'inline', false ) ? ' pr-2 pt-2' : null ); ?> text-right text-small streamItemMenu commentContainerMenu">
		<?php if ( $row->isPinned( $stream ) ) { ?>
		<span class="fa fa-star text-warning streamItemPinnedIcon"<?php echo $pinnedTooltip; ?>></span>
		<?php } ?>
		<?php if ( $row->params()->getInt( 'reports', 0 ) ) { ?>
		<span class="fa fa-warning text-danger streamItemReportedIcon"<?php echo $reportedTooltip; ?>></span>
		<?php } ?>
		<?php if ( $menuItems ) { ?>
			<?php echo cbTooltip( null, $menuItems, null, 'auto', null, '<span class="ml-2 fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu streamItemMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' ); ?>
		<?php } ?>
	</div>
	<?php } ?>
	<?php echo ( $output === 'save' ? CBActivity::reloadHeaders() : null ); ?>
	<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-light streamLoading hidden"><div class="spinner-border spinner-border-sm"></div></div>
</div>
