<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Comments;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable         $viewer
 * @var Comments          $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var int               $total
 * @var string            $layout
 * @var bool              $autoUpdate
 */

global $_CB_framework, $_PLUGINS;

$attributes			=	' data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '"';

if ( $autoUpdate ) {
	$attributes		.=	' data-cbactivity-autoupdate="true"';
}
?>
<span class="commentsStreamButton streamBind streamContainer streamContainerButton stream<?php echo htmlspecialchars( $stream->id() ); ?>"<?php echo $attributes; ?>>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onBeforeDisplayCommentsStreamButton', array( $total, $viewer, &$stream ) ) );; ?>
	<?php if ( $layout === 'toggle' ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'toggle', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="btn btn-light btn-sm border text-muted streamItemAction" data-cbactivity-container="stream" data-cbactivity-action-output="replace" data-cbactivity-action-target="stream">
		<span class="fa fa-lg fa-comments-o"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
		<span class="streamLoading hidden"><span class="spinner-border spinner-border-sm text-secondary"></span></span>
	</a>
	<?php } else { ?>
	<a href="javascript: void(0);" class="d-none d-sm-inline-block btn btn-light btn-sm border text-muted cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-open-event="click" data-cbtooltip-close-event="click" data-cbtooltip-button-close="false" data-cbtooltip-width="auto" data-cbtooltip-height="auto" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad commentsModalContainer" data-cbtooltip-open-classes="border-primary text-primary" data-cbtooltip-close-classes="border text-muted" data-cbtooltip-content-classes="p-0">
		<span class="fa fa-lg fa-comments-o"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
	</a>
	<a href="javascript: void(0);" class="d-inline-block d-sm-none btn btn-light btn-sm border text-muted cbTooltip streamModal" data-cbactivity-modal-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'modal', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" data-cbtooltip-modal="true" data-cbtooltip-button-close="false" data-cbtooltip-width="90%" data-cbtooltip-height="90%" data-cbtooltip-open-solo=".commentsModalContainer" data-cbtooltip-classes="streamModalContainer streamModalContainerLoad commentsModalContainer" data-cbtooltip-open-classes="border-primary text-primary" data-cbtooltip-close-classes="border text-muted" data-cbtooltip-content-classes="p-0">
		<span class="fa fa-lg fa-comments-o"></span>
		<?php echo ( $total ? CBActivity::getFormattedTotal( $total ) : null ); ?>
	</a>
	<?php } ?>
	<?php if ( $autoUpdate ) { ?>
	<a href="javascript: void(0);" data-cbactivity-action-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'comments', 'func' => 'button', 'stream' => $stream->id() ), 'raw', 0, true ); ?>" class="streamItemAction streamRefresh hidden" data-cbactivity-container="stream" data-cbactivity-action-output="replace" data-cbactivity-action-target="stream">
		<span class="fa fa-refresh"></span>
	</a>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayCommentsStreamButton', array( $total, $viewer, $stream ) ) ); ?>
	<?php echo ( $output === 'refresh' ? CBActivity::reloadHeaders() : null ); ?>
</span>